#!/bin/bash
#
# Copyright (c) 2012-2014 by Cisco Systems, Inc.
# All Rights Reserved.
#------------------------------------------------------------------

#echo "$0:  $@ with count $#"

#  sftp://user@server:/directory/file file2 file3
#  ftp://user@server:/directory/file file2 file3
#  scp://user@server:/directory/file file2 file3
#  tftp://server/directory/file file2 file3
#  /directory/file file2 file3

   orig_line=$(echo $@)

   if [[ $orig_line =~ .*,.* ]]
   then
       echo -e "\ninstall add command cannot contain ',' characters\n"
       exit
   fi

   new_line=$(echo $@ | tr ":/@" "   ")
#  echo "new_line is $new_line"
   first_word=`echo $new_line | cut -d' ' -f1`
#  echo "first_word is $first_word" 

   if [ $first_word == "scp" ]; then 
#    This is the format expected scp://user@server:/directory/ file file2 file3 

#    Obtain user name 
     username=`echo $orig_line |  cut -d '@' -f 1 | cut -d '/' -f 3`
#    echo "username: $username"

#    Obtain server name
     server=`echo $orig_line   | cut -d '@' -f 2 | cut -d ':' -f 1`
#    echo $server

    source_dir=`echo $orig_line   | cut -d ' ' -f 1 | cut -d ':' -f 3`
#    echo "source dir is $source_dir"

#    The all_files contains the rest of the files under parent directory
     all_files=`echo $orig_line | cut -d ' ' -f 2-`
     all_files=$(echo $all_files)

#     echo "all files is $all_files"

     cmd_begin="install add-internal addtype $first_word "
     cmd_middle="user ${username} server ${server} source ${source_dir}"
     cmd_end="files [ $all_files ]"

  elif [ $first_word == "sftp" ] || [ $first_word == "ftp" ]; then
#    This is the format expected sftp://userid@server:/directory/ file file2 file3
#    Obtain user name
     username=`echo $orig_line |  cut -d '@' -f 1 | cut -d '/' -f 3`
#    echo "username: $username"

#    Obtain server name
     server=`echo $orig_line   | cut -d '@' -f 2 | cut -d '/' -f 1 | cut -d ':' -f 1`
#    echo $server

    password="NULL"
#Prompt for password. and wait for 60 seconds for user to enter password
    echo -n  Password:
    read -s -t 60  password
    status=$? 
    echo ""
#   if password prompt get timed out, then create file timeout.check
    if [ $status -ne 0 ] ; then touch /opt/cisco/calvados/script/timeout.check ; fi
    
    if [ -z "$password" ]; then
        password="NULL"
    fi

    source_dir_temp=`echo $orig_line   | cut -d ' ' -f 1 | cut -d '@' -f 2`
    source_dir=`echo "${source_dir_temp#*/}" | sed "s|^|/|g"`
#    echo "source dir is $source_dir"


#    The all_files contains the rest of the files under parent directory
     all_files=`echo $orig_line | cut -d ' ' -f 2-`
     all_files=$(echo $all_files)

#     echo "all files is $all_files

if [ -n "$first_word" ] && [ -n "$username" ] && [ -n "$password" ] && [ -n "$server" ]  && [ -n "$source_dir" ]  && [ -n "$all_files" ]; then
             cmd_begin="install add-internal addtype $first_word "
             cmd_middle="user ${username} password ${password} server ${server} source ${source_dir}"
             cmd_end="files [ $all_files ]"
             else
                 echo "Syntax error"        
             fi
      
         elif [ $first_word == "tftp" ]; then

#   This is the format expected tftp://server/directory/ file file2 file3
     username="none"
     server=`echo  $orig_line | cut -d '/' -f 3`
#     echo "server $server"

     source_dir=`echo $orig_line | cut -d ' ' -f 1 | cut -d '/' -f 4-`

     all_files=`echo $orig_line | cut -d ' ' -f 2-`
     all_files=$(echo $all_files)

     cmd_begin="install add-internal addtype $first_word"
     cmd_middle="user ${username} server ${server} source ${source_dir}"
     cmd_end="files [ $all_files ]"

   elif [ $first_word == "src" ]; then
#   src /ws/gludwig-sjc yang.iso yang2.iso yang3.iso
#   echo "cp with src"
    type="cp"
    new_line=$@
    directory=$(echo $new_line | cut -d' ' -f2)
#    echo "directory is $directory"
    files=$(echo $new_line | cut -d' ' -f3-)
    files=$(echo $files | tr "," " ")
   
#    echo "files is $files"

    cmd_begin="install add-internal addtype $type src $directory "
    cmd_middle="files [ ${files} ] "
   else 
#     echo "cp without src"
     type="cp"
     new_line=$@
     source_dir=`echo $new_line | cut -d ' ' -f 1`
     files=$(echo $new_line | cut -d ' ' -f 2-)

#     echo "files $files"

     cmd_begin="install add-internal addtype $type "
     cmd_middle="source ${source_dir}"
     cmd_end="files [ $files ] "
 
   fi 
 
#   echo "cmd_begin $cmd_begin"
#   echo "cmd_middle is $cmd_middle"
#   echo "cmd_end is $cmd_end"
    
    output="/opt/cisco/calvados/bin/vrfch.sh CTRL_VRF /opt/cisco/calvados/confd/bin/maapi --clicmd --unhide internal-command \"${cmd_begin} ${cmd_middle} ${cmd_end}\""

#   echo $output

   /opt/cisco/calvados/bin/vrfch.sh CTRL_VRF /opt/cisco/calvados/confd/bin/maapi --clicmd --unhide internal-command "${cmd_begin} ${cmd_middle} ${cmd_end}"


