#!/bin/bash
#
# Copyright (c) 2012-2018 by Cisco Systems, Inc.
# All Rights Reserved.
#------------------------------------------------------------------

action_cmd=$1

#echo "$0:  $@ with count $#"

 cmd_end=""

 case ${action_cmd} in

      --xtrct_pkgs)
        cmd_begin="install extract-internal packages ["
            for ((i = 2; i<=$#; i++)); do
               if [[ ${!i} =~ .*,.* ]]
               then
                  echo -e "\ninstall command cannot contain ',' characters\n"
                  exit
               else
                  cmd_middle="${cmd_middle} ${!i}"
               fi
            done
        cmd_end=" ]"
        ;;

      --rmv_pkgs) 
        cmd_begin="install remove-internal packages ["
            for ((i = 2; i<=$#; i++)); do
               if [[ ${!i} =~ .*,.* ]]
               then
                  echo -e "\ninstall command cannot contain ',' characters\n"
                  exit
               else
                  cmd_middle="${cmd_middle} ${!i}"
               fi
            done
        cmd_end=" ]"
        ;;

      --rmv_inact) 
        cmd_begin="install remove-internal inactive "
        ;;

      --rmv_ids) 
        cmd_begin="install remove-internal id ["
            for ((i = 2; i<=$#; i++)); do
               if [[ ${!i} =~ .*,.* ]]
               then
                  echo -e "\ninstall command cannot contain ',' characters\n"
                  exit
               else
                  cmd_middle="${cmd_middle} ${!i}"
               fi
            done
        cmd_end=" ]"
        ;;

      --prepare) 
        cmd_begin="install prepare-internal packages ["
            for ((i = 2; i<=$#; i++)); do
               if [[ ${!i} =~ .*,.* ]]
               then
                  echo -e "\ninstall command cannot contain ',' characters\n"
                  exit
               else
                  cmd_middle="${cmd_middle} ${!i}"
               fi
            done
        cmd_end=" ]"
        ;;

      --deact_pkgs) 
        end=$# 
        if [[ ${!end} && ${!end} == "--noprompt" ]]; then
            cmd_begin="install deactivate-internal noprompt packages ["
            (( end-- ))
        else 
        cmd_begin="install deactivate-internal packages ["
        fi
            for ((i = 2; i<=$end; i++)); do
               if [[ ${!i} =~ .*,.* ]]
               then
                  echo -e "\ninstall command cannot contain ',' characters\n"
                  exit
               else
                  cmd_middle="${cmd_middle} ${!i}"
               fi
            done
        cmd_end=" ]"
        ;;

      --deact_sup)
        cmd_begin="install deactivate-internal superseded "
        ;;

      --deact_ids) 
        end=$# 
        if [[ ${!end} && ${!end} == "--noprompt" ]]; then
            cmd_begin="install deactivate-internal noprompt id ["
            (( end-- ))
        else 
        cmd_begin="install deactivate-internal id ["
        fi
            for ((i = 2; i<=$end; i++)); do
               if [[ ${!i} =~ .*,.* ]]
               then
                  echo -e "\ninstall command cannot contain ',' characters\n"
                  exit
               else
                  cmd_middle="${cmd_middle} ${!i}"
               fi
            done
        cmd_end=" ]"
        ;;

   --deactivate_issu)
       # ISSU deactivate - call ISSU Yang schema.
       pkgs=""
       ids=""

       shift
       while getopts ":p:i:" opt; do
           case $opt in
               p)
                   pkgs="packages [ $OPTARG"

                   # May have more than one argument
                   idx=$OPTIND
                   while ! [[ "${!idx}" =~ ^-.* ]] && ! (( idx > $# )) ; do
                       pkgs="${pkgs} ${!idx}"
                       ((idx++))
                   done
                   OPTIND=idx

                   pkgs="${pkgs} ]" ;;

               i)
                   ids="ids [ $OPTARG"

                   # May have more than one argument
                   idx=$OPTIND
                   while ! [[ "${!idx}" =~ ^-.* ]] && ! (( idx > $# )) ; do
                       ids="${ids} ${!idx}"
                       ((idx++))
                   done
                   OPTIND=idx

                   ids="${ids} ]" ;;
           esac
       done
       cmd_begin="issu deactivate"
       cmd_middle=""
       cmd_end="${pkgs} ${ids}"
       ;;

       *)
         echo "Invalid command"
       esac


#echo "begin:" ${cmd_begin}


 /opt/cisco/calvados/bin/vrfch.sh CTRL_VRF /opt/cisco/calvados/confd/bin/maapi --clicmd --unhide internal-command "${cmd_begin} ${cmd_middle} ${cmd_end}"

