#!/bin/bash
#
# Copyright (c) 2012-2015, 2017-2018 by Cisco Systems, Inc.
# All Rights Reserved.
#------------------------------------------------------------------
source /opt/cisco/calvados/bin/disk_space_precheck.sh
action_cmd=$1
cmd_end=""
#echo "got: $@"
#echo "param1: $1"
#echo "param2: $2"

#  4 forms:
#
# install prepare <wildcard>
#   install prepare one,two,three
#   install prepare id 6
#   install clean

#this code sets us up for the id test later on.
#echo "action_cmd $action_cmd"

#echo "id_variant $id_variant"
#echo "id_first_cut $id_first_cut"
#echo "id_second_cut $id_second_cut"

    cmd_begin="install prepare-internal "
    if [[ $1 == "--clean" ]]; then
#       echo "clean variant"
       cmd_middle="clean"

    elif [[ $1 == "--ids" ]]; then
#        echo "id variant"
        cmd_middle="id [ "

        for ((i=2; i<=$#; i++)); do
#           echo "Parameter $i is ${!i}"
            if [[ ${!i} =~ .*,.* ]]
            then
               echo -e "\ninstall command cannot contain ',' characters\n"
               exit
            else
               cmd_middle="${cmd_middle} ${!i}"
            fi
        done
        cmd_end=" ]"
    elif [[ $1 == "--issu" ]]; then
        # ISSU Prepare - call ISSU Yang schema.
        pkgs=""
        ids=""
        activate=""

        shift
        while getopts ":p:i:a" opt; do
            case $opt in
                p)
                    pkgs="packages [ $OPTARG"

                    # May have more than one argument
                    idx=$OPTIND
                    while ! [[ "${!idx}" =~ ^-.* ]] && ! (( idx > $# )) ; do
                        pkgs="${pkgs} ${!idx}"
                        ((idx++))
                    done
                    OPTIND=idx

                    pkgs="${pkgs} ]" ;;

                i)
                    ids="ids [ $OPTARG"

                    # May have more than one argument
                    idx=$OPTIND
                    while ! [[ "${!idx}" =~ ^-.* ]] && ! (( idx > $# )) ; do
                        ids="${ids} ${!idx}"
                        ((idx++))
                    done
                    OPTIND=idx

                    ids="${ids} ]" ;;

                a)
                    activate="activate true" ;;
            esac
        done

        # Command begins issu_action because the container for action commands
        # within the ISSU component has that name.
        cmd_begin="issu_action prepare"
        cmd_middle=""
        cmd_end="${pkgs} ${ids} ${activate}"
    else
#       echo "packages deviant"
        echo "Package list:"
        cmd_begin="install prepare-internal packages [ "
        #echo "Check for wildcards"
        sp_regex="$(get_sp_regex)"
        for j in "$@" ; do
        echo "$j" | grep -q "\*\|\?"
        if [ $? == 0 ]; then
           #echo "Argument is a wildcard"
           num_pkg=`ls /install_repo/gl/calvados/$j 2>/dev/null | wc -w`
           if [[ num_pkg -eq 0 ]]; then
                echo "No matching packages found"
                exit 0
           fi
           list=(`ls /install_repo/gl/calvados/$j 2>/dev/null | cut -d " " -f 1- | cut -d "/" -f 5`)
           bootstrap_cfg="/etc/init.d/calvados_bootstrap.cfg"
           if [[ -z $platform ]]; then
               platform="$(grep "^[  ]*PLATFORM=" "$bootstrap_cfg" | cut -d'=' -f2)"
               if [[ -z $platform ]]; then
                   echo "Error: Unable to get platform name"
                   exit 0
               fi
           fi
           for ((i=0; i<num_pkg; i++)); do
              grep -q ${list[$i]} /install_repo/local/clos-swprofile-active.txt
              if [[ $? -ne 0 ]]; then
                 ret=$(echo ${list[$i]} | grep -E "$sp_regex")
                 if [[ -n $ret ]]; then
                    continue
                 fi
                 #Check for tp pkg
                 echo ${list[$i]} | grep -q -v "$platform"
                 ret=$?
                 if [ $ret -eq 0 ]; then
                    pkg_list[$i]=`echo ${list[$i]}`
                    continue 
                 fi
                 #Check for host pkg
                 case "${list[$i]}" in
                     *sysadmin-hostos*)
                         pkg_list[$i]=`echo ${list[$i]}`
                         continue
                     ;;
                     *spirit-boot*)
                         pkg_list[$i]=`echo ${list[$i]}`
                         continue
                     ;;
                 esac
                 is_sp_rpm="$(get_sp_rpms_from_input /misc/disk1/tftpboot prepared ${list[$i]})"
                 
	             if [[ -z $is_sp_rpm ]]; then 
                     pkg_list[$i]=`echo ${list[$i]}`
                 fi
              fi
           done
           read -a pkg_list_arr <<< ${pkg_list[@]}
           for ((i=0; i<$num_pkg; i++)); do
              if [[ -n "${pkg_list_arr[$i]}" ]]; then
                  echo "${pkg_list_arr[$i]}"
              else
                  continue
              fi
              if [[ ${pkg_list_arr[$i]} =~ .*,.* ]]
              then
                 echo -e "\ninstall command cannot contain ',' characters\n"
                 exit
              else
                 cmd_middle="${cmd_middle} ${pkg_list_arr[$i]}"
              fi
           done
           if [[ -z "$cmd_middle" ]]; then
               echo "No matching packages found"
               exit 0
           fi
        else
#              echo "$j"
              if [[ $j =~ .*,.* ]]
              then
                  echo -e "\ninstall command cannot contain ',' characters\n"
                  exit
              else
                  cmd_middle="${cmd_middle} $j"
              fi
        fi
        done
        cmd_end=" ]"
    fi

#echo "middle is $cmd_middle"
echo "cmd is = ${cmd_begin} ${cmd_middle} ${cmd_end}" >> /tmp/inst_act_cmd.cmd
/opt/cisco/calvados/bin/vrfch.sh CTRL_VRF /opt/cisco/calvados/confd/bin/maapi --clicmd --unhide internal-command "${cmd_begin} ${cmd_middle} ${cmd_end}"
