#!/bin/bash
#
# Calvados_patch_lxc_iso.sh
#
# This script is used by install to plug in any platform 
# specifics for lxc.
# 
# It is called from both pxe_install.sh and install C code.
#
# Copyright (c) 2012, 2014-2019 by cisco Systems, Inc.
# All rights reserved.

# do not exit on failed commands
#
source /etc/init.d/calvados_bootstrap.cfg
set +e

function update_cmdline()
{
lxc_cmdline_loc=$1
host_cmdline=`cat /proc/cmdline`
lxc_cmdline=`cat $lxc_cmdline_loc`
for token in $host_cmdline
    do
       if [[ $token =~ ^__ ]]; then
            echo $lxc_cmdline | grep -q "\<$token\>" -
            if [ $? -ne 0 ]; then
                sed -i "s;\(platform=\);$token \1;g" $lxc_cmdline_loc
            fi
       fi
    done

}

function modify_init_console_para()
{
    XROOT=$1
    devc_con=`ls -l ${XROOT}/pkg/init.d/devc_conaux_con.init | awk '{print $11}'`
    devc_aux=`ls -l ${XROOT}/pkg/init.d/devc_conaux_aux.init | awk '{print $11}'`

    ACTIVE_SERIAL_XR_CON="pts/0"
    ACTIVE_SERIAL_XR_AUX="pts/1"

    #
    # Allow platform to override ACTIVE_SERIAL_XR_CON/AUX
    #
    declare -F platform_enable_xr_con &>/dev/null && platform_enable_xr_con
    sed -i "s;hvc0;$ACTIVE_SERIAL_XR_CON;g" ${XROOT}/${devc_con}

    declare -F platform_enable_xr_aux &>/dev/null && platform_enable_xr_aux
    if [ -n "$ACTIVE_SERIAL_XR_AUX" ]; then
        sed -i "s;hvc1;$ACTIVE_SERIAL_XR_AUX;g" ${XROOT}/${devc_aux}
    else
        if [[ ! -f "${devc_aux}" ]]; then
            touch ${devc_aux}
        fi
        rm -rf  ${XROOT}/pkg/init.d/devc_conaux_aux.init
    fi
}
readonly -f modify_init_console_para

function uninstall_rpms ()
{
    if [[ ! -f "$1" ]]; then
        return
    fi

    declare -F platform_uninstall_rpms_pre &>/dev/null && platform_uninstall_rpms_pre ${XROOT}
    while read line; do
        if [[ ! $line == \#* ]] && [[ ! $line == "" ]]; then
            echo "$(date): Uninstalling rpm $line"

            # don't care if this fails
            chroot ${XROOT} rpm -e --allmatches $line > /dev/null 2>&1
        fi
    done < $1
    declare -F platform_uninstall_rpms_post &>/dev/null && platform_uninstall_rpms_post ${XROOT}
}
readonly -f uninstall_rpms

function setuid_bit ()
{
    # restore setuid bit that is lost in OS SDK and XR build process
    # for the following commands
    commands=(/usr/bin/sudo 
              /bin/su.shadow
              /bin/ping.iputils
             )

    for cmd in "${commands[@]}"
    do
        chmod u+s ${XROOT}/$cmd
    done
}
readonly -f setuid_bit

HOST_LV_BASENAME="host_lv"
XROOT="$1"
LVG_NAME="$2"
LV_ID="$3"
LV_NAME="${HOST_LV_BASENAME}${LV_ID}"
VM_TYPE="$4"

if [ -z "$XROOT" ]; then
    echo "Error! $XROOT not found" 
    exit 1
fi

if [ ! -d "$XROOT" ]; then
    echo "Error! $XROOT not a directory"
    exit 2
fi

echo "$(date): Starting Calvados patch for $VIRT_METHOD for $VM_TYPE"
source ${XROOT}/etc/rc.d/init.d/spirit-functions
on_sim

declare -F platform_log &>/dev/null && platform_log \
        "Patch $VM_TYPE"

uninstall_rpms /etc/sysconfig/rpm_blacklist_${VM_TYPE}.txt

setuid_bit


case $VM_TYPE in
    "hostos") 
        xrnginstall_platform_patch_hostos ${XROOT} ${LVG_NAME}          \
                ${LV_NAME} ${PLATFORM} ${SIMULATION} ${VIRT_METHOD}
        # create symlink for panini.shutdown in rc0.d
        ln -sf /etc/init.d/panini.shutdown ${XROOT}/etc/rc0.d/S29panini.shutdown

        # Relabel hostos partition files for the platforms support SElinux
        if [[ -z "$NO_SELINUX" ]]; then
            /etc/rc.d/init.d/0selinux-init noreboot
        fi
    ;;
    "sysadmin-vm")
        xrnginstall_platform_patch_calvados ${XROOT} ${PLATFORM}        \
                ${SIMULATION} ${VIRT_METHOD} ${LV_ID}
        update_cmdline ${XROOT}/root/cmdline
        # create symlink for panini.shutdown in rc0.d
        ln -sf /etc/init.d/panini.shutdown ${XROOT}/etc/rc0.d/S29panini.shutdown

        mkdir -p ${XROOT}/etc/profile.d
        cat > ${XROOT}/etc/profile.d/pi_calvados.profile <<%%
LD_LIBRARY_PATH=/opt/cisco/calvados/usr/lib64
export LD_LIBRARY_PATH
%%
        chmod +x ${XROOT}/etc/profile.d/pi_calvados.profile
        # Relabel sysadmin partition files for the platforms support SElinux
        if [[ -z "$NO_SELINUX" ]]; then
            /etc/rc.d/init.d/0selinux-init noreboot
        fi

        declare -F platform_update_cmdline &>/dev/null && \
            platform_update_cmdline ${XROOT}/root/cmdline
    ;;
    "xr-vm")
        xrnginstall_platform_patch_xr ${XROOT} ${PLATFORM}        \
                ${SIMULATION} ${VIRT_METHOD} ${LV_ID}
        update_cmdline ${XROOT}/root/cmdline
        # create symlink for panini.shutdown in rc0.d
        ln -sf /etc/init.d/panini.shutdown ${XROOT}/etc/rc0.d/S29panini.shutdown
        modify_init_console_para ${XROOT}

        # Relabel xr-vm partition files for the platforms support SElinux
        if [[ -z "$NO_SELINUX" ]]; then
            /etc/rc.d/init.d/0selinux-init noreboot
        fi

        declare -F platform_update_cmdline &>/dev/null && \
            platform_update_cmdline ${XROOT}/root/cmdline
    ;;
    "uvf-vm")
        xrnginstall_platform_patch_uvf ${XROOT} ${PLATFORM}        \
                ${SIMULATION} ${VIRT_METHOD} ${LV_ID}
        update_cmdline ${XROOT}/root/cmdline

        declare -F platform_update_cmdline &>/dev/null && \
            platform_update_cmdline ${XROOT}/root/cmdline
        ;;
esac
                
echo "$(date): Finished Calvados patch for $VIRT_METHOD"
