#!/bin/bash 
# console_lib.sh
# Console_mux and Console_wait library
#      
# Copyright (c) 2015-2016 by Cisco Systems, Inc.

VIRSH_VM_CMD="virsh"
VIRSH_LXC_CMD="virsh -c lxc:///"

function get_lxc_name_from_wc {
    lxc_wc=$1

    if [[ "$VIRT_METHOD" == "lxc" ]]; then
        lxc=$($VIRSH_LXC_CMD list --all | grep -e "${lxc_wc}" | grep "running")
    else
        lxc=$($VIRSH_VM_CMD list --all | grep -e "${lxc_wc}" | grep "running")
    fi
    if [[ $? -ne 0 ]]; then
       return $?
    fi

    eval $2=$(echo $lxc | awk '{print $2}')
    return 0
}

function check_lxc {
    lxc_name=$1
    if [[ "$VIRT_METHOD" == "lxc" ]]; then
        $VIRSH_LXC_CMD list --all | grep -e "${lxc_name}" | grep -q "running"
    else
        $VIRSH_VM_CMD list --all | grep -e "${lxc_name}" | grep -q "running"
    fi
}

function get_lxc_port {
    local domain=''
    local xml=''
    local console_type=''
    local proto_type=''
    local port=0

    domain="$1"
    if [[ "$VIRT_METHOD" == "lxc" ]]; then
        xml=`$VIRSH_LXC_CMD dumpxml $domain |
            sed -n '/<console/,/<\/console>/p'`
    else
        xml=`$VIRSH_VM_CMD dumpxml $domain |
            sed -n '/<console/,/<\/console>/p'`
    fi
    #parse xml
    console_type=`echo "$xml" | sed -n "/<console type/p" |
                 sed "s/^[^']*'//; s/'.*//" | sed -n 1p`
    proto_type=`echo "$xml" | sed -n "/<protocol type/p" |
               sed "s/^[^']*'//; s/'.*//" | sed -n 1p`
    if [[ "$console_type" == "tcp" ]] &&
       [[ "$proto_type" == "telnet" ]]; then
        port=`echo "$xml" | sed -n "/service/p" |
             sed "s/^.*service/service/; s/^[^']*'//; s/'.*//" | sed -n 1p`
    fi

    #return
    eval $2="'$port'"
}
