#!/bin/bash
#
# This script sets variables in the emt structure. Created for migration to IOS XR 32 Bit (classic XR)
#
# Copyright (c) 2014-2017, 2019 by Cisco Systems, Inc.
# All rights reserved.

source /etc/init.d/ipu-functions.sh
BOOT_FILENAME_OFF=0x0f0
# Refer BINFO_FLEN_V2 in libasr9kpd:bootinfo.h
BINFO_FLEN_V2=128

function set_value_in_emt()
{
        local paddr=$1
        local hex_value=$2
        local field_name=$3
        pcimemwrite `printf "%x" $paddr` 4 "$hex_value" >/dev/null 2>&1
        pcimemread `printf "%x" $paddr` 0x4 | grep -v PCI | awk '{ print $3 ; }' | grep $hex_value >/dev/null 2>&1
        if [[ $? -ne 0 ]]; then
                error_exit "Error: Failed to correctly write $field_name."
        fi
}

function set_boot_filename()
{
        local boot_filename=$1
        # convert each unsigned char to two digit hex, i.e., "a" to 61
        # can revert back from hex to char like this - echo 61 | xxd -r -p
        local hex_boot_filename=""
        for (( i=0; i<${#boot_filename}; i++ )); do
                hex_boot_filename=$hex_boot_filename$(printf "%02x" "'${boot_filename:$i:1}");
        done

        local boot_filename_paddr=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $BOOT_FILENAME_OFF))
        # Writing the boot filename in hex 4 bytes/8 nibbles at a time
        for (( i=0; i<$(($BINFO_FLEN_V2 * 2)); i=i+8 )); do
                if [[ $i -lt ${#hex_boot_filename} ]]; then
                        local hex_trunk="${hex_boot_filename:$i:8}"
                        # pad trailing zeros if the trunk takes less than 4 bytes long
                        if [[ ${#hex_trunk} -lt 8 ]]; then
                                hex_trunk=$hex_trunk$(printf '0%.0s' $(seq 1 $((8-${#hex_trunk}))))
                        fi
                        # Need to reverse the order of the bytes to maintain the correct filename in memory
                        local hex_trunk_rev=${hex_trunk:6:2}${hex_trunk:4:2}${hex_trunk:2:2}${hex_trunk:0:2}
                        set_value_in_emt $boot_filename_paddr $hex_trunk_rev "boot filename/path"
                else
                        set_value_in_emt $boot_filename_paddr 00000000 "boot filename/path"
                fi
                boot_filename_paddr=$(($boot_filename_paddr + 0x4))
        done
}

# Update turbo boot flag IOS XR 32 Bit 
/opt/cisco/calvados/bin/nvram_dump -s TURBOBOOT=on

# Update turbo migration flag IOS XR 32 Bit 
/opt/cisco/calvados/bin/nvram_dump -s MIGRATE=0

# Update Boot parameter flag IOS XR 32 Bit 
/opt/cisco/calvados/bin/nvram_dump -s BOOT=

# Update RMEMVA variable
/opt/cisco/calvados/bin/nvram_dump -s RMEMVA=

# Update reboot mode to turbo boot IOS XR 32 Bit (emt mode 9)
set_value_in_emt $EMT_MODE_PADDR 00000009 "boot mode"

ERROR_WARNING="!!!!!!!!!!!!!!! ERROR ERROR ERROR ERROR ERROR ERROR !!!!!!!!!!!!!!!"
MSG_HELP="Please run '/etc/init.d/migrate_to_cXR -h' for instructions."
error_exit() {
    echo $ERROR_WARNING
    echo "$*" 
    echo "$MSG_HELP"
    exit 1 
}

