# This script sets the BOOT mode to IOS XR 32 Bit
#
# Copyright (c) 2014-2017, 2019 by Cisco Systems, Inc.
# All rights reserved.

source /etc/init.d/set_emt_value_lib.sh
source /etc/init.d/spirit_pd.sh

while [ $# -gt 0 ]; do
    case "$1" in
        -b|--boot)
            shift
            if [[ "$1" != "eusb" ]]; then
                error_exit "Error: Invalid input."
            fi
            BOOT_TYPE="$1"
            shift
            ;;
        -m|--bootup_slot)
            shift
			shift
            ;;
        -r|--reboot)
            shift
            REBOOT_AUTOMATICALLY=1
            ;;
        *)
            error_exit "Error: Invalid input detected."
            ;;
	esac
done

/opt/cisco/calvados/bin/nvram_dump -s MIGRATE=1
echo "Updated MIGRATE flag."

IMAGE=$(find /eusbb | grep -m 1 "asr9k-mini-px.vm.*")
IMAGE_NAME=${IMAGE#/eusbb/}
if [ -z "${IMAGE}" ]; then
	echo "No ASR9K 32 Bit IOS XR image in harddiskb:/."
else
    eusb_drive=$(get_card_specific_value EUSB_DRIVE)
    if [ -z "$eusb_drive" ]; then
        eusb_drive="fs1"
    fi
    /opt/cisco/calvados/bin/nvram_dump -s RMEMVA=
    echo "Unset RMEMVA"
    
    /opt/cisco/calvados/bin/nvram_dump -s BOOT=$eusb_drive:$IMAGE_NAME
    echo "Updated boot filename to $IMAGE_NAME"
fi
