#!/bin/bash == 
# calvados/asr9k_pkg/boot/scripts/xrnginstall-asr9k-pd.sh
# This script has asr9k specific install functions
#
# Copyright (c) 2014-2020 by Cisco Systems, Inc.
# All rights reserved.

source /etc/rc.d/init.d/pd-functions

function platform_uninstall_rpms_pre {

    if [[ ! -d $1/etc ]]; then
        return
    fi

    if [[ ! -f $1/etc/mtab ]]; then
        touch $1/etc/mtab
    fi
}

function platform_uninstall_rpms_post {

    if [[ ! -s $1/etc/mtab ]]; then
        rm $1/etc/mtab
    fi
}

function xrnginstall_a9k_remove_simbridge {
    rm -f ${rootdir}/etc/rc.d/rc2.d/S20simBridge >& /dev/null
    rm -f ${rootdir}/etc/rc.d/rc3.d/S20simBridge >& /dev/null
    rm -f ${rootdir}/etc/rc.d/rc4.d/S20simBridge >& /dev/null
    rm -f ${rootdir}/etc/rc.d/rc5.d/S20simBridge >& /dev/null
    rm -f ${rootdir}/etc/init.d/simBridge >& /dev/null
}

function xrnginstall_a9k_remove_sysinit_noise {
    local rootdir="$1"

    # xrnginstall_platform_patch_xr is called twice
    if [[ -f ${rootdir}/etc/rc.d/rc.sysinit.orig ]]; then
        return
    fi

    # suppress noisy rc.sysinit errors
    cp ${rootdir}/etc/rc.d/rc.sysinit ${rootdir}/etc/rc.d/rc.sysinit.orig
    # usb mount error
    sed -i '/^if.*usb/{N;N;N;N;d;}' ${rootdir}/etc/rc.d/rc.sysinit
    # /var mount error
    sed -i '/mount -n .var$/d' ${rootdir}/etc/rc.d/rc.sysinit
    # /dev/tty mknod error
    sed -i -e 's;mknod -m 600 /dev/tty c 5 0;if [[ ! -c /dev/tty ]]\; then &\; fi\;;' ${rootdir}/etc/rc.d/rc.sysinit
}

function xrnginstall_a9k_remove_sysctl_noise {
    local rootdir="$1"

    # Remove unknown sysctl keys in LXC
    sed -i '/net.core.wmem_default/d' ${rootdir}/etc/sysctl.conf
    sed -i '/net.core.netdev_max_backlog/d' ${rootdir}/etc/sysctl.conf
    sed -i '/net.core.optmem_max/d' ${rootdir}/etc/sysctl.conf
    sed -i '/net.ipv4.udp_mem/d' ${rootdir}/etc/sysctl.conf
    sed -i '/net.ipv4.udp_rmem_min/d' ${rootdir}/etc/sysctl.conf
    sed -i '/net.ipv4.udp_wmem_min/d' ${rootdir}/etc/sysctl.conf
}

function xrnginstall_a9k_tidy_starting_messages {
    local rootdir="$1"
    if [[ -f ${rootdir}/etc/init.d/tftpd-hpa ]]; then
        sed -i "/echo.*\"\.\"/d" ${rootdir}/etc/init.d/tftpd-hpa
    fi
    if [[ -f ${rootdir}/etc/init.d/sshd ]]; then
        sed -i "/echo.*done\./d" ${rootdir}/etc/init.d/sshd
    fi
}

function xrnginstall_a9k_set_sysctl_params {
    ARCH=`arch`

    if [ "${ARCH}" == "x86_64" ]; then
        cat >> ${rootdir}/etc/sysctl.conf <<%%
net.core.rmem_max = 67108864
net.core.wmem_max = 67108864
net.core.rmem_default = 67108864
net.core.wmem_default = 67108864
net.core.netdev_max_backlog = 300000
net.core.optmem_max = 67108864
net.ipv4.udp_mem = 1124736     10000000  67108864
net.ipv4.udp_rmem_min = 1124736
net.ipv4.udp_wmem_min = 1124736
vm.max_map_count=131072
#
# Increased usage of ctrace facilities is skirting the default inotify watch
# limit of 8K on some platforms (with stress tests etc). Increase to future-proof.
# Should not increase any memory usage, as kernel does not pre-allocate.
# Also increase max_user_instances to 32K from 8K default.
#
fs.inotify.max_user_watches = 32768
fs.inotify.max_user_instances = 32768

%%
    fi
}

function smart_daemon_host_configuration() {
cat <<EOF >| ${rootdir}/etc/smartd.conf
# Below attributes are added to the smart configuration.
# - Scan all devices
# - Ignore the attributes
#   -- Attribute 9:   Power-On Time Count
#   -- Attribute 194: HDD Temperature
#   -- Attribute 231: Hard Disk Temperature
# - Periodic test
#   -- Offline test every 6 hrs.
#   -- slef-test every hr.
# - errors reported in the Summary SMART error log has increased since the last
#   check.
DEVICESCAN -H -l selftest -l error -f -t -I 9 -I 194 -I 231 -s (O/../.././(00|06|12|18)|S/../.././(01|02|03|04|05|07|08|09|10|11|13|14|15|16|17|19|20|21|22|23))
EOF
}

# Enable S.M.A.R.T monitoring of SSD under host OS.
function smart_deamon_host(){
    local rootdir="$1"
    smart_daemon_host_configuration
 
    local cmd=$(grep -ci local7 ${rootdir}/etc/default/smartmontools)
    if [ "$cmd" == "0" ]; then
        # redirect smartd logs to syslog facility local7 for collection
        sed -i "\$asmartd_opts=\"-l local7\"" ${rootdir}/etc/default/smartmontools
    fi 
    
    cmd=$(grep -ci smartd.log ${rootdir}/etc/syslog.conf)
    if [ "$cmd" == "0" ]; then
        # add entry to syslog.conf entry for SMART logs collection
        sed -i '/user.log/a local7.* \t\t\t-\/var\/log\/smartd.log' ${rootdir}/etc/syslog.conf
    fi

} 
 

function xrnginstall_a9k_patch_hostos {
    local rootdir="$1"
    xrnginstall_a9k_set_sysctl_params

    pd_pxe_copy_bake_binaries ${rootdir}

    if [[ "${BOARDTYPE}" == "LC" ]]; then
        grep "xhci_hcd" ${rootdir}/etc/modprobe.d/blacklist.conf
        if [[ $? != 0 ]]; then
            echo "blacklist xhci_hcd" >> ${rootdir}/etc/modprobe.d/blacklist.conf
        fi
    fi

    sed -i '/tty0/d' ${rootdir}/etc/inittab
    sed -i '/tty1/d' ${rootdir}/etc/inittab
    if [ "$BOARDTYPE" == "RP" ]; then
        sed -i '/ttyS0/d' ${rootdir}/etc/inittab
    else
        sed -i '/ttyS1/d' ${rootdir}/etc/inittab
    fi
    rm -f ${rootdir}/etc/rcS.d/S*udev
    rm -f ${rootdir}/etc/rc3.d/S20dnsmasq
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} spirit       defaults 97  3 > /dev/null 2>&1

    xrnginstall_a9k_remove_sysinit_noise ${rootdir}
    xrnginstall_a9k_tidy_starting_messages ${rootdir}
    sed -i -e "s;virsh -c;virsh -q -c;" ${rootdir}/etc/init.d/nwbridge
    sed -i -e "s;^modprobe.*mdio;# A9K disable - &;" ${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules
    sed -i 's/VMTYPE=.*/VMTYPE=hostos/g' ${rootdir}/etc/init.d/calvados_bootstrap.cfg

    # Patch host_auth for controlling noise
    patch_host_auth ${rootdir}

    if [ "$VIRT_METHOD" == "vm" ]; then
        smart_deamon_host $1
        # Create qemu-153 soft link.
        ln -sf qemu ${rootdir}/usr/share/qemu-153
    fi
}

function xrnginstall_a9k_patch_remove_incompatible_calvados_files {
    local rootdir="$1"
    local filepath

    local a9k_incompatible_cal_files=(                                           \
            "opt/cisco/calvados/packages/asr9k-*/etc/startup/sfe_driver.startup" \
            "opt/cisco/calvados/etc/startup/sfe_driver.startup"                  \ 
            # "opt/cisco/calvados/packages/asr9k-*/etc/startup/rvm_mgr.startup"    \
            # "opt/cisco/calvados/etc/startup/rvm_mgr.startup"                     \
        )

    for filepath in ${a9k_incompatible_cal_files[*]}; do 
        rm ${rootdir}/${filepath}  > /dev/null 2>&1
    done
}

function xrnginstall_a9k_patch_calvados {
    local rootdir="$1"
    ARCH=`arch`
    
    if [[ $VIRT_METHOD == "vm" ]]; then
        xrnginstall_a9k_set_sysctl_params    
    fi

    xrnginstall_a9k_patch_remove_incompatible_calvados_files "$rootdir" 
    sh /etc/init.d/flexr_symlink_cal.sh ${rootdir} >& /dev/null

    cp /etc/init.d/dhcpd.conf ${rootdir}/etc/dhcp/
    sed -i '/PATH=\/bin:\/usr\/bin:\/sbin:\/usr\/sbin/a\SYSLOGD="-r"' ${rootdir}/etc/init.d/syslog.sysklogd
    rm -f ${rootdir}/etc/rcS.d/S*udev
    rm -f ${rootdir}/etc/rc3.d/S20dnsmasq
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} spirit defaults 97  3 > /dev/null 2>&1

    echo "#Disable containers to sync system clock and hw clock" >> ${rootdir}/etc/default/rcS
    echo "HWCLOCKACCESS=no" >> ${rootdir}/etc/default/rcS
}

function xrnginstall_a9k_patch_remove_incompatible_xr_files {
    local rootdir="$1"
    local filepath

    #
    # asr9k also uses eth_mgmt and socket plugin
    #
    local a9k_incompatible_xr_files=(            \
            "pkg/lib/spp_plugins/libspp_panini_plugin.so"       \
        )

    for filepath in ${a9k_incompatible_xr_files[*]}; do
        rm ${rootdir}/${filepath}  >/dev/null 2>&1
    done
}

function xrnginstall_a9k_patch_xr {
    local rootdir="$1"
    local pkgs="opt/cisco/XR/packages"

    if [[ $VIRT_METHOD == "vm" ]]; then
        xrnginstall_a9k_set_sysctl_params
    fi

    if [ "$PD_CARDTYPE" == "0x100366" ]; then
        rules=${rootdir}/etc/init.d/90-persistent-rpbb.rules
    else
        rules=${rootdir}/etc/init.d/90-persistent-disk.rules
    fi
    if [[ -f ${rules} ]]; then
        cp ${rules} ${rootdir}/lib/udev/rules.d/90-persistent-disk.rules
    fi

    xrnginstall_a9k_patch_remove_incompatible_xr_files "$rootdir"
    sed -i -e "s;.*igb$;;" \
            ${rootdir}/etc/modprobe.d/blacklist.conf
    sed -i -e "s;.*enic.*;;" \
            ${rootdir}/etc/modprobe.d/blacklist.conf

    # Update init scripts to call Spirit
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} spirit defaults 97 3 > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} -f lighttpd remove > /dev/null 2>&1

    rm -f ${rootdir}/etc/rcS.d/S*udev
    rm -f ${rootdir}/etc/rc3.d/S20dnsmasq

    echo "#Disable containers to sync system clock and hw clock" >> ${rootdir}/etc/default/rcS
    echo "HWCLOCKACCESS=no" >> ${rootdir}/etc/default/rcS

     # Fix the paths for XR

    mkdir -p ${rootdir}/etc/profile.d
    cat >> ${rootdir}/etc/profile.d/xr.sh <<'%%'
if  [ "$(id -u)" -eq 0 ] ; then
    if [ -f /pkg/etc/xr_startup_envs.sh ]; then
        source /pkg/etc/xr_startup_envs.sh
    fi
    if [ -f /tmp/set_env_vars ]; then
        source /tmp/set_env_vars
    fi
fi
%%
    chmod +x ${rootdir}/etc/profile.d/xr.sh

    if [[ ! -f   ${rootdir}/pkg/etc/platform_setup ]]; then
        touch    ${rootdir}/pkg/etc/platform_setup
        chmod +x ${rootdir}/pkg/etc/platform_setup
    fi
    
    if [[ $VIRT_METHOD == "lxc" ]]; then
        xrnginstall_a9k_remove_sysctl_noise ${rootdir}
    fi
    xrnginstall_a9k_remove_sysinit_noise ${rootdir}
    xrnginstall_a9k_tidy_starting_messages ${rootdir}
}

function xrnginstall_lxc_patch_hostos {
    local rootdir="$1"

    xrnginstall_a9k_remove_simbridge

    #make dir for lxc hooks and create symbolic link to the hook script
    mkdir -p ${rootdir}/etc/libvirt/hooks/
    if [[ ! -f ${rootdir}/etc/libvirt/hooks/lxc ]]; then
        ln -s /etc/init.d/lxc_hook.sh ${rootdir}/etc/libvirt/hooks/lxc
    fi

    sh /etc/init.d/flexr_symlink_cal.sh ${rootdir} >& /dev/null

    if [ "$PD_CARDTYPE" == "0x100366" ]; then
        rules=${rootdir}/etc/init.d/90-persistent-rpbb.rules
    else
        rules=${rootdir}/etc/init.d/90-persistent-disk.rules
    fi
    if [[ -f ${rules} ]]; then
        cp ${rules} ${rootdir}/lib/udev/rules.d/90-persistent-disk.rules
    fi

    rm -f ${rootdir}/lib/udev/rules.d/40-persistent-net.rules
    rm -f ${rootdir}/lib/udev/rules.d/40-persistent-net-ucs.rules
    rm -f ${rootdir}/lib/udev/rules.d/60-persistent-storage.rules
    rm -f ${rootdir}/lib/udev/rules.d/75-persistent-net-generator.rules

    sed -i '/network.sh/d' ${rootdir}/etc/udev/rules.d/local.rules
}

PD_BIN_FILES="pdreboot dopcie showemt showipu showmem msixd wdpunch es_reset ts_svr ts_agt eeupdate64e ixgbe_eeprom sock_send pcie_rpc_svr its_asr9k_client_static linkmonhost"
PD_HOSTOS_IMG_FILES="Aldrin_bootrom_eeprom.bin"
PD_CALV_IMG_FILES="fortville.bin nvmupdate.cfg"
PD_LIB_FILES="libasr9kpd.so"
PI_LIB_FILES="lib4arg.so libosc.so libsafec.so libctrace.so libcalvados_infra.so"
CFLOW_LIB_FILES="libcflowbb.so libcflowclient.so libctccov.so"

function pd_pxe_copy_bake_binaries {
    local rootdir=$1
    HOST_SRC=$(find /opt -name pdreboot | grep -v tmp | head -n 1 | sed -e "s;/bin/pdreboot;;")
    HOST_DST=${rootdir}

    local systemiso=`grep "root=/dev/ram" /proc/cmdline | wc -l`
    if [ "$systemiso" != "0" ]; then
    # PXE Bake Enviroment
        for i in ${PD_BIN_FILES}
        do
          cp ${HOST_SRC}/bin/$i /sbin
        done
        for i in ${PD_LIB_FILES}
        do
          cp ${HOST_SRC}/usr/lib64/$i /usr/lib64/
        done
        for i in ${PI_LIB_FILES}
        do
          cp -u /opt/cisco/hostos/usr/lib64/$i /usr/lib64/$i
          cp -u /opt/cisco/hostos/usr/lib64/$i ${HOST_DST}/usr/lib64/$i
        done
        # cp pdreboot to bake kexec
        cp -u ${HOST_SRC}/bin/pdreboot /sbin/kexec
        for i in ${CFLOW_LIB_FILES}
        do
            if [[ -f ${HOST_DST}/opt/cisco/hostos/usr/lib64/$i ]]; then
                cp -u ${HOST_DST}/opt/cisco/hostos/usr/lib64/$i ${HOST_DST}/usr/lib64/$i
		cp -u ${HOST_DST}/opt/cisco/hostos/usr/lib64/$i /usr/lib64/$i
            fi
        done
    else
        for i in ${PI_LIB_FILES}
        do
          cp -u ${HOST_DST}/opt/cisco/hostos/usr/lib64/$i ${HOST_DST}/usr/lib64/$i
        done
    fi
    for i in ${PD_BIN_FILES}
    do
        cp ${HOST_SRC}/bin/$i ${HOST_DST}/sbin
    done
    for i in ${PD_LIB_FILES}
    do
        cp ${HOST_SRC}/usr/lib64/$i ${HOST_DST}/usr/lib64/
    done
    for i in ${PD_HOSTOS_IMG_FILES}
    do
        cp ${HOST_SRC}/bin/$i ${HOST_DST}/opt/cisco/hostos/bin/
    done
    for i in ${PD_CALV_IMG_FILES}
    do
        cp ${HOST_SRC}/bin/$i ${HOST_DST}/opt/cisco/calvados/bin/
    done

      # cp pdreboot to host kexec and halt
    cp ${HOST_SRC}/bin/pdreboot ${HOST_DST}/sbin/kexec
    rm -f ${HOST_DST}/sbin/halt
    cp ${HOST_SRC}/bin/pdreboot ${HOST_DST}/sbin/halt

    mv ${HOST_DST}/sbin/reboot ${HOST_DST}/sbin/reboot.orig > /dev/null 2>&1
    cp ${HOST_SRC}/bin/pdreboot ${HOST_DST}/sbin/reboot
}

function xrnginstall_lxc_patch_calvados {
    local rootdir="$1"
    local cal_lvpath="/dev/panini_vol_grp/calvados_lv$5"

    # Calvados startup will configure IP/route for VMs
    if [[ $VIRT_METHOD == "lxc" ]]; then
    cat >${rootdir}/etc/rc.d/rc.local <<lxc_only_part
ifconfig eth-vf0 10.11.12.15/24 up
route add default gateway 10.11.12.2 eth-vf0 
route add 10.0.2.16 eth-vf0
lxc_only_part
    fi
    
    cat >>${rootdir}/etc/rc.d/rc.local <<%%
touch /var/lock/subsys/local
#We do it untill we get the rebased socat 
#socat fails due to missing lib
cp /usr/lib64/libncurses.so.5 /usr/lib64/libreadline.so.5
#Start the logger daemon
initctl emit ipu_logd
bash /etc/init.d/tftp-private.sh
grep -q "stty rows 24" /etc/bashrc
if [ "$?" != "0" ]; then
    echo "stty rows 24" >> /etc/bashrc
    echo "stty cols 80" >> /etc/bashrc
fi
%%

    chmod a+x ${rootdir}/etc/rc.d/rc.local

    chroot ${rootdir} ln -sf ./rc.d/rc.local /etc/rc.local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc2.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc3.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc4.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc5.d/S98local

    ldconfig

    mkdir -p ${rootdir}/etc/ld.so.conf.d
    cat >${rootdir}/etc/ld.so.conf.d/calvados.conf <<%%
            /opt/cisco/calvados/usr/lib64
%%

    sed -i 's/VMTYPE=.*/VMTYPE=sysadmin-vm/g' ${rootdir}/etc/init.d/calvados_bootstrap.cfg
    # Modifying DHCP address pool range to avoid IPU IP conflict and to extend the 
    # DHCP range from 7 to 64. 
    sed -i -e "s;range 192.0.0.100 192.0.0.106;range 192.0.0.128 192.0.0.191;" \
            ${rootdir}/etc/dhcp/dhcpd.conf

    grep -iE 'iputype=' ${rootdir}/root/cmdline.tmp &> /dev/null
    if [[ $? -ne 0 ]]; then
            echo -n "root=${cal_lvpath} platform=asr9k boardtype=${BOARDTYPE} cardtype=${PD_CARDTYPE} calcmd iputype=${HW_CARDTYPE} vmtype=sysadmin-vm console=tty0 console=hvc0 prod=1 pci=hpmemsize=0M,hpiosize=0M" > ${rootdir}/root/cmdline.tmp
    fi

    strip_replace "cardtype=" "cardtype=${PD_CARDTYPE}"  ${rootdir}/boot/grub/menu.lst
    strip_replace "iputype="  "iputype=${HW_CARDTYPE}"   ${rootdir}/boot/grub/menu.lst
    strip_replace "pci=hpmemsize" "pci=hpmemsize=0M,hpiosize=0M" \
                    ${rootdir}/boot/grub/menu.lst

    if [[ $VIRT_METHOD == "vm" ]]; then
        if [ "$BOARDTYPE" == "RP" ]; then
            echo " crashkernel=0 vmrpcmd" >> ${rootdir}/root/cmdline.tmp
        else
            echo " crashkernel=0 vmlccmd" >> ${rootdir}/root/cmdline.tmp
        fi
    else
        echo " " >> ${rootdir}/root/cmdline.tmp
    fi
    asr9k_update_grub ${rootdir}/root/cmdline.tmp "BIGPHYSAREA_CALVADOS"
    asr9k_update_grub ${rootdir}/boot/grub/menu.lst "BIGPHYSAREA_CALVADOS"
    mv ${rootdir}/root/cmdline.tmp ${rootdir}/root/cmdline
    sh /etc/init.d/flexr_symlink_cal.sh ${rootdir} >& /dev/null
    rm ${rootdir}/etc/sysconfig/modules/niantic.modules
    rm ${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules
    # Adding empty files for install verify sakes.
    touch ${rootdir}/etc/sysconfig/modules/niantic.modules
    touch ${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules

    INSTALLDEV=`cat /proc/cmdline | grep install=`
    if [ ! -n "$INSTALLDEV" ]; then
        return
    fi
}

function xrnginstall_lxc_patch_xr {
    local rootdir="$1"
    local xr_lvpath="/dev/panini_vol_grp/xr_lv$5"

    grep -iE 'virtvm|virtlxc' ${rootdir}/boot/grub/menu.lst &> /dev/null
    if [[ $? -ne 0 ]]; then
        asr9k_update_grub ${rootdir}/boot/grub/menu.lst "BIGPHYSAREA_XR"
        strip_replace "pci=hpmemsize" "pci=hpmemsize=0M,hpiosize=0M" \
                    ${rootdir}/boot/grub/menu.lst
    fi

    update_bigphysarea ${rootdir}/boot/grub/menu.lst "BIGPHYSAREA_XR"

    rc_file="${rootdir}/etc/rc.d/rc.local"
    echo "touch /var/lock/subsys/local"> $rc_file
    echo "grep -q \"stty rows 24\" /etc/bashrc" >> $rc_file
    echo "if [ "$?" != "0" ]; then" >> $rc_file
    echo "    echo \"stty rows 24\" >> /etc/bashrc" >> $rc_file
    echo "    echo \"stty cols 80\" >> /etc/bashrc" >> $rc_file
    echo "fi" >> $rc_file
#    Commenting this for the development and vista.
#    re-enable this check for release.
#    declare -F on_dev >& /dev/null
#    if [ $? -eq 0 ]; then
#        on_dev
#        if [ $? -eq 1 ]; then
#        fi
#    fi
    chmod a+x ${rootdir}/etc/rc.d/rc.local

    chroot ${rootdir} ln -sf ./rc.d/rc.local /etc/rc.local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc2.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc3.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc4.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc5.d/S98local
    chroot ${rootdir} ln -sf /eusba /a9ksys:
    chroot ${rootdir} ln -sf /eusbb /harddiskb:
    chroot ${rootdir} ln -sf /eusb /harddiska:
    ldconfig

    mkdir -p ${rootdir}/etc/ld.so.conf.d
    cat >${rootdir}/etc/ld.so.conf.d/xr.conf <<%%
    /pkg/lib
%%


    
    #Need to filled during xr lxc bringuphostos
    sed -i 's/VMTYPE=.*/VMTYPE=xr-vm/g' ${rootdir}/etc/init.d/calvados_bootstrap.cfg
    echo "root=${xr_lvpath} platform=asr9k boardtype=${BOARDTYPE} cardtype=${PD_CARDTYPE} iputype=${HW_CARDTYPE} vmtype=xr-vm console=tty0 console=hvc0 prod=1 pci=hpmemsize=0M,hpiosize=0M" > ${rootdir}/root/cmdline.tmp
    asr9k_update_grub ${rootdir}/root/cmdline.tmp "BIGPHYSAREA_XR"
    mv ${rootdir}/root/cmdline.tmp ${rootdir}/root/cmdline
    sh /etc/init.d/flexr_symlink_xr.sh ${rootdir} ${BOARDTYPE} >& /dev/null
    rm -f ${rootdir}/etc/sysconfig/modules/niantic.modules
    # Adding this for install verify's sake.
    touch ${rootdir}/etc/sysconfig/modules/niantic.modules
    sed -i "s/^ .*echo.*not initialized/#&/" ${rootdir}//etc/sysconfig/libvirtd
    sed -i "s/^cp.*vmm_default-sdr--1.cfg/#&/" ${rootdir}/etc/rc.d/panini.sysinit
}

# New PD callouts
function xrnginstall_platform_patch_xr {
    kmsg_log "xrnginstall_platform_patch_xr $VIRT_METHOD"
    get_board_type

    update_virt_method $1
    update_bootstrap $1
    update_xr_files $1

    xrnginstall_a9k_patch_xr $1 $2 $3 $4 $5
    xrnginstall_lxc_patch_xr $1 $2 $3 $4 $5

    modify_init_console_para_xr $1
}

function xrnginstall_platform_patch_calvados {
    kmsg_log "xrnginstall_platform_patch_calvados $VIRT_METHOD"

    get_board_type

    update_virt_method $1
    update_bootstrap $1
    update_vmmprofile $1

    xrnginstall_a9k_patch_calvados $1 $2 $3 $4 $5
    xrnginstall_lxc_patch_calvados $1 $2 $3 $4 $5
}

function xrnginstall_platform_patch_hostos {
    kmsg_log "xrnginstall_platform_patch_hostos $VIRT_METHOD"

    get_board_type

    update_virt_method $1
    update_bootstrap $1

    xrnginstall_a9k_patch_hostos $1 $2
    xrnginstall_lxc_patch_hostos $1 $2
}
