#!/bin/bash
#
# Copyright (c) 2016-2020 by cisco Systems, Inc.
# All rights reserved
# hushd_platform.sh - wrapper over rmon_spi_writer
#

BIN_DIR=/opt/cisco/calvados/bin
SPI_script=/opt/cisco/hostos/bin/rmon_spi_writer_lc
NVM_UPDATE=/opt/cisco/calvados/bin/nvmupdate64e 
NVM_CFG=/opt/cisco/calvados/bin/nvmupdate.cfg 
FPD_ROMMON_RUN_VER="0"
LC_SKYHAMMER_TBL_IDX="7"
LC_POWERGLIDE_TBL_IDX="12"
RP_STARLORD_TBL_IDX="13"
LC_STARLORD_TBL_IDX="14"
RP_RSP4L_TBL_IDX="15"
RP3_CARD_TYPE_IDX="11"
RUN_FLASH=0

function getcmdlinearg {
    awk -vRS=' ' -vFS='='  /$1/' {print $2}' /proc/cmdline
}

BOARDTYPE=$(getcmdlinearg boardtype)

function print_usage() {
   echo "Usage"
   echo "hushd_platform.sh update_flash "
   echo "boardtype flash_type              : Update boardtype in flash"
   echo "hushd_platform.sh get_bios_ver " 
   echo "boardtype flash_type              : Get BIOS version from flash"
}

function get_flash_version() {
    local board=$1
    local fpd=$2
    local version

    if [[ "$board" == $RP3_CARD_TYPE_IDX ]]; then
        rm -rf /tmp/fortville_run_ver
        $NVM_UPDATE -i -l /tmp/fortville_run_ver > /dev/null 2>&1
        version=$(grep -A8 "Device\s*:\s*1581" /tmp/fortville_run_ver | grep "NVM Version" | head -n 1 | awk -F':' '{ print $2 ; }' | awk '{$1=$1}1')
    fi    

    echo $version
}

function log_flash_version()
{
    local ver=$1
    local file=$2
    local maj
    local min
    local result
    
    maj=$(echo "$ver" | cut -d '.' -f 1)
    min=$(echo "$ver" | cut -d '.' -f 2)

    result=$(($(($maj<<16)) | $min))
    
    echo "log_flash_version $result in $file" >> /tmp/hushd_platform_debug
    
    echo $result > $file
}

###############################################################################
# command_handler
#   
# command parser and handler
#
# arg1 -> card table index to look up golden programming table 
#        in spi_writer
# arg2 -> 0: get running version , 1: get primary flash version
command_handler() {
    action=$1
    arg1=$2
    arg2=$3
    arg3=$4

    local fv_cnt=$(lspci -d :1581 | wc -l)

    if [[ "$BOARDTYPE" == "RP" ]]; then
        SPI_script=/opt/cisco/hostos/bin/rmon_spi_writer_rp
    else
        SPI_script=/opt/cisco/hostos/bin/rmon_spi_writer_lc
    fi

    case $action in  
        doorbell)
            echo "$0: admin shutting down" > /dev/ttyS0
            if [[ -f /var/log/libvirt/qemu/sysadmin.log ]]; then
                echo ======= Sysadmin qemu log tail start ======= > /dev/ttyS0
                tail -5 /var/log/libvirt/qemu/sysadmin.log > /dev/ttyS0
                echo ======= Sysadmin qemu log tail end ======= > /dev/ttyS0
            fi
            ;;
        update_flash)
             if [ -f $SPI_script ]; then
                 echo "$0: $action $arg1 $arg2" >> /tmp/hushd_platform_debug
                 if [[ "$arg2" == $LC_SKYHAMMER_TBL_IDX ||  "$arg2" == $LC_POWERGLIDE_TBL_IDX ||
                       "$arg2" == $LC_STARLORD_TBL_IDX  ||  "$arg2" == $RP_STARLORD_TBL_IDX ]]; then
                     $SPI_script -t 1 -d -o -f "/opt/cisco/calvados/fpd/ucode/asr9k_bios.bin"

                 elif [ "$arg2" == $RP_RSP4L_TBL_IDX ]; then
                     $SPI_script -s $arg2 -t 1 -d -o -f "/opt/cisco/calvados/fpd/ucode/asr9k_bios.bin"
                 else
                     $SPI_script -s $arg2 -t 1 -f "/opt/cisco/calvados/fpd/ucode/asr9k_bios.bin"
                 fi
             fi
             ;;
        
        update_fpd)
             local oldver
             local newver
             local result

             if [[ "$arg2" == $RP3_CARD_TYPE_IDX && "${fv_cnt}" != "0" ]]; then
                 if [[ -f $NVM_UPDATE  && -f $NVM_CFG ]]; then
                     echo "$0: $action $arg1 $arg2 $arg3" >> /tmp/hushd_platform_debug
                     oldver=$(get_flash_version $arg2 $arg3)
                     cd $BIN_DIR
                     $NVM_UPDATE -u -l /tmp/flash_update_${arg2}_${arg3} -o /tmp/flash_update.xml -b -c $NVM_CFG > /dev/null 2>&1
                     sleep 1
                     newver=$(get_flash_version $arg2 $arg3)
                     echo $newver > /tmp/flash_ver_${arg2}_${arg3}
                     echo "Fortville upgraded from $oldver to $newver" >> /tmp/hushd_platform_debug
                     if [ -z "$newver" ]; then
                         result=1
                     else
                         result=0
                     fi    
                 else
                     echo "$NVM_UPDATE or $NVM_CFG not found" >> /tmp/hushd_platform_debug
                     result=1
                 fi    
                 echo $result > /tmp/flash_update_rc_${arg2}_${arg3}
             else    
                 echo "fpd upgrade for board $arg2 fpd $arg3 not supported" >> /tmp/hushd_platform_debug
             fi
             ;;

        get_bios_ver)
             if [ -f $SPI_script ]; then
                 echo "$0: $action $arg1 $arg2" >> /tmp/hushd_platform_debug
                 if [[ "$arg1" == $LC_SKYHAMMER_TBL_IDX ||  "$arg1" == $LC_POWERGLIDE_TBL_IDX ||
                       "$arg1" == $LC_STARLORD_TBL_IDX  ||  "$arg1" == $RP_STARLORD_TBL_IDX || "$arg1" == $RP_RSP4L_TBL_IDX ]]; then
                     if [ "$arg2" != $FPD_ROMMON_RUN_VER ]; then
                        $SPI_script -t $arg2 -d -o -v > /dev/null 2>&1
                     else
                        $SPI_script -d -o -r > /dev/null 2>&1
                    fi
                 else
                     if [ "$arg2" != $FPD_ROMMON_RUN_VER ]; then
                        $SPI_script -s $arg1 -t $arg2 -v > /dev/null 2>&1
                     else
                        $SPI_script -s $arg1 -r > /dev/null 2>&1
                    fi
                 fi
             fi
             ;;

        get_fpd_ver)
             local ver

             if [[ "$arg2" == $RP3_CARD_TYPE_IDX && "${fv_cnt}" != "0" ]]; then
                 if [ -f $NVM_UPDATE ]; then
                     echo "$0: $action $arg1 $arg2 $arg3" >> /tmp/hushd_platform_debug
                     if [[ "$arg3" == $RUN_FLASH ]]; then
                         if [ -f "/tmp/bootup_flash_ver_${arg1}_${arg2}_${arg3}" ]; then
                             cp /tmp/bootup_flash_ver_${arg1}_${arg2}_${arg3} /tmp/flash_ver_${arg1}_${arg2}_${arg3}
                         else    
                             ver=$(get_flash_version $arg1 $arg2)
                             log_flash_version $ver "/tmp/flash_ver_${arg1}_${arg2}_${arg3}"
                             cp /tmp/flash_ver_${arg1}_${arg2}_${arg3} /tmp/bootup_flash_ver_${arg1}_${arg2}_${arg3}
                         fi
                     else
                         ver=$(get_flash_version $arg1 $arg2)
                         log_flash_version $ver "/tmp/flash_ver_${arg1}_${arg2}_${arg3}"
                     fi    
                 else
                     echo "$NVM_UPDATE not found" >> /tmp/hushd_platform_debug
                 fi
             else
                 echo "get flash version for $arg2 on board $arg1 not supported" >> /tmp/hushd_platform_debug
             fi
             ;;

        *)
             print_usage > /var/log/asr9k_hushd_usage.log
             ;;
    esac
}

###############################################################################
# main.... 
#
# start up loop if no arguments, otherwise do command
#

if test $# == 0; then
    print_usage > /var/log/asr9k_hushd_usage.log
else
    command_handler $1 $2 $3 $4
fi

