#!/bin/bash
# -------------------------------------------------------------------------------
# show_tech_vm_pcie
#
# Copyright (c) 2017, 2020 by cisco Systems, Inc.
# All rights reserverd.
# -------------------------------------------------------------------------------

# This script collects logs from different vms  
#

# ---------------------
#Logs to collect:
#     1)/var/log/libvirt/*
#     2)/tmp/pcie_rpc_svr.log
#     3)lspci -vt
#     4)lspci -vv
#     5)showipu
#     6)showemt


while [ "$#" -gt "0" ]; do
    case "$1" in
        -t) cardtype="$2"; shift 2;;
        -f) media_path="$2"; shift 2;;
        -n) nodename="$2"; shift 2;;
        -c) clean="1"; shift 1;;
        -l) loc_vm="$2"; shift 2;;
         *) shift;;
    esac
done

standalone=0
if [ -z "$media_path" ]; then
    media_path="/misc/scratch/showtech"
    standalone=1
fi

if [ ! -z "$nodename" ]; then
    nodename_plus_vm="${nodename}_${loc_vm}"
else
    nodename_plus_vm="${loc_vm}"
fi    

#All logs etc will be accumulated into $fullpath
fullpath=$media_path/$nodename_plus_vm

if [[ "$clean" == "1" ]]; then
     rm ${fullpath}.tgz 2>/dev/null
     rmdir $media_path 2>/dev/null; RCX=$?
     exit 0
fi

mkdir -p $fullpath ; RC=$?
if [ $RC -ne 0 ]; then
    exit 0
fi

FILENAME="$fullpath/${loc_vm}_showtech_log"

# Bootstrap file
BOOTSTRAP_FILE="/etc/init.d/calvados_bootstrap.cfg"

OUTPUT_TAR="$fullpath"

if [[ -f "$BOOTSTRAP_FILE" ]]; then
    source $BOOTSTRAP_FILE
fi    

# ---------------------
# General Functions
# ---------------------

function print_main_heading {
    echo "-------------------------------------------------------------------------------" >> $FILENAME
    echo "                          tech support" $loc_vm "                                  " >> $FILENAME
    echo "-------------------------------------------------------------------------------" >> $FILENAME
}

function print_end {
    echo "-------------------------------------------------------------------------------" >> $FILENAME
    echo "                          tech support" $loc_vm "End                           " >> $FILENAME
    echo "-------------------------------------------------------------------------------" >> $FILENAME
}

# ---------------------
# Functions
# ---------------------

function collect_misc_scratch_pcie_logs {
  ct=`ls -1d /misc/scratch/pcie* 2>/dev/null 1| wc -l`
  if [ $ct -ne 0 ]; then
    for name in /misc/scratch/pcie*
     do
       namedir=`basename $name`
       mkdir $fullpath/$namedir 2>/dev/null
       for file in $name/*
       do                
         tgtname=`basename $namedir`/`basename $file`
         ln -s $file $fullpath/$tgtname
       done
     done
   fi
} 

function collect_rpc_pcie_server_logs {
  if [ -f "/tmp/pcie_rpc_svr.log" ]; then
     ln -s "/tmp/pcie_rpc_svr.log" "$fullpath/pcie_rpc_svr.log" 2>/dev/null
  elif [ -f "/tmp/pcie/pcie_rpc_svr.log" ]; then
     ln -s "/tmp/pcie/pcie_rpc_svr.log" "$fullpath/pcie_rpc_svr.log" 2>/dev/null
   fi

}

function collect_dmesg_log {
   echo "----------------CMD:dmesg--------------------" >> $fullpath/dmesg
   dmesg 2>/dev/null >> $fullpath/dmesg
}

function collect_var_log_logs {
    if [ -d "/var/log/libvirt" ]; then
        ln -s  "/var/log/libvirt" "$fullpath/libvirt" 2>/dev/null
    fi
    if [ -f "/var/log/interrupt_infra.log" ]; then
        ln -s  "/var/log/interrupt_infra.log" "$fullpath/interrupt_infra.log" 2>/dev/null
    fi
    if [ -f "/var/log/kmsg.log" ]; then
        ln -s  "/var/log/kmsg.log" "$fullpath/kmsg.log" 2>/dev/null
    fi
    if [ -f "/var/log/kern.log" ]; then
        ln -s  "/var/log/kern.log" "$fullpath/kern.log" 2>/dev/null
    fi
    if [ -f "/var/log/xrnginstall.log" ]; then
        ln -s  "/var/log/xrnginstall.log" "$fullpath/xrnginstall.log" 2>/dev/null
    fi
    if [ -f "/var/log/postinstall.log" ]; then
        ln -s  "/var/log/postinstall.log" "$fullpath/postinstall.log" 2>/dev/null
    fi
    if [ -f "/var/log/platform.log" ]; then
        ln -s  "/var/log/platform.log" "$fullpath/platform.log" 2>/dev/null
    fi
    if [ -f "/var/log/messages" ]; then
        ln -s  "/var/log/messages" "$fullpath/messages" 2>/dev/null
    fi
  
   # collect /var/log/old* logs
    ct=`ls -1d /var/log/old* 2>/dev/null 1| wc -l`
    if [ $ct -ne 0 ]; then
      for name in /var/log/old*
       do
         namedir=`basename $name`
         mkdir $fullpath/$namedir 2>/dev/null
         for file in $name/*
         do                
           tgtname=`basename $namedir`/`basename $file`
           ln -s $file $fullpath/$tgtname
         done
       done
     fi
}

function print_info {
    local cmd=$1
    if [[ -f /pkg/sbin/${cmd}_static ]]; then
        /pkg/sbin/${cmd}_static >> $fullpath/lspci
    elif [[ -f /opt/cisco/calvados/bin/${cmd}_static ]]; then
         /opt/cisco/calvados/bin/${cmd}_static >> $fullpath/lspci
    elif  [[ -f /sbin/${cmd} ]]; then
        /sbin/${cmd} >> $fullpath/lspci
    fi
}

function print_pci_info {
    echo "PCI info: lspci -vt start">> $fullpath/lspci
    lspci -vt >> $fullpath/lspci 2>/dev/null
    echo "PCI info: lspci -vt end">> $fullpath/lspci

    echo "PCI info: lspci -vv start">> $fullpath/lspci
    lspci -vv  >> $fullpath/lspci 2>/dev/null
    echo "PCI info: lspci -vv end">> $fullpath/lspci

    echo "IPU info: start">> $fullpath/lspci
    print_info showipu
    echo "IPU info: end">> $fullpath/lspci

    echo "EMT info: start">> $fullpath/lspci
    print_info showemt
    echo "EMT info: end">> $fullpath/lspci
}

function main() {

    # validate filename option
    if [[ -f "$FILENAME" ]]; then
        rm -rf "$FILENAME"
    fi
    touch $FILENAME

    # create empty archive file
    if [ $standalone -eq 1 ]; then
        timestamp=`date "+%Y-%b-%d-%H%M%S-%Z"`
        OUTPUT_TAR=$OUTPUT_TAR-$timestamp
        echo "logs start time: `date`"
    fi

    print_main_heading

    #.  rpc_pcie_server.log
    collect_rpc_pcie_server_logs
    
    #1. collect logs from /var/log/ directory 
    collect_var_log_logs

    #.  dmesg 
    collect_dmesg_log

    #    PCI info
    print_pci_info
    
    # Collect misc/scratch/pcie log
    collect_misc_scratch_pcie_logs 
    
    print_end

    ( cd $media_path
      tar --dereference -czf $nodename_plus_vm.tgz $nodename_plus_vm 1>/dev/null 2>&1
    )

   if [ $standalone -eq 1 ]; then
       echo "logs: $OUTPUT_TAR.tgz"
   else
       echo "$OUTPUT_TAR.tgz"
   fi
   rm -rf "$fullpath"

}

# Execute the script
main 
