#!/bin/bash
#
# This script provides boot up debugging information
# Must be manually changed on the router
#
# Copyright (c) 2018 by Cisco Systems, Inc.
# All rights reserved.

function platform_specific_get_ps_data() {
   kmsg_log "platform_specific_get_ps_data running ps boot testing"

   touch /misc/scratch/pcie/ps.cpu.log ; touch /misc/scratch/pcie/ps.cpu.thread.log

   for i in {1..300}
   do
       echo "================================== count $i"   >> /misc/scratch/pcie/ps.cpu.log
       date                                                 >> /misc/scratch/pcie/ps.cpu.log
       ps -Ao  user,pid,pcpu,comm --sort=-pcpu | head -n 30 >> /misc/scratch/pcie/ps.cpu.log &

       echo "================================== count $i"       >> /misc/scratch/pcie/ps.cpu.thread.log
       date                                                     >> /misc/scratch/pcie/ps.cpu.thread.log
       ps -Amo user,tid,pid,pcpu,comm --sort=-pcpu | head -n 40 >> /misc/scratch/pcie/ps.cpu.thread.log &

       wait
       sleep 1
   done
}

function platform_specific_get_blocked_data() {

   kmsg_log "platform_specific_get_blocked_data running blocked boot testing"

   touch /misc/scratch/pcie/sh_proc_ng_blocked.log

   for i in {1..40}
   do
       echo "================================== count $i" >> /misc/scratch/pcie/sh_proc_ng_blocked.log
       date                                               >> /misc/scratch/pcie/sh_proc_ng_blocked.log
       /pkg/bin/sh_proc_ng_blocked                        >> /misc/scratch/pcie/sh_proc_ng_blocked.log &

       sleep 15
   done
}

function platform_specific_get_perf_data_sum_up() {

   cd /misc/scratch/pcie
   mkdir perf
   for i in {1..40}
   do
       cd perf${i}

       perf report > perf.f.report.${i}
       cp perf.f.report.${i} ../perf/

       perf report -g > perf.g.report.${i}
       cp perf.g.report.${i} ../perf/

       cd ..
   done
   cd perf
   touch perf_top_ten
   for i in {1..40}
   do
       cat perf.f.report.${i} | grep "\[\.\]" | head >> perf_top_ten
   done
}

function platform_specific_get_perf_data() {

   kmsg_log "platform_specific_get_perf_data running perf boot testing"

   cd /misc/scratch/pcie
   for i in {1..40}
   do
       mkdir perf${i}
       cd perf${i}

       timeout 8 perf record -ag

       sleep 2
       cd ..
   done
   platform_specific_get_perf_data_sum_up
}

function platform_specific_get_dll_data() {

    kmsg_log "platform_specific_get_dll_data dll data"

    cd /misc/scratch/pcie
    mkdir dll
    cd /pkg/bin

    array=($(ls *))
    echo Looping
    
    for file in "${array[@]}"
    do
        rm -f /misc/scratch/pcie/dll/${file}*
        ldd /pkg/bin/$file > /misc/scratch/pcie/dll/${file}.ldd
        lddtree /pkg/bin/$file > /misc/scratch/pcie/dll/${file}.lddtree
    done

    cd /pkg/lib
    array=($(ls *))
    echo Looping

    for file in "${array[@]}"
    do
        rm -f /misc/scratch/pcie/dll/${file}*
        ldd /pkg/lib/$file > /misc/scratch/pcie/dll/${file}.ldd
        lddtree /pkg/lib/$file > /misc/scratch/pcie/dll/${file}.lddtree
    done
}

function platform_specific_get_nm_process() {
   
    kmsg_log "platform_specific_get_nm_data dll data"

    cd /misc/scratch/pcie/nm

    array=($(ls *))
    echo Looping
   
    for file in "${array[@]}"
    do
        # rm -f /misc/scratch/pcie/nm/${file}*
        cat ${file} | grep " U " > ${file}.U
        cat ${file} | grep " T " > ${file}.T
    done
}


function platform_specific_get_nm_data() {
    
    kmsg_log "platform_specific_get_nm_data dll data"

    cd /misc/scratch/pcie
    mkdir nm

    cd /pkg/bin
    array=($(ls *))
    echo Looping

    for file in "${array[@]}"
    do  
        rm -f /misc/scratch/pcie/nm/${file}*
        nm --dynamic /pkg/bin/$file > /misc/scratch/pcie/nm/${file}.nm
    done

    cd /pkg/lib 
    array=($(ls *))
    echo Looping

    for file in "${array[@]}"
    do  
        rm -f /misc/scratch/pcie/nm/${file}*
        nm --dynamic /pkg/lib/$file > /misc/scratch/pcie/nm/${file}.nm
    done
    platform_specific_get_nm_process
}

function platform_specific_get_boot_data() {
   local VM_TYPE=$1
   local VIRT_METHOD=$2
   local PLATFORM=$3

   kmsg_log "platform_specific_get_boot_data $VM_TYPE $VIRT_METHOD line $LINENO"
   # platform_specific_get_ps_data &
   # platform_specific_get_blocked_data &
   # platform_specific_get_perf_data &
   # platform_specific_get_dll_data &
   # platform_specific_get_nm_data &
   wait
   kmsg_log "platform_specific_get_boot_data $VM_TYPE $VIRT_METHOD line $LINENO"
}

