#!/bin/bash
#
# calvados/asr9k_pkg/boot/scripts/spirit_pd_overrides.sh
# This script provides PD overrides
#    eg for simulation, bringup, 
#       special cases for some cards, etc
#
# Copyright (c) 2017-2020 by Cisco Systems, Inc.
# All rights reserved.
#

function platform_specific_startup_clean() {
   FILE=$1
   TMP_FILE="${FILE}.tmp"

   # kmsg_log "platform_specific_startup_clean $FILE"

   sed -n '/mandatory/!p' $FILE | sed -n '/respawn/!p' > $TMP_FILE
   echo "respawn: OFF" >> $TMP_FILE
   cp -f $TMP_FILE $FILE
   rm -f $TMP_FILE
}

function platform_specific_startup_clean_all() {

    The following group of lines will "clean" all the startup files!

    MY_PWD=`pwd`
    cd /pkg/startup/

    ls | awk '{print "platform_specific_startup_clean " $1}' > MY_TMP_SCRIPT
    chmod a+x MY_TMP_SCRIPT
    source ./MY_TMP_SCRIPT
    rm ./MY_TMP_SCRIPT

    cd $MY_PWD
}

function platform_specific_init_clean_all() {

    The following group of lines will "clean" all the startup files!

    MY_PWD=`pwd`
    cd /pkg/init.d/

    ls *.init | awk '{print "platform_specific_startup_clean " $1}' > MY_TMP_SCRIPT
    chmod a+x MY_TMP_SCRIPT
    source ./MY_TMP_SCRIPT
    rm ./MY_TMP_SCRIPT

    cd $MY_PWD
}

function platform_specific_clean_all() {
    kmsg_log "platform_specific_clean_all"
    platform_specific_startup_clean_all
    platform_specific_init_clean_all
}

function platform_specific_card_questra() {
    BRD_TYPE=`cat /proc/cmdline | sed 's/^.*boardtype=//' | cut -d" " -f1`
    kmsg_log "platform_specific_card_questra start for type $BRD_TYPE"
    
    kmsg_log "platform_specific_card_questra end for type $BRD_TYPE"
}

function platform_specific_create_stub_dll() {
    DLL=$1
    if [ ! -e $DLL ] ; then
        kmsg_log "Stubbing $DLL"
        ln -s /lib64/libc-2.20.so $DLL
    fi
}

function platform_vxr_sim_cleanup() {
    BRD_TYPE=`cat /proc/cmdline | sed 's/^.*boardtype=//' | cut -d" " -f1`
    kmsg_log "platform_vxr_sim_cleanup start for type $BRD_TYPE"
    # this is common for both RP and LC. How about FC ?
    find /opt/cisco/XR/packages/ -name 'fab_arb*startup' | xargs rm
    find /opt/cisco/XR/packages/ -name 'fab_xbar*startup' | xargs rm
    find /opt/cisco/XR/packages/ -name 'fab_si*startup' | xargs rm

    # Adjust CALVADOS_LIVENESS_TIMEOUT value.
    SRCF="/opt/cisco/calvados/etc/platform_profile/hw/wdmon.txt"
    TARGF="/tmp/wdmon.txt"
    cp $SRCF $TARGF
    sed -e "s/^CALVADOS_LIVENESS_TIMEOUT.*$/CALVADOS_LIVENESS_TIMEOUT 6000/" -i $TARGF
    mv $SRCF $SRCF.bak
    cp $TARGF $SRCF
    rm -f $TARGF

    if [ "$BRD_TYPE" == "RP" ]; then
       find /opt/cisco/XR/packages/ -name 'zl30160_server.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'rsptiming.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'pcie_flexr.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'ether_ctrl_msg_server.*' | xargs rm
#       find /opt/cisco/XR/packages/ -name 'icpe_satmgr.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'vkg_mgid_prgm.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'fia*startup' | xargs rm
       find /opt/cisco/XR/packages/ -name 'vkg_online_diag_rsp_exr.*' | xargs rm
    fi
    if [ "$BRD_TYPE" == "LC" ]; then
       find /opt/cisco/XR/packages/ -name 'prm_server_to.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'ether_ctrl_msg_client.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'pcie_flexr.*' | xargs rm
       ##CW find /opt/cisco/XR/packages/ -name 'vkg_mgid_prgm.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'fpd_fpga_agent.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'zllc.*' | xargs rm
       find /opt/cisco/XR/packages/ -name 'vkg_online_diag_lc_exr.*' | xargs rm

       find /opt/cisco/XR/packages/ -name 'libspp_frag.*' | xargs rm

       find /pkg/lib/spp_plugins/   -name 'libspp_frag.*' | xargs rm

       #
       # Stub some libraries
       # Plans need to be made to eventually fix these libraries.
       #
       # platform_specific_create_stub_dll /pkg/lib/libetna_lda_api.so
       # platform_specific_create_stub_dll /pkg/lib/libfrenzyflash.so

       #
       # This will remove mandatory, and turn respawn off, until we can further debug
       # These processes
       # Creates a MY_TMP_SCRIPT file, which makes the necessary function calls
       #

       MY_PWD=`pwd`
       cd /pkg/startup/

       # platform_specific_clean_all

       #
       # Only these processes left!
       #
       platform_specific_startup_clean config_node.startup
       platform_specific_startup_clean envmon_proxy.startup
       platform_specific_startup_clean flowtrap.startup
       platform_specific_startup_clean issumgr_proxy.startup
       platform_specific_startup_clean issumgr.startup
       platform_specific_startup_clean lc_config_replicator.startup
       platform_specific_startup_clean ls_stats_svr.startup
       platform_specific_startup_clean ppp_lite.startup
       platform_specific_startup_clean rmf_cli_edm.startup
       platform_specific_startup_clean rmf_svr.startup
       platform_specific_startup_clean slc.startup
       platform_specific_startup_clean spio_ea.startup
       platform_specific_startup_clean sysdb_bagregister.startup
       platform_specific_startup_clean vkg_l2fib_mac_cache.startup

       cd /pkg/init.d/
       platform_specific_startup_clean platform_packet_partner.init


       # This is for Calvados mandatory disable!
       # cd /
       # find . -name \*.startup | xargs readlink | xargs -I {} sed -i -e "s;mandatory\s*=\s*'yes';mandatory = 'no';" {}

       cd $MY_PWD
    fi
    kmsg_log "platform_vxr_sim_cleanup end for type $BRD_TYPE"
}
#
# BB_TBD: Raised CSCvs87210 to remove this check
# This is to enable BB on 712 and xrdev
#
function platform_vxr_bb_cleanup() {

    BRD_TYPE=`cat /proc/cmdline | sed 's/^.*boardtype=//' | cut -d" " -f1`
    kmsg_log "platform_vxr_bb_cleanup start for type $BRD_TYPE"
    kmsg_log "platform_vxr_bb_cleanup end for type $BRD_TYPE"

}

function platform_specific_convert_lda_to_ls_code() {
    kmsg_log "platform_specific_convert_lda_to_ls_code"
    cp /opt/cisco/XR/packages/asr9k-os-supp-64-*/lc/instances/A9K-TOMAHAWK/lib/lib_lda_board_specs_tom_lc.so \
       /opt/cisco/XR/packages/asr9k-os-supp-64-*/lc/instances/A9K-TOMAHAWK/lib/lib_lda_board_specs.so
    cp /opt/cisco/XR/packages/asr9k-os-supp-64-*/lc/instances/A9K-TOMAHAWK/lib/lib_lda_hal_board_specs_tom_ls.so \
       /opt/cisco/XR/packages/asr9k-os-supp-64-*/lc/instances/A9K-TOMAHAWK/lib/lib_lda_hal_board_specs.so
}

function platform_specific_convert_vic_to_ls_code() {
    kmsg_log "platform_specific_convert_vic_to_ls_code"
    cp /opt/cisco/XR/packages/asr9k-base-64-*/lc/instances/A9K-TOMAHAWK/lib/libether_ctrl_proc_tom_single.so \
       /opt/cisco/XR/packages/asr9k-base-64-*/lc/instances/A9K-TOMAHAWK/lib/libether_ctrl_proc.so
    cp /opt/cisco/XR/packages/asr9k-base-64-*/lc/instances/A9K-TOMAHAWK/lib/libvic_ls_shared_tom.so \
       /opt/cisco/XR/packages/asr9k-base-64-*/lc/instances/A9K-TOMAHAWK/lib/libether_ctrl_shared_cmn.so
}

function platform_specific_card_octane() {
    kmsg_log "platform_specific_card_octane"
    # Optional "clean" if trouble enabling LS code!
    #
    # platform_specific_clean_all

    # Can make a card specifically run ls lda or vic code
    #
    # platform_specific_convert_lda_to_ls_code
    # platform_specific_convert_vic_to_ls_code
}

function platform_specific_card_skyhammer() {
    kmsg_log "platform_specific_card_skyhammer"
    # Optional "clean" if trouble enabling LS code!
    #
    # platform_specific_clean_all

    # Can make a card specifically run ls lda or vic code
    #
    # platform_specific_convert_lda_to_ls_code
    # platform_specific_convert_vic_to_ls_code
}

function platform_specific_card_azteca() {
    kmsg_log "platform_specific_card_azteca"

    is_vxr_sim
    if [[ $? != 0 ]]; then
        if [[ "$PD_CARDTYPE" == "0x3f0516" ]]; then
            cp /pkg/lib/libmdx1host_serdes_sim.so /pkg/lib/libmdx1host_serdes.so
            cp /pkg/bin/mdx1_simulator.gz /pkg/bin/mdx1_simulator_cp.gz
            cp /pkg/bin/mdx1_device.gz /pkg/bin/mdx1_device_cp.gz
            gunzip /pkg/bin/mdx1_simulator_cp.gz
            gunzip /pkg/bin/mdx1_device_cp.gz
            ./pkg/bin/mdx1_simulator_cp verbosity=2 > /tmp/sim_0.log 2>&1 &
            ./pkg/bin/mdx1_device_cp verbosity=2 > /tmp/device_0.log 2>&1 &
            ./pkg/bin/mdx1_simulator_cp device=1 verbosity=2 > /tmp/sim_1.log 2>&1 &
            ./pkg/bin/mdx1_device_cp device=1 verbosity=2  > /tmp/device_1.log 2>&1 &
            ./pkg/bin/mdx1_simulator_cp device=2 verbosity=2 > /tmp/sim_2.log 2>&1 &
            ./pkg/bin/mdx1_device_cp device=2 verbosity=2  > /tmp/device_2.log 2>&1 &
        fi

        if [[ "$PD_CARDTYPE" == "0x3f0538" ]]; then
            cp /pkg/lib/libmdx1host_serdes_sim.so /pkg/lib/libmdx1host_serdes.so
            cp /pkg/bin/mdx1_simulator.gz /pkg/bin/mdx1_simulator_cp.gz
            cp /pkg/bin/mdx1_device.gz /pkg/bin/mdx1_device_cp.gz
            gunzip /pkg/bin/mdx1_simulator_cp.gz
            gunzip /pkg/bin/mdx1_device_cp.gz
            ./pkg/bin/mdx1_simulator_cp verbosity=2 > /tmp/sim_0.log 2>&1 &
            ./pkg/bin/mdx1_device_cp verbosity=2 > /tmp/device_0.log 2>&1 &
            ./pkg/bin/mdx1_simulator_cp device=1 verbosity=2 > /tmp/sim_1.log 2>&1 &
            ./pkg/bin/mdx1_device_cp device=1 verbosity=2  > /tmp/device_1.log 2>&1 &
            ./pkg/bin/mdx1_simulator_cp device=2 verbosity=2 > /tmp/sim_2.log 2>&1 &
            ./pkg/bin/mdx1_device_cp device=2 verbosity=2  > /tmp/device_2.log 2>&1 &
            ./pkg/bin/mdx1_simulator_cp device=3 verbosity=2 > /tmp/sim_3.log 2>&1 &
            ./pkg/bin/mdx1_device_cp device=3 verbosity=2  > /tmp/device_3.log 2>&1 &
            ./pkg/bin/mdx1_simulator_cp device=4 verbosity=2 > /tmp/sim_4.log 2>&1 &
            ./pkg/bin/mdx1_device_cp device=4 verbosity=2  > /tmp/device_4.log 2>&1 &
            platform_specific_clean_all
        fi

    fi

    # To be removed
    if [[ "$PD_CARDTYPE" == "0x3f0516" ]]; then
        platform_specific_card_questra
    fi
    # To be removed
    if [[ "$PD_CARDTYPE" == "0x3f0538" ]]; then
        platform_specific_card_questra
    fi
    # To be removed
    if [[ "$PD_CARDTYPE" == "0x3f0539" ]]; then
        platform_specific_card_questra
    fi
    # To be removed
    if [[ "$PD_CARDTYPE" == "0x3f0544" ]]; then
        platform_specific_card_questra
    fi
    # To be removed
    if [[ "$PD_CARDTYPE" == "0x3f0545" ]]; then
        platform_specific_card_questra
    fi
}

function platform_specific_card_rp_rsp() {
    kmsg_log "platform_specific_card_rp_rsp"
}

function platform_specific_card_override() {
    local VM_TYPE=$1
    local VIRT_METHOD=$2
    local PLATFORM=$3
    local hw_ct
    local db_ct

    if [[ -z ${HW_CARDTYPE} ]]; then
        get_ipu_nvram_off
    fi

    if [[ -z ${HW_CARDTYPE} ]]; then
        kmsg_log "platform_specific_card_override $1: HW_CARDTYPE not set"
        return
    fi
    let "hw_ct = ${HW_CARDTYPE} & 0x3f"

    hw_ct=$( printf "%02x" ${hw_ct} )
    kmsg_log "platform_specific_card_override $VM_TYPE $VIRT_METHOD $PLATFORM $hw_ct"

    case "$hw_ct" in
    2[01234578])  # RSP4/RP2/RSP5/RP3 all
        platform_specific_card_rp_rsp $VM_TYPE $VIRT_METHOD $PLATFORM
      ;;
    29) # RP Starlord
      ;;
    ${IPU_TYPE_RPBB})
      platform_vxr_bb_cleanup
      ;;
    03)         # Octane
        platform_specific_card_octane $VM_TYPE $VIRT_METHOD $PLATFORM
      ;;
    ${IPU_TYPE_AZ}|${IPU_TYPE_BDW_LSQ}|${IPU_TYPE_BDW_LSP})     # Lightspeed LC
        if [[ "$hw_ct" == $IPU_TYPE_LCBB ]] || [[ "$hw_ct" == ${IPU_TYPE_LCSL} ]]; then
            platform_vxr_bb_cleanup $VM_TYPE $VIRT_METHOD $PLATFORM
        else
            platform_specific_card_azteca $VM_TYPE $VIRT_METHOD $PLATFORM
        fi
      ;;
    18)         # Questra 2T/1.2T LC
       platform_specific_card_questra $VM_TYPE $VIRT_METHOD $PLATFORM
      ;;
    04)         # Sureshot
      ;;
    05)         # Skyhammer
        platform_specific_card_skyhammer $VM_TYPE $VIRT_METHOD $PLATFORM
      ;;
    0c)         # LC Starlord
      ;;
     *)
      ;;
    esac
    return;
}

function platform_specific_override() {
    local VM_TYPE=$1
    local VIRT_METHOD=$2
    local PLATFORM=$3

    kmsg_log "platform_specific_override $VM_TYPE $VIRT_METHOD $PLATFORM"

    is_vxr_sim
    if [[ $? != 0 ]]; then
        platform_vxr_sim_cleanup $VM_TYPE $VIRT_METHOD $PLATFORM
    fi
    
    platform_specific_card_override $VM_TYPE $VIRT_METHOD $PLATFORM
    return
}
