#!/bin/bash
#------------------------------------------------------------------------------
# host_showtech_gatherer.sh                     
#
# July 2014
#
# Copyright (c) 2014-2017 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------------------


while [ "$#" -gt "0" ]; do
    case "$1" in
        -T) trace_only="1"; shift 1;;
        -S) show_only="1"; shift 1;;
        -t) cardtype="$2"; shift 2;;
        -f) media_path="$2"; shift 2;;
        -n) nodename="$2"; shift 2;;
        -c) clean="1"; shift 1;;
        *) shift;;
    esac
done

# This script returns either a filename or an empty string to the
# caller. The caller, on receipt of a non-empty string, will
# attempt to scp the filename from the hostOS.

if [ -z "$nodename" ]; then
    exit 0
elif [ "$nodename" = "system" ]; then
    exit 0
fi
if [ -z "$media_path" ]; then
    exit 0
fi

nodename_plus_host=${nodename}_host

# All logs etc will be accumulated into $fullpath
fullpath=$media_path/$nodename_plus_host

if [ "$clean" = "1" ]; then
    rm ${fullpath}.tgz
    rmdir $media_path; RCX=$?
    exit 0
fi

mkdir -p $fullpath ; RC=$?
if [ $RC -ne 0 ]; then
    exit 0
fi

SHOWTECH_LOGFILE=$fullpath/host_showtech_log

# media_path looks like:
# /misc/scratch/showtech/showtech-HBloss-admin-YYYY-month-dd.hhmmss.TZ
echo MEDIA_PATH $media_path >> $SHOWTECH_LOGFILE

# nodename looks like:
# 0_RP0, 0_LC
echo NODENAME $nodename >> $SHOWTECH_LOGFILE

# nodename_plus_host looks like:
# 0_RP0_host, 0_LC_host
echo NODENAME_PLUS_HOST $nodename_plus_host >> $SHOWTECH_LOGFILE

# fullpath is media_path concatenated with nodename_plus_host
echo FULLPATH $fullpath >> $SHOWTECH_LOGFILE

# cardtype - LC, RP, SC...
echo CARDTYPE $cardtype >> $SHOWTECH_LOGFILE

if [ -d /var/log/ctrace/hushd ]; then
    # Indicate for processes to dump their ctraces - by touching the ctrl file
    # in the ctrace directories, the applications using ctrace will write their
    # in-memory ctrace buffers to disk.
    echo "CMD: find /var/log/ctrace/hushd -name \*.ctrl | xargs touch" 1>> $SHOWTECH_LOGFILE
    find /var/log/ctrace/hushd -name \*.ctrl | xargs touch
fi

# If mlap_lite_hostos is running on this cardtype, its ctrace logs would be
# present in /var/log/ctrace/mlap_lite_hostos.
if [ -d /var/log/ctrace/mlap_lite_hostos ]; then
    # Touch control files for mlap_lite_hostos process to make it 
    # dump its traces to disk
    echo "CMD: find /var/log/ctrace/mlap_lite_hostos -name \*.ctrl | xargs touch" 1>> $SHOWTECH_LOGFILE
    find /var/log/ctrace/mlap_lite_hostos -name \*.ctrl | xargs touch
fi


# Copy entire /var/log directory
echo "CMD: ln -s /var/log $fullpath/log" 1>> $SHOWTECH_LOGFILE
ln -s /var/log $fullpath/log 1>> $SHOWTECH_LOGFILE 2>&1

echo "CMD: dmesg > $fullpath/DMESG 2>&1" >> $SHOWTECH_LOGFILE
dmesg > $fullpath/DMESG 2>&1

echo "CMD: ps -aef > $fullpath/ps_out 2>&1" >> $SHOWTECH_LOGFILE
ps -aef > $fullpath/ps_out 2>&1

echo "CMD: lvscan > $fullpath/lvscan_out 2>&1" >> $SHOWTECH_LOGFILE
lvscan > $fullpath/lvscan_out 2>&1

echo "CMD: lvdisplay > $fullpath/lvdisplay_out 2>&1" >> $SHOWTECH_LOGFILE
lvdisplay > $fullpath/lvdisplay_out 2>&1

echo "CMD: pvscan > $fullpath/pvscan_out 2>&1" >> $SHOWTECH_LOGFILE
lvdisplay > $fullpath/lvdisplay_out 2>&1

echo "CMD: lvscan > $fullpath/lvscan_out 2>&1" >> $SHOWTECH_LOGFILE
lvscan > $fullpath/lvscan_out 2>&1

N=`ls -1d /misc/scratch/sysadmin* 2>/dev/null 1| wc -l`
if [ $N -ne 0 ]; then
    for name in /misc/scratch/sysadmin*
    do
        targname=`basename $name`
        echo "CMD: ln -s $name $fullpath/$targname" >> $SHOWTECH_LOGFILE
        ln -s $name $fullpath/$targname 1>> $SHOWTECH_LOGFILE 2>&1
    done
fi

N=`ls -1d /misc/scratch/default-sdr-* 2>/dev/null 1| wc -l`
if [ $N -ne 0 ]; then
    for name in /misc/scratch/default-sdr-*
    do
        targname=`basename $name`
        echo "CMD: ln -s $name $fullpath/$targname" >> $SHOWTECH_LOGFILE
        ln -s $name $fullpath/$targname 1>> $SHOWTECH_LOGFILE 2>&1
    done
fi

(   cd $media_path
    tar --dereference -czf $nodename_plus_host.tgz $nodename_plus_host 1>/dev/null 2>&1
    echo $fullpath.tgz
)

# This will remove the directory we accumlated into
# media_path + nodename_plus_host
#
rm -fr $fullpath

exit 0
