#!/bin/bash
#
# Copyright (c) 2010-2016 by cisco Systems, Inc.
# All rights reserved.
#
# Calvados launch script
# This script is called from host's upstart.
# Do not exit from the script. Upstart will keep on
# respaw the script again and again.
#
# Please do not call this script directly.
# The check must be performed prior to launching script.
#
# To stop calvados use initctl stop calvados
# To start calvados use initctl start calvados
#
# The event "initctl emit start-calvados" launches this script.
# Please look at calvados.conf in /etc/init/ for launch.
#
#  $1 ---> extra sanity to make sure it is launched from upstart
#  $2 ---> called during initctl stop, cleanup the VM
  
# Default VM name

VMNAME=sysadmin
readonly PD_DYNAMIC="/opt/cisco/hostos/bin/calvados_launch_pd.sh"
if [ -f $PD_DYNAMIC ]; then
    . $PD_DYNAMIC
fi

readonly PI_DYNAMIC="/opt/cisco/hostos/bin/calvados_launch_common.sh"
if [ -f $PI_DYNAMIC ]; then
    . $PI_DYNAMIC
fi

if [ "$1" == "upstart" ]; then
    if [ "$2" == "stop" ]; then
        calvados_stop_pd
    else 
        calvados_start_pd
    fi
else
    echo
    echo
    echo "        This script can only be launched from upstart"
    echo "        Please do not call this script directly"
    echo "        Use "initctl stop calvados" to stop calvados"
    echo "        Use "initctl start calvados" to start calvados"
    echo
    echo
fi

