#!/bin/bash

# Copyright (c) 2010-2016 by cisco Systems, Inc.
# All rights reserved.
#


<<"COMMENT"
This script will be run as part of install back up cli to create a 
recovery partiton on the secondary disk of the RP.
Currently pci_disk volume grp is carved on the entire sec disk and there is no 
partition table.To create the partition table, we move the contents of the 
volume group to the end of the disk inorder to create space for the partition table
and the 2Gb DR partition.Then, move the contents of pci_disk to the begnning of partition 2. 

Script runs in 3 parts, first we create loop devices on the entire extent of the disk.Then
in phase_one the contents of disk are moved to one end.The partition_disk funcrion then creates
a partition table after which the restore_vg is run to move contents of pci_disk vol grp
to sdb2. If eveyrthing is successful then we cleanup any extra loop devices that were not used.

In cases where the script is killed or exits half way and the disk is in intermediate state, triggering the
script again will continue from where it was left off last. Incase of card reload the panini_syinit script will
create any loop devices that are still part of the volume group so that the data is still accessible.Once the script
is triggered again then it starts from where it left off.

COMMENT

exec >> /var/log/bootlogs/dr_rp_log
exec 2>&1

set -x
echo $$ > /tmp/dr_pid_file
echo "Created pid file /tmp/dr_pid_file with pid $$"
echo "$(date +'%h %d %H:%M:%S')"

modprobe dm-mirror
source /etc/init.d/calvados_bootstrap.cfg

# Volume group name
VG=pci_disk1

# DR partition size (in MiB)
DRSIZE_MB=$DISK_ONE_RECOVERY_PART_SIZE

# DR partition size
DRSIZE=$((DRSIZE_MB*1024*1024))
# Partition table size at the beginning and end of disk
PTSIZE=$((2*1024*1024))
# Unnecssary padding size
PADSIZE=$((16*1024*1024))
# Original disk/partition name
second_disk=$SECONDARY_DISK
if [ -z "$second_disk" ]; then
   echo "Secondary disk not present, DR creation not suppported."
   exit
fi   
DISK=/dev/$SECONDARY_DISK
DEVSIZE=$(fdisk -l ${DISK} 2>/dev/null | grep "Disk ${DISK}:"  | cut -d ',' -f2)
DEVSIZE=${DEVSIZE%bytes}
RESERVE_SIZE=$((DRSIZE + PTSIZE + PADSIZE))

PESIZE=$(pvs --nosuffix --units b --noheadings -o vg_extent_size $DISK)
PESTART=$(pvs --nosuffix --units b --noheadings -o pe_start $DISK)

LOOPDEV=( )
ALLOCCOUNT=$(pvs --noheadings -o pv_pe_alloc_count $DISK)
DRPART_NAME="RecoveryOs"
IS_PART=$(parted $DISK print < /dev/null | grep "partition0" | wc -l)

LOSIZE=$((15 * 1024 * 1024 * 1024))
#First time adjust the offset by 1MB for the partition table at the end.
DEVSIZE=$((DEVSIZE -(1024*1024-1)))
#1 MB for lvm meta data
DISK_LEFT=$((((DEVSIZE - LOSIZE) - 1024*1024-1) & ~(1024*1024-1)))


function phase_one {
   echo "Starting to move contents to beginning of the PV"
   while [ $ALLOCCOUNT -gt 0 ];
   do
       is_pv=$(pvscan | grep $LOOPDEV)
       is_ext_free=$(pvs --nosuffix --units b --noheadings -o pv_free $LOOPDEV)
       #if the loop device is part of VG and no extents are free there is nothing to move/resize
       if [ ! -z "$is_pv" ]; then
          DEVSIZE=$(pvs --nosuffix --units b --noheadings -o dev_size $DISK)
       fi
       if [ -z "$is_pv" ] || [[ ! -z "$is_pv" && is_ext_free -gt 0 ]]; then
       PVSIZE=$(pvs --nosuffix --units b --noheadings -o pv_size $DISK)
       PECOUNT=$(pvs --noheadings -o pv_pe_count $DISK)
       # Move contents to start of PV
       set -e
       pvmove -v --alloc anywhere ${DISK}:$((ALLOCCOUNT))-$((PECOUNT - 1)) ${DISK}:0-$((ALLOCCOUNT-1)) || true
           NEWSIZE=$((((DEVSIZE - LOSIZE) + 1024*1024-1) & ~(1024*1024-1)))
       pvresize -v --setphysicalvolumesize ${NEWSIZE}b $DISK
       ret=$?
       if [ $ret -ne 0 ]; then
           return $ret
       fi
       pvdisplay
       DEVSIZE=$NEWSIZE
   
       # Add loop device to VG and move data
       dd if=/dev/zero of=$LOOPDEV bs=1048576 count=4
       pvcreate $LOOPDEV
       LOOPDEV_P=( $LOOPDEV "${LOOPDEV_P[@]}" )
       ret=$?
       if [ $ret -ne 0 ]; then
           return $ret
       fi
       vgextend $VG $LOOPDEV
       FREE_EXTS=$(pvs --nosuffix --units b --noheadings -o pv_free $LOOPDEV)
       LOOP_PEFREE=$(pvs --nosuffix --units b --noheadings -o pv_pe_count $LOOPDEV)
       if [ $ALLOCCOUNT -lt $LOOP_PEFREE ]; then
	        pvmove -v ${DISK}
          ret=$?
          if [ $ret -ne 0 ]; then
              return $ret
          fi
          else
	           pvmove -v ${DISK}:$((ALLOCCOUNT-LOOP_PEFREE))-$((ALLOCCOUNT-1)) $LOOPDEV
             ret=$?
             if [ $ret -ne 0 ]; then
                return $ret
             fi
          fi
      fi 
       # Update remaining count
       ALLOCCOUNT=$(pvs --nosuffix --units b --noheadings -o pv_pe_alloc_count $DISK)
       LOOPDEV=( "${LOOPDEV[@]:1}" )
    set +e
   done
   # Remove original disk
   vgreduce $VG $DISK
   pvremove $DISK
   return 0
}

#func to restore the vg after the partition creation
function restore_vg {
   #first do a pvmove to finish pending move operation.
   echo "Partition has been created, starting to restore vol grp"
   pvmove -v
   ret=$?
   if [ $ret -ne 0 ]; then
      return $ret
   fi
   oldifs="$IFS"
   IFS=$'\n'
   LOOPDEV=($(losetup -a | sort --key 5 -n | awk '{print substr($1, 1, length($1)-1)}'))
   IFS=$oldifs
   
   while [ ${#LOOPDEV[@]} -gt 0 ];
   do
      # Move contents away from loop device
      loopinfo=( $(losetup $LOOPDEV 2>/dev/null | awk '{print $7}'))
      ifresize=$(pvscan | grep $LOOPDEV)
      #if the loop device is not part of the vg there is nothing to move/resize
      if [ ! -z "$ifresize" ]; then
         pvmove -v $LOOPDEV
         pvdisplay 
   
         # Remove loopback PV from VG
         vgreduce $VG $LOOPDEV
         pvremove $LOOPDEV
      fi
      losetup -d $LOOPDEV
      LOOPDEV=( "${LOOPDEV[@]:1}" )
   
      # Update final PV size
      if [ ! -z "$ifresize" ]; then 
         pvresize -v --setphysicalvolumesize $(($loopinfo + NEWSIZE))b ${DISK} 
         ret=$?
         if [ $ret -ne 0 ]; then
            return $ret
         fi
         NEWSIZE=$((PESTART + $(pvs --nosuffix --units b --noheadings -o pv_size $DISK)))
      fi
   done 
   pvresize -v ${DISK}
   ret=$?
      if [ $ret -ne 0 ]; then
         return $ret
      else
         return 0
   fi   
}


function partition_disk {
   # Partition disk
   ## Clear partition table
   dd if=/dev/zero of=$DISK bs=1048576 count=10 
   partprobe $DISK
   ## Create new partition
   echo "Creating new partition for DR on disk"
   dd if=/dev/zero of=$DISK bs=1048576 count=10 
   parted -s $DISK -- \
    mklabel gpt \
    unit MiB \
    mkpart partition01 0 $((DRSIZE_MB)) \
    set 1 boot on \
    mkpart partition02 $((DRSIZE_MB)) 100%
   partprobe $DISK
   sync 
   sleep 2
   # Start location of partition
   read unused STARTOFFSET unused <<< $(parted -s $DISK unit b print | grep partition02 | tr -d B)

   # Disk is now in partition 2
   ls -ltr /dev/sdb2
   if [ -b ${DISK}2 ]; then
      DISK=${DISK}2
   else
      exit
   fi

   #Format the partition and name it.
   /sbin/mkfs.vfat -F16 -n $DRPART_NAME /dev/sdb1
   
   # Restore PV/VG
   NEWSIZE=$((NEWSIZE-STARTOFFSET))

   ## Create final PV on new partition
   pvscan
   dd if=/dev/zero of=$DISK bs=1048576 count=4
   pvscan
   pvcreate --setphysicalvolumesize ${NEWSIZE}b $DISK
   vgextend $VG $DISK
   pvdisplay 
   vgdisplay $VG
   #return 0
}

function cleanup_loop_devices {
   while [ ${#LOOPDEV[@]} -gt 0 ];
   do
      loopinfo=( $(losetup $LOOPDEV 2>/dev/null | awk '{print $7}'))
      ifdiscard=$(pvscan | grep $LOOPDEV)
      if [ -z "$ifdiscard" ]; then
         losetup -d $LOOPDEV
         LOOPDEV=( "${LOOPDEV[@]:1}" )
      else   
         LOOPDEV=( "${LOOPDEV[@]:1}" )
      fi
   done    
}

function cleanup_after_success {
   virsh attach-disk sysadmin /dev/sdb1 vdboot --cache=none
    echo "Attached sdb1 to sysadmin"
    #if there are any unused loop devices delete them now
    cleanup_loop_devices 
    #delete the pid file
    rm /tmp/dr_pid_file
    echo "Deleted pid file"
    echo "$(date +'%h %d %H:%M:%S')"
}

# first create loop devices for entire disk
echo "Creating loop devices upfront"
while [ $DISK_LEFT -gt 0 ];
do
   #if loopdev already created during startup ignore and just add to list
   loop_exists=$(losetup -a | grep $DISK_LEFT | grep $LOSIZE)
   if [ -z "$loop_exists" ]; then
      LOOP=$(losetup -f --show --offset ${DISK_LEFT} --sizelimit ${LOSIZE} $DISK)
      echo "Creating loop device" $LOOP
      LOOPDEV=( "${LOOPDEV[@]}" $LOOP )
   else
      LOOP=$(echo $loop_exists | awk '{print substr($1, 1, length($1)-1)}')
      echo $LOOP "device exists"
      LOOPDEV=( "${LOOPDEV[@]}" $LOOP )
   fi
   DISK_LEFT=$((((DISK_LEFT - LOSIZE) + 1024*1024-1) & ~(1024*1024-1)))
done
losetup -a
#check for partition table on sdb, if there's partition table then check if there are any
#loop devices as part of VG, if so move them back to beginning of partition2
#if there is no partition table then based on if there are loop devices as part of
#VG start fresh or continue pvmove from where we last left off.

if (( $IS_PART == 0 )); then
   echo "Partition table doesn't exist starting by moving the PV"
   pvmove -v
   phase_one
   ret=$?
   if [ $ret -ne 0 ]; then
      exit 
   fi
   partition_disk
   restore_vg
   ret=$?
   if [ $ret -ne 0 ]; then
      exit 
   fi
   cleanup_after_success
else
   # Disk is now in partition 2
    if [ -b ${DISK}2 ]; then
       DISK=${DISK}2
    else
       exit
    fi
    pv_exists=$(pvscan | grep $DISK)
    if [ -z "$pv_exists" ]; then
       #create phy vol on sdb2 
       read unused STARTOFFSET unused <<< $(parted -s /dev/$SECONDARY_DISK unit b print | grep partition02 | tr -d B)
       cleanup_loop_devices
       LOOPDEV_SORTED=($(losetup -a  | sort --key 5 -n | awk '{print substr($1, 1, length($1)-1)}'))
       NEWSIZE=$(losetup $LOOPDEV_SORTED | awk '{print substr($5, 1, length($5)-1)}')
       NEWSIZE=$((NEWSIZE-STARTOFFSET))
       dd if=/dev/zero of=$DISK bs=1048576 count=4
       pvcreate --setphysicalvolumesize ${NEWSIZE}b $DISK
       vgextend $VG $DISK
       echo "Partition exists but volume not restored"
       restore_vg
    else 
       vol_grp_size=$(vgs --nosuffix --units b --noheadings -o vg_size $VG)
       phy_vol_size=$(pvs --nosuffix --units b --noheadings -o pv_size $DISK)
       if (( $vol_grp_size != $phy_vol_size ));then    
          PESTART=$(pvs --nosuffix --units b --noheadings -o pe_start $DISK)
          NEWSIZE=$((PESTART + $(pvs --nosuffix --units b --noheadings -o pv_size $DISK))) 
          echo "Partition exists but volume not restored"
          restore_vg
          ret=$?
          if [ $ret -ne 0 ]; then
             exit 
          fi   
       fi
       cleanup_after_success
   fi
fi
