#!/bin/bash
#------------------------------------------------------------------------------
# hushd_fuser_check.sh
#
# June 2015
#
# Copyright (c) 2015, 2017 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------------------
#
# Get the loop device list associated with the LV
(echo "$1"; losetup -j "$1") | ( while IFS=: read loop rest;
do
    # fuser return 0 if loop device is being used, script return 0
    # If fuser returns > 0 for all associated loop devices,
    # which means nobody is using this LV, then script return > 0
    FUSER_VERSION=1 fuser -c $loop > /dev/null 2>&1 && exit 0
done
exit 1
)
