#!/bin/bash
#
# Copyright (c) 2016 by cisco Systems, Inc.
# All rights reserved
# hushd_platform.sh - wrapper over rmon_spi_writer
#

SPI_script=/opt/cisco/hostos/bin/rmon_spi_writer
FPD_ROMMON_RUN_VER="0"
LC_SKYHAMMER_TBL_IDX="7"
 
function print_usage() {
   echo "Usage"
   echo "hushd_platform.sh update_flash "
   echo "boardtype flash_type              : Update boardtype in flash"
   echo "hushd_platform.sh get_bios_ver " 
   echo "boardtype flash_type              : Get BIOS version from flash"
}

###############################################################################
# command_handler
#   
# command parser and handler
#
# arg1 -> card table index to look up golden programming table 
#        in spi_writer
# arg2 -> 0: get running version , 1: get primary flash version
command_handler() {
    action=$1
    arg1=$2
    arg2=$3

    case $action in  
        update_flash)
             if [ -f $SPI_script ]; then
                 echo "$0: $action $arg1 $arg2" >> /tmp/hushd_platform_debug
                 if [ "$arg2" == $LC_SKYHAMMER_TBL_IDX ]; then
                     $SPI_script -t 1 -d -o -f "/opt/cisco/calvados/fpd/ucode/asr9k_bios.bin"
                 else
                     $SPI_script -s $arg2 -t 1 -f "/opt/cisco/calvados/fpd/ucode/asr9k_bios.bin"
                 fi
             fi
             ;;

        get_bios_ver)
             if [ -f $SPI_script ]; then
                 echo "$0: $action $arg1 $arg2" >> /tmp/hushd_platform_debug
                 if [ "$arg1" == $LC_SKYHAMMER_TBL_IDX ]; then
                     if [ "$arg2" != $FPD_ROMMON_RUN_VER ]; then
                        $SPI_script -t $arg2 -d -o -v > /dev/null 2>&1
                     else
                        $SPI_script -d -o -r > /dev/null 2>&1
                    fi
                 else
                     if [ "$arg2" != $FPD_ROMMON_RUN_VER ]; then
                        $SPI_script -s $arg1 -t $arg2 -v > /dev/null 2>&1
                     else
                        $SPI_script -s $arg1 -r > /dev/null 2>&1
                    fi
                 fi
             fi
             ;;

        *)
             print_usage
             ;;
    esac
}

###############################################################################
# main.... 
#
# start up loop if no arguments, otherwise do command
#

if test $# == 0; then
    print_usage
else
    command_handler $1 $2 $3
fi

