#!/bin/bash
#
# Script to collect pci config information 
#
# Copyright (c) 2014-2015 by Cisco Systems, Inc.
# All rights reserved.
#

# Inputs to script - $1 - host bdf or hwid
# If host bdf is not supplied or not correct it
# only collects "lspci -tv"

if [ -z "$1" ]
then
  LOGDIR="/misc/scratch/no_bdf_pci_logs_`date +"%Y-%m-%d-%H:%M"`"
else
  LOGDIR="/misc/scratch/${1}_pci_logs_`date +"%Y-%m-%d-%H:%M"`"
fi
mkdir -p $LOGDIR
LOG=$LOGDIR/lspci.log
> $LOG

T=`lspci -H1 -tv`
echo -e "$" "lspci -H1 -tv" >>$LOG
echo -e "\n$T" $* >>$LOG

if [ -z "$1" ]
then
  echo -e "\n No Host PCI B:D:F supplied" $* >>$LOG
  D=`lspci -vv`
  echo -e "$" "lspci -vv" >>$LOG
  echo -e "\n$D" $* >>$LOG
else
  D=`lspci -H1 -vvs $1 `
  echo -e "$" "lspci -H1 -vvs" $1 >>$LOG
  echo -e "\n$D" $* >>$LOG
fi

cp /var/log/messages $LOGDIR
dmesg > $LOGDIR/dmesg.log
sync

