#!/bin/sh
#
# cgroup_oom.sh:
#     This script is responsible, for restarting cgroup_oom binary, if either
#     if exits or gets killed.
# 
# Expects one argument
# $1 - the threshold value, that cgroup_oom binary is supposed to monitor.
#
# January 2015, Alphonse Hansel A Selvanayagam
#
# Copyright (c) 2015 by cisco Systems, Inc.
#

THRESHOLD_BYTES=$1
OOM_NEVER="-17"

VMTYPE=`cat /proc/cmdline | grep vmtype=`
if [ -n "$VMTYPE" ]; then
    VMTYPE=`cat /proc/cmdline | sed 's/^.*vmtype=//' | cut -d" " -f1`
fi

if [[ "$VMTYPE" == "sysadmin-vm" ]]; then
    CGROUP_OOM_BINARY="/opt/cisco/calvados/bin/cgroup_oom"
elif [[ "$VMTYPE" == "xr-vm" ]]; then
    CGROUP_OOM_BINARY="/pkg/bin/cgroup_oom"
else
    exit
fi

while true; do

    #
    # Kill the pre-existing process
    #
    ps aux | grep "$CGROUP_OOM_BINARY" | grep -v grep  \
                | awk ' { print $2 } ' | xargs kill -9 >/dev/null 2>&1

    # 
    # Start the process in the background and assign OOM priority & nice value.
    #
    $CGROUP_OOM_BINARY /dev/cgroup/memory $THRESHOLD_BYTES > /dev/null 2>&1 &
    CGROUP_OOM_PID=$!
    echo -n "$OOM_NEVER" > /proc/$CGROUP_OOM_PID/oom_adj >/dev/null 2>&1
    renice -20 -p $CGROUP_OOM_PID > /dev/null 2>&1

    #
    # If the process dies, then go ahead and restart it.
    # No use, checking the error code, since we don't expect
    # cgroup_oom binary to exit gracefully.
    #
    wait $CGROUP_OOM_PID
done
