#! /bin/bash


#------------------------------------------------------------------
# Sync docker config from XR linux to the host
#
# April, 2016 Budhaditya Banerjee
#
# Copyright (c) 2016-2017 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------

# This script will validate the /misc/app_host/etc/sysconfig/docker file and 
# sync it with the host only if the changes are valid
# Definition of what is valid is explained in /etc/sysconfig/docker

# Following are the valid configs
# DOCKER_OPTS="<space>--insecure-registry<space>foo"
# DOCKER_OPTS+="<space>--insecure-registry<space>bar"

REG='DOCKER_OPTS\+?="(\s+--insecure-registry\s+\S+)*\s*"'
COM='^\s*#.*$'
SPC='^\s*$'

while read -r LINE; do
    if ! [[ $LINE =~ $COM ]]; then
        if  [[ $LINE =~ $REG ]] || [[ $LINE =~ $SPC ]]; then
	    FLAG=1
	else
	    FLAG=0
	    break
	fi
    fi
done < /misc/app_host/etc/sysconfig/docker

if [[ ${FLAG} == 1 ]]; then
    cp /misc/app_host/etc/sysconfig/docker /etc/sysconfig/docker
    # restart the docker daemon after config change
    service docker restart
elif [[ ${FLAG} == 0 ]]; then
    # If the config is not valid, copy the valid one from the host
    # to the staging directory, which will then be synced to XR
    # User has to again make valid changes
    cp /etc/sysconfig/docker /misc/app_host/etc/sysconfig/docker
fi
