#!/bin/bash
# This script is going to find the IPU base and get to the rp_fc_i2c register
# The speed count decides the clock speed and so the data rate.
# This was a factor of 5 which is 1/512 of the CPU clock (50 Mhz) in classic
# This is now changed to a factor of 3 which is 1/128 of CPU clock, thus making
# the data rate to 400 Kbps.
# This is only triggered from the driver and will not impact classic
# Vaithiyanathan Sundaram
# Copyright (c) 2015 Cisco Systems Inc.
#

source /etc/init.d/pd-functions

FP_FC_OFF=0x259400
IPU_BASE=$(get_ipu_base_safe)
ADDR=$(printf 0x%x $(($IPU_BASE + $FP_FC_OFF)))
CFG_START=0x20
# For each FCs
for i in 0x0 0x1 0x2 0x3 0x4 0x5 0x6;
do
OFF=$(printf 0x%x $((${ADDR} + ${CFG_START} + (($i * 0xc)))))
pcimemwrite $OFF 4 00630000 > /dev/null
done

