#!/pkg/bin/perl
##
 # bd_rates.pl
 #
 #------------------------------------------------------------------
 # Copyright (c) 2012-2013 by Cisco Systems, Inc.
 # All rights reserved.
 # Author: Jean-Christophe Rode (jrode), Avaneendra Alugupalli (avaneend)
 #
 #------------------------------------------------------------------
 ##
# require '/pkg/bin/bd_rates.pl';
# Then run: perl /pkg/bin/bd-rates.pl
# Questions: jrode@cisco.com

print "Capturing first snapshot of \"show l2vpn bridge-domain detail\". This may take a while...\n";

my $start = time();
@snapshot1=qx(/pkg/bin/l2vpn_show -d 0x9);
print "Done. Sleeping 10 seconds...\n";
sleep(10);
my $end = time();
my $diff = $end - $start;

print "Capturing second snapshot of \"show l2vpn bridge-domain detail\". This may take a while...\n";
@snapshot2=qx(/pkg/bin/l2vpn_show -d 0x9);
print "Done.\n";

# Structure of the data
# %stat is an associative array whose key is the string <brige-group>:<bridge-domain>
# Each value is an array [<input packets>, <output packets>]
# <inuput packets> is the sum of the input packets of all ACs and PWs in the BD
# <output packets> is the sum of the output packets of all ACs and PWs in the BD

$in=0;
$out=0;
$name="";

foreach my $current (@snapshot1) {
  chomp($current);
  if ($current =~ m/Bridge group: (.*), bridge-domain: (.*), id:/) {
      # New bridge-group, let's save the data from the previous one (if it's not the first one).
      if ($name ne "") {$stat1{$name} = [$in,$out] };
      # Resetting the counters for the in and out packet counters for this new BD
      $in=0;
      $out=0;
      $name="$1:$2";
  }

  if ($current =~ m/packets: received (\d+), sent (\d+)/) {
      $in += $1;
      $out += $2;
  }
}
if ($name ne "") { $stat1{$name} = [$in,$out] };
close $snapshot1;

$in=0;
$out=0;
$name="";
foreach my $current (@snapshot2) {
    chomp($current);
    if ($current =~ m/Bridge group: (.*), bridge-domain: (.*), id:/) {
        # New bridge-group, let's save the data for the previous one.
        if ($name ne "") { $stat2{$name} = [$in,$out]};
        # Resetting the counters for the in and out packet counters for this new BD
        $in=0;
        $out=0;
        $name="$1:$2";
    }
                                  
  if ($current =~ m/packets: received (\d+), sent (\d+)/) {
      $in += $1;
      $out += $2;
  }
} 
if ($name ne "") { $stat2{$name} = [$in,$out]};
close $snapshot2;


#Compute rates

foreach $bd (keys %stat1) {
    $input_rate = int(($stat2{$bd}[0] - $stat1{$bd}[0]) / $diff);
    $output_rate = int(($stat2{$bd}[1] - $stat1{$bd}[1]) / $diff);
    $rates{$bd} = [$input_rate,$output_rate];
}

#Sort by descending input rate

print "\n\n\nBridge-domain rates sorted by descending order of the input rates:\n\n";
     
sub DescendingInputRate {
    $rates{$b}[0] <=> $rates{$a}[0];
}
foreach $bd (sort DescendingInputRate (keys(%rates))) {
    print "$bd: input rate = $rates{$bd}[0] pps, output rate = $rates{$bd}[1] pps\n";
}




#!/pkg/bin/perl
##
 # bd_rates.pl
 #
 #------------------------------------------------------------------
 # Copyright (c) 2012-2013 by Cisco Systems, Inc.
 # All rights reserved.
 # Author: Jean-Christophe Rode (jrode), Avaneendra Alugupalli (avaneend)
 #
 #------------------------------------------------------------------
 ##
# require '/pkg/bin/bd_rates.pl';
# Then run: perl /pkg/bin/bd-rates.pl
# Questions: jrode@cisco.com

print "Capturing first snapshot of \"show l2vpn bridge-domain detail\". This may take a while...\n";

my $start = time();
@snapshot1=qx(/pkg/bin/l2vpn_show -d 0x9);
print "Done. Sleeping 10 seconds...\n";
sleep(10);
my $end = time();
my $diff = $end - $start;

print "Capturing second snapshot of \"show l2vpn bridge-domain detail\". This may take a while...\n";
@snapshot2=qx(/pkg/bin/l2vpn_show -d 0x9);
print "Done.\n";

# Structure of the data
# %stat is an associative array whose key is the string <brige-group>:<bridge-domain>
# Each value is an array [<input packets>, <output packets>]
# <inuput packets> is the sum of the input packets of all ACs and PWs in the BD
# <output packets> is the sum of the output packets of all ACs and PWs in the BD

$in=0;
$out=0;
$name="";

foreach my $current (@snapshot1) {
  chomp($current);
  if ($current =~ m/Bridge group: (.*), bridge-domain: (.*), id:/) {
      # New bridge-group, let's save the data from the previous one (if it's not the first one).
      if ($name ne "") {$stat1{$name} = [$in,$out] };
      # Resetting the counters for the in and out packet counters for this new BD
      $in=0;
      $out=0;
      $name="$1:$2";
  }

  if ($current =~ m/packets: received (\d+), sent (\d+)/) {
      $in += $1;
      $out += $2;
  }
}
if ($name ne "") { $stat1{$name} = [$in,$out] };
close $snapshot1;

$in=0;
$out=0;
$name="";
foreach my $current (@snapshot2) {
    chomp($current);
    if ($current =~ m/Bridge group: (.*), bridge-domain: (.*), id:/) {
        # New bridge-group, let's save the data for the previous one.
        if ($name ne "") { $stat2{$name} = [$in,$out]};
        # Resetting the counters for the in and out packet counters for this new BD
        $in=0;
        $out=0;
        $name="$1:$2";
    }
                                  
  if ($current =~ m/packets: received (\d+), sent (\d+)/) {
      $in += $1;
      $out += $2;
  }
} 
if ($name ne "") { $stat2{$name} = [$in,$out]};
close $snapshot2;


#Compute rates

foreach $bd (keys %stat1) {
    $input_rate = int(($stat2{$bd}[0] - $stat1{$bd}[0]) / $diff);
    $output_rate = int(($stat2{$bd}[1] - $stat1{$bd}[1]) / $diff);
    $rates{$bd} = [$input_rate,$output_rate];
}

#Sort by descending input rate

print "\n\n\nBridge-domain rates sorted by descending order of the input rates:\n\n";
     
sub DescendingInputRate {
    $rates{$b}[0] <=> $rates{$a}[0];
}
foreach $bd (sort DescendingInputRate (keys(%rates))) {
    print "$bd: input rate = $rates{$bd}[0] pps, output rate = $rates{$bd}[1] pps\n";
}




