#!/pkg/bin/perl
##
 # dataplane_infra.pl
 #
 #------------------------------------------------------------------
 # Copyright (c) 2012 by Cisco Systems, Inc.
 # All rights reserved.
 # Author: Shawn Smith (shawmit), Joshua Jodrey (jjodrey)
 #
 #------------------------------------------------------------------
 ##

#require '/harddisk:/dataplane_subs.pl';
require '/pkg/bin/dataplane_subs.pl';

our $global_fields_ref;
our %fields;
our %cli_cache;
return 1;

#########################################################

sub init_global_fields {
    $global_fields_ref = shift;
    %fields = %{$global_fields_ref};
}

sub get_dataplane_object_instance {
    my $hw_map_arg = shift;
    my $start_object = shift;
    my $get_object_type = shift;
    my $instance_num = -1;
    my $interface = "";
    my $location = "";
    my $lc = "";
    my $np = "";
    my %hw_map;

    if ($hw_map_arg =~ /(\w*)Gig.*?E.*?(\d+_(\d+)_\d+_\d+)/) {
        $interface = $1 . "GigE" . $2;
        $location = "0/$3/CPU0";
        $lc = "LC" . $3;
        %hw_map = %{getHardwareMap($location)};
    } elsif ($hw_map_arg =~ /0\/(\d+)\/CPU0/) {
        $location = $hw_map_arg;
        $lc = "LC" . $1;
        %hw_map = %{getHardwareMap($hw_map_arg)};
    } else {
        printf("Cannot retrieve hw map using (%s), must be interface or location\n", $hw_map_arg);
        exit;
    }

    #Due to complexities of Juggernaut punt path, this LC is not currently supported
    if ($hw_map{NAME} eq "Juggernaut") {
        printf("Linecard is not currently supported\n");
        exit;
    }
    
    if ($get_object_type eq "NP") {
    } elsif ($get_object_type eq "FIA") {
    } elsif ($get_object_type eq "PORT_IN") {
        return @{$hw_map{$start_object}{PORT_IN}};
    } elsif ($get_object_type eq "PUNT_PORT") {
        return @{$hw_map{$start_object}{PUNT_PORT}};
    } elsif ($get_object_type eq "LOC") {
        return $location;
    } elsif ($get_object_type eq "LC") {
        return $lc;
    } else {
        printf("ERROR:: Object type %s not supported for interface (%s) on location (%s)\n",
               $get_object_type, $interface, $location);
        return -1;
    }

    my $startingKey = $start_object;
    my $prettyInterface = "";
    
    # If an interface was passed and no start object, use interface as starting object
    if ($interface && ($start_object eq "")) {
        $interface =~ /(\w*)Gig.*?E.*?(\d+)_(\d+)_(\d+)_(\d+)/;
        $startingKey = $1 . "GigE" . $4 . "_" . $5;
        $prettyInterface = "$1$2/$3/$4/$5";
    }
        
    $hwObject = $startingKey;
    while(exists $hw_map{$hwObject}{CONNECTS_TO}) {
        
        if ($hwObject =~ /$get_object_type(\d+)/) {
            $instance_num = $1;
            
        }

        $hwObject = $hw_map{$hwObject}{CONNECTS_TO};
    }
    
    return $instance_num;
}

sub set_sysmgr_pid {
    # Setup the EXEC_PID for showtech_helper
    my $output = `sysmgr_show -o -p exec`;
    if ($output =~ /PID: (\d+)/) {
        $ENV{'EXEC_PID'} = $1;
    }else{
        die "Failed to get permissions\n";
    }
}

#########################################################
# sub field{
#
#  Description: Extract tidbits of data from a CLI using
#               a regular expression, and format results
#               into a string for display.
#
#  argument 1:  the name in the %fields hash to use
#  argument 2:  $args[0] - used to pass args 
#  argument 3:  $args[1]
#  argument 4:  $args[2]
#  argument 5:   ...
#
#  1. The CLI as defined in %fields{ 'cli' } is run
#  2. The regular expressin %fields{ 'regexp' } is applied
#  3. The @values are obtained from $1, $2, $3, etc of that
#  4. The output string is generated as below:
#
#      returns: sprintf( $format, @values)
#                           |        |
#                           |        Defined in %fields{ 'values' }
#                           Defined in %fields{ 'format' }
#  
#  Options: $CLEAR                  : To clear the counter using %fields{ 'clear' }
#  Options: $DEBUG = 'all'          : To just display all the %fields entry names
#  Options: $DEBUG = 'Field_Name'   : To debug a specific %fields entry only
#  Options: $ANNOTATE               : To annotate the CLI used on the right column
sub field{
   my $entry = shift;
   return "SKIP $entry" if (($DEBUG) && $DEBUG ne $entry);
   my @args = @_;

   die "Field not found \$fields{'$entry'} - internal CLI problem\n"
       if ! defined $fields{$entry};

   my $clear = ${$fields{$entry}}{'clear'};
   $clear = eval "qq{$clear}";

   if ($CLEAR) {
       if ($clear =~ /^\s*$/){
          print "Clearing [$entry] not Available\n" if ($ANNOTATE);
          return sprintf("%18s: No Clear", $entry);
       }else{
          print "Clearing [$entry] via '$clear'\n" if ($ANNOTATE);
       }
       $clear =~ s/ /%20/g;
       if (exists $cleared{$clear}){
           return sprintf("%18s: Cleared", $entry);
       }else{
          `showtech_helper $clear`;
          $cleared{$clear} = 1;
       }
       return sprintf("%18s: Cleared", $entry);
   }

   #
   # Get the CLI specified and convert any $vars 
   #
   my $cli = ${$fields{$entry}}{'cli'};
   $cli = eval "qq{$cli}";

   #
   # If CLI exists in cache, use stored output
   #
   my $field_cli = '';
   my $cli_output = '';
   
   #
   # Add the percent twenty '%20' for showtech_helper
   #
   $field_cli = $cli;
   $field_cli =~ s/ /%20/g;

   #
   # If CLI exists in cache, use stored output
   #
   if (!exists $cli_cache{$cli}) {
       $cli_output = `showtech_helper $field_cli`;
       $cli_cache{$cli} = $cli_output;
   } else {
       $cli_output = $cli_cache{$cli};
   }

   my $regex = ${$fields{$entry}}{'regex'};
   my $m_regex = ${$fields{$entry}}{'m_regex'};
   my $format = ${$fields{$entry}}{'format'};
   my $value  = ${$fields{$entry}}{'value'};
   my @values = @{${$fields{$entry}}{'values'}};
   my @values_result = ();

   if (($DEBUG eq 'all') || ($DEBUG eq $entry)){
      if ($cli_output =~ /^\s*$/){
          print "DEBUG: -------------------------------------\n";
          print "DEBUG:  ERR: Null CLI output '', from '$cli'\n";
          print "DEBUG:      field_cli=$field_cli\n";
          print "DEBUG:      final_cli=$field_cli\n";
          print "DEBUG:-------------------------------------\n";
      }else{
          my $debug_cli_output = $cli_output;
          $debug_cli_output =~ s/^/CLI:/mg;
          print  $debug_cli_output;
      }
      print  "\n";
      print  "DEBUG: ======================================================\n";
      printf "DEBUG: %25s = {\n", "\$fields{'$entry'}";
      print  "DEBUG:         'cli'    => '" . $cli .    "',\n";
      print  "DEBUG:         'regex'  => '" . $regex .  "',\n" if ($regex); 
      print  "DEBUG:         'm_regex'  => '" . $m_regex .  "',\n" if ($m_regex);
      print  "DEBUG:         'format' => '" . $format . "',\n";
      print  "DEBUG:         'values' => ['" . join ("', '", @values) . "'],\n";
      print  "DEBUG:         'clear' => '" . $clear . "',\n";
      print  "DEBUG:        };\n";
      print  "DEBUG: ======================================================\n";
   }

   # This is a Perl Hack thing to allow variable interpretation
   #  in the regular expression. The slash '\' is replaced with
   #  double slash '\\' to allow eval "qq{$regexp_qq}" to work.
   my $regex_qq = '';
   if ($regex) {
       $regex_qq = $regex;
   } elsif ($m_regex) {
       $regex_qq = $m_regex;
   } else {
       die "ERROR: No regex or m_regex defined for field $fields{$entry}!\n";
   }
   $regex_qq =~ s/\\/\\\\/g;
   $regex_qq = eval "qq{$regex_qq}";

   
   #
   # $DEBUG support for un-matched regular expressions
   #

  # while($cli_cache{$cli} =~ m/$regex_qq/g) {
  #     print "Protocol: $3$9\n";
  # }
  # die "done";
   if ( $regex && ! ( $cli_output =~ /$regex_qq/ms )){
       if (($DEBUG eq 'all') || ($DEBUG eq $entry)){
           print "DEBUG:         --       NO REGEX MATCH!      --  \n";
           print "DEBUG: ======================================================\n";
           print "DEBUG:  regexp= '$regex'\n";
           print "DEBUG:  regexp= '$regex_qq'\n";
           print "DEBUG: ======================================================\n";
       }
   }elsif ( $m_regex && ! ( $cli_cache{$cli} =~ s/$regex_qq// )){
       if (($DEBUG eq 'all') || ($DEBUG eq $entry)){
           print "DEBUG:         --       NO REGEX MATCH!      --  \n";
           print "DEBUG: ======================================================\n";
           print "DEBUG:  regexp= '$m_regex'\n";
           print "DEBUG:  regexp= '$regex_qq'\n";
           print "DEBUG: ======================================================\n";
       }
       
       # If no more multiline matches, clear cli cache and return an empty string
       # Do not delete if RSP is not present "Failed to bind"
       if ( ! ($cli_output =~ /Failed to bind to NetIO/)) {
           delete $cli_cache{$cli};
       }
       return '';
   }else{
       print  "DEBUG:         --             MATCH!           --  \n"
           if (($DEBUG eq 'all') || ($DEBUG eq $entry));
       
   }

   #
   # The @values_result is the results for displaying
   #  values_result[0] only supports being a string! see eval "qq{$first}" below
   #  values_result[1]  perl eval                    see eval $_ below
   #  values_result[2]  perl eval
   #  values_result[3]  perl eval
   #           ...        ...
   #
   my $first = shift @values;
   push @values_result, eval "qq{$first}";
   foreach (@values){
           push @values_result,    eval $_;
   }
   
   #
   #  Debug support for showing what the regular expression results
   #   are, plus the final formatting.
   #
   if (($DEBUG eq 'all') || ($DEBUG eq $entry)){
      print  "DEBUG:\n";
      printf "DEBUG: %10s \n", "$entry:";
      my $max = 1;
      my @numbered_match = ();
      push (@numbered_match, defined $1 ? $1 : 'undef'); $max = 1 if defined $1;
      push (@numbered_match, defined $2 ? $2 : 'undef'); $max = 2 if defined $2;
      push (@numbered_match, defined $3 ? $3 : 'undef'); $max = 3 if defined $3;
      push (@numbered_match, defined $4 ? $4 : 'undef'); $max = 4 if defined $4;
      push (@numbered_match, defined $5 ? $5 : 'undef'); $max = 5 if defined $5;
      push (@numbered_match, defined $6 ? $6 : 'undef'); $max = 6 if defined $6;
      push (@numbered_match, defined $7 ? $7 : 'undef'); $max = 7 if defined $7;
      push (@numbered_match, defined $8 ? $8 : 'undef'); $max = 8 if defined $8;
      push (@numbered_match, defined $9 ? $9 : 'undef'); $max = 9 if defined $9;
      push (@numbered_match, defined $10 ? $10 : 'undef'); $max = 10 if defined $10;
      push (@numbered_match, defined $11 ? $11 : 'undef'); $max = 11 if defined $11;
      push (@numbered_match, defined $12 ? $12 : 'undef'); $max = 12 if defined $12;
      push (@numbered_match, defined $13 ? $13 : 'undef'); $max = 13 if defined $13;
      push (@numbered_match, defined $14 ? $14 : 'undef'); $max = 14 if defined $14;
      push (@numbered_match, defined $15 ? $15 : 'undef'); $max = 15 if defined $15;
      push (@numbered_match, defined $16 ? $16 : 'undef'); $max = 16 if defined $16;


      $i=1;
      foreach (@numbered_match){
         printf "DEBUG: %15s         \$$i='$_'\n";
         #last if $i > $max;
         $i++;
      }

      $i=0;
      foreach $item (@values_result){
         printf "DEBUG: %15s \$values[$i]='$item'\n";
         $i++;
      }
      printf "DEBUG: %15s     format= '%s'\n", "", sprintf($format, @values_result);
      print "DEBUG: ======================================================\n";
   }

   #
   # ANNOTATE support simply prints a few lines of info before returning
   #  
   my $ret_string = sprintf($format, @values_result);
   if ($ANNOTATE){
      printf("%80s| $cli\n", "", $cli);
   }

   return $ret_string;
}

