#!/pkg/bin/perl
##
 # dataplane_main.pl
 #
 #------------------------------------------------------------------
 # Copyright (c) 2012 by Cisco Systems, Inc.
 # All rights reserved.
 # Author: Joshua Jodrey
 #
 # version 1.0 (tested in 4.3)
 #------------------------------------------------------------------
 ##

#require 'platforms/viking/lc/prm/scripts/dataplane_subs.pl';
require '/pkg/bin/dataplane_subs.pl';
#require 'dataplane_subs.pl';

#**********************************#
#             Main Block           #
#**********************************#
BEGIN { $SIG{'__WARN__'} = sub { &warn_error ($_[0]); }}

$globalHwMap_ref;
$globalChassisType = getChassisType();

if ($#ARGV > 4) {
    print "Invalid Number ($#ARGV) of Arguments!!\n";
    exit;
}


my $operationArg = $ARGV[0];			# counters/clear/drops/map/punt-inject
my $locationArg = $ARGV[1];                     # interface/location/all

my $slotArg = 0;
my $interfaceArg = 0;

if ($locationArg eq "location") {
    if ($operationArg eq "map") {
        $locationString = $ARGV[2];
        $globalHwMap_ref = getHardwareMap($locationString);
    } else {
        print "This functionality is not currently supported\n";
        exit;
    }	
} elsif ($locationArg eq "interface") {
    $interfaceArg = convertInterface($ARGV[2]);	# In the form of (type)(rack)_(slot)_(subslot)_(interface), eg: TenGigE0_1_0_3

    if ($interfaceArg =~ /GigE\d+_(\d+)_\d+_\d+/) {
        $locationString = "0/$1/CPU0";
        $globalHwMap_ref = getHardwareMap($locationString);
    } else {
        printf("Interface type %s is not supported by this command\n", $interfaceArg);
        exit;
    }
} elsif ($locationArg eq "all") {
    print "This functionality is not currently supported\n";
    exit;
} else {
    print "Invalid Location Argument: '$locationArg'\n";
    exit;
}

# The verbose option prints the full output of each CLI
if ($ARGV[3] eq "verbose") {
    our $verbose = 1;
} else {
    our $verbose = 0;
}

if ($operationArg eq "counters") {

    if ($locationArg eq "interface") {
	# Juggernaut is the only non-bidirectional linecard, so it has it's own handling
	if ($globalHwMap_ref->{NAME} eq "Juggernaut") {
		interfaceDataplaneWalkJuggernaut($globalHwMap_ref, $locationString, $interfaceArg);
	} else {
		interfaceDataplaneWalk($globalHwMap_ref, $locationString, $interfaceArg);
	}
    } else {
        print "This functionality is not currently supported\n";
        exit;
    }
} elsif ($operationArg eq "drops") {

    if ($locationArg eq "interface") {
	# Juggernaut is the only non-bidirectional linecard, so it has it's own handling
	if ($globalHwMap_ref->{NAME} eq "Juggernaut") {
		interfaceDataplaneDropsJuggernaut($globalHwMap_ref, $locationString, $interfaceArg);
	} else {
		interfaceDataplaneDrops($globalHwMap_ref, $locationString, $interfaceArg);
	}
    } else {
        print "This functionality is not currently supported\n";
        exit;
    }
} elsif ($operationArg eq "clear") {

    if ($locationArg eq "interface") {
        confirmClear();
	interfaceDataplaneClear($globalHwMap_ref, $locationString, $interfaceArg);
    } else {
        print "This functionality is not currently supported\n";
        exit;
    }
} elsif ($operationArg eq "map") {

	if ($locationArg eq "location"){
		# Juggernaut is the only non-bidirectional linecard, so it has it's own handling
		if ($globalHwMap_ref->{NAME} eq "Juggernaut") {
			dataplaneMapJuggernaut($globalHwMap_ref, $locationString);
		} else {
			dataplaneMap($globalHwMap_ref, $locationString);
		}
	} elsif ($locationArg eq "interface") {
		# Juggernaut is the only non-bidirectional linecard, so it has it's own handling
		if ($globalHwMap_ref->{NAME} eq "Juggernaut") {
			dataplaneMapJuggernaut($globalHwMap_ref, $locationString, $interfaceArg);
		} else {
			dataplaneMap($globalHwMap_ref, $locationString, $interfaceArg);
		}
	} else {
		print "This functionality is not currently supported\n";
        exit;
	}
} else {
	printf("Operation Not Currently Supported: %s\n", $operationArg);	
}

exit;
