##############################################################
#    Date: 2012-08-14                                        #
#  Author: Shawn Smith  (shawsmit), Joshua Jodrey (jjodrey)  #
# Program: Punt Inject CLI define                            #
#                                                            #
# Copyright (c) 2012 by Cisco Systems, Inc.                  #
##############################################################

require '/pkg/bin/dataplane_infra.pl';

#############################################################################
# These FIELD defines make formatting easier below
my $FIELD_______FIELD = '%-18s';
my $FIELD________FIELD = '%-19s';
my $FIELD_________FIELD = '%-20s';
my $FIELD__________FIELD = '%-21s';
my $FIELD___________FIELD = '%-22s';
my $FIELD____________FIELD = '%-23s';
my $FIELD_____________FIELD = '%-24s';
my $FIELD______________FIELD = '%-25s';
my $FIELD_______________FIELD = '%-26s';
my $FIELD________________FIELD = '%-27s';
my $FIELD_________________FIELD = '%-28s';
my $FIELD__________________FIELD = '%-29s';
my $FIELD___________________FIELD = '%-30s';
my $FIELD____________________FIELD = '%-31s';
my $FIELD_____________________FIELD = '%-32s';
my $FIELD______________________FIELD = '%-33s';
my $FIELD_______________________FIELD = '%-34s';
my $FIELD________________________FIELD = '%-35s';
my $FIELD_________________________FIELD = '%-36s';

%my_fields = (
               'RSP_Netio_Protocols' => {
                   'cli'     => 'show netio clients location $args[0]',
                   'm_regex' => '(((\w+)\s+([HL]) (\d+)\/(\d+)\s+(\d+)\/(\d)\s+'.
                                '|(\w+)\s+(\d+)\/(\d+)\s+(\d+)\/(\d+)\s+'.
                                '| \s+([HL]) (\d+)\/(\d+)).*)',
                   'format'  => '%18s: %d/%d',
                   'values'  => ['$3$9 $4$14', '($6 + $11 + $16)', '($8 + $13)'] ,
                   'clear'   => 'clear netio client statistics location $args[0]',
               },

               # 'LC_SPP_Protocols'
               #
               # This is implemented in special handler function, get_spp_protocols()   
               #
                   
               'SPP_port' => {
                 'cli'    => 'show spp interface loc $args[0]',
                 'regex'  => 'port(\d+)\s+rx pkts:\s+(\d+)'.
                             '.*?tx pkts:\s+(\d+)',
                 'format' => '%18s: %d/%d',
                 'values' => ['SPP port$1', '$2', '$3'],
                 'clear'  => 'clear spp interface loc $args[0]',
                 },
               
               'RSP_Punt_FPGA' => {
                 'cli'    => 'show control fabric fia bridge stats loc $args[0]',
                 'regex'  => 'From CPU\s+(\d+).*?From FIA\s+(\d+)',
                 'format' => '%18s: %d/%d',
                 'values' => ['Punt FPGA','$1', '$2'],
                 'clear'  => 'clear controller fabric crossbar-counters loc $args[0]',
                 },
               'RSP_Fabric_Fia' => {
                 'cli'    => 'show control fabric fia stats loc $args[0]',
                 'regex'  => '(To|From) Line Interface.0.\s+(\d+).*?'.
                             '(To|From) Line Interface.0.\s+(\d+)',
                 'format' => '%18s: %d/%d',
                 'values' => ['Fabric Fia','$2', '$4'],
                 'clear'  => 'clear controller fabric fia loc $args[0]',
                 },

               'LC_Fabric_Fia_1port' => {
                 'cli'    => 'show control fabric fia stats loc $loc',
                 'regex'  => 'FIA-$args[0].*?'.
                             'To Line Interface.$args[1].\s+(\d+).*?'.
                             'From Line Interface.$args[1].\s+(\d+)',
                 'format' => '%18s: %d/%d',
                 'values' => ['Fabric FIA$args[0]','$1', '$2'],
                 'clear'  => 'clear controller fabric fia loc $loc'
                 },
              
              'LC_Fabric_Fia_2port' => {
                 'cli'    => 'show control fabric fia stats loc $loc',
                 'regex'  => 'FIA-$args[0].*?'.
                             'To Line Interface.0.\s+(\d+).*?'.
                             'To Line Interface.1.\s+(\d+).*?'.
                             'From Line Interface.0.\s+(\d+).*?'.
                             'From Line Interface.1.\s+(\d+)',
                 'format' => '%18s: %d/%d',
                 'values' => ['Fabric FIA$args[0]','$1 + $2', '$3 + $4'],
                 'clear'  => 'clear controller fabric fia loc $loc'
                 },
               'NP_Fabric' => {
                 'cli'    => 'show controllers np fabric-counters all $args[0] loc $loc',
                 'regex'  => 'INTERLAKEN_TX_PACKETS\s+0x(\w+) (\w+).*?'.
                             'INTERLAKEN_RX_PACKETS\s+0x(\w+) (\w+)',
                 'format' => '%18s: %d/%d',
                 'values' => ['$args[0] Fab Port','hex($4)', 'hex($2)'],
                 'clear'  => 'clear controller np fabric-counters all all loc $loc',
                 },
               'NP_Counter_Fab' => {
                 'cli'    => 'show controllers np counter $args[0] loc $loc',
                 'regex'  => '(MDF_TX_FABRIC\s+(\d+).*?PARSE_FAB_RECEIVE_CNT\s+(\d+)'.
                             '|MDF_TX_FABRIC\s+(\d+)'.
                             '|PARSE_FAB_RECEIVE_CNT\s+(\d+))',
                 'format' => '%18s: %d/%d',
                 'values' => ['$args[0] Ucode Fab','$3 + $5', '$2 + $4'],
                 'clear'  => 'clear controller np counter $args[0] loc $loc',
                 },
               'NP_Counter_Wire' => {
                 'cli'    => 'show controllers np counter $NP loc $loc',
                 'regex'  => '(MDF_TX_WIRE\s+(\d+).*?PARSE_ENET_RECEIVE_CNT\s+(\d+)'.
                             '|MDF_TX_WIRE\s+(\d+)'.
                             '|PARSE_ENET_RECEIVE_CNT\s+(\d+))',

                 'format' => '%s: %d/%d',
                 'values' => ['$NP Ucode Wire','$3 + $5', '$2 + $4'],
                 'clear'  => 'clear controller np counter $NP loc $loc',
                 },
               'NP_Counter_LCPunt' => {
                 'cli'    => 'show controllers np counter $args[0] loc $loc',
                 'regex'  => '(MDF_TX_LC_CPU\s+(\d+).*?PARSE_INJ_RECEIVE_CNT\s+(\d+)'.
                             '|MDF_TX_LC_CPU\s+(\d+)'.
                             '|PARSE_INJ_RECEIVE_CNT\s+(\d+))',
                 'format' => '%18s: %d/%d',
                 'values' => ['$args[0] Ucode PuntInj','$2 + $4', '$3 + $5'],
                 'clear'  => 'clear controller np counter $args[0] loc $loc',
                 },
               'MAC_Counter' => {
                 'cli'    => 'show controller $args[0] $args[1] stats',
                 'regex'  => 'Input good pkts\s+= (\d+).*?'.
                             'Output good pkts\s+= (\d+)',
                 'format' => '%s: %d/%d',
                 'values' => ['$NP MAC Port','$1', '$2'],
                 'clear'  => 'clear controller $args[0] $args[1] stats',
                 },
               'LC_NP_Punt' => {
                 'cli'    => 'show controllers np punt-path-counters all HOST-SGMII-0 $args[0] loc $loc',
                 'regex'  => 'SGMII_T_FRM_CNT\s+0x(\w+) (\w+).*?'.
                             'SGMII_R_FRM_CNT\s+0x(\w+) (\w+)',
                 'format' => '%18s: %d/%d',
                 'values' => ['$args[0] port64','hex($2)', 'hex($4)'],
                 'clear'  => 'clear controller np punt-path-counters all HOST-SGMII-0 loc $loc',
                 },
               'Punt_Switch_NP' => {
                 'cli'    => 'show controllers punt-switch mac-stats $args[0] loc $loc',
                 'regex'  => 'Unicast Packets Rcv\s+= (\d+).*?'.
                             'Unicast Packets Sent\s+= (\d+)',
                 'format' => '%18s: %d/%d',
                 'values' => ['PuntSwitch port$args[0]','$1', '$2'],
                 'clear'  => 'show controllers punt-switch mac-stats $args[0] loc $loc',
                 },
               'Punt_Switch_CPU' => {
                 'cli'    => 'show controllers punt-switch mac-stats 24 loc $loc',
                 'regex'  => 'Unicast Packets Rcv\s+= (\d+).*?'.
                             'Unicast Packets Sent\s+= (\d+)',
                 'format' => '%18s: %d/%d',
                 'values' => ['PuntSwitch port24','$2', '$1'],
                 'clear'  => 'show controllers punt-switch mac-stats 24 loc $loc',
                 },

               # 'LC_SPP_Protocols'
               #
               # This is implemented in special handler function, get_spp_protocols()   
               #
              
               'LC_Netio_Protocols' => {
                   'cli'     => 'show netio clients location $args[0]',
                   'm_regex' => '(((\w+)\s+([HL]) (\d+)\/(\d+)\s+(\d+)\/(\d)\s+'.
                                '|(\w+)\s+(\d+)\/(\d+)\s+(\d+)\/(\d+)\s+'.
                                '| \s+([HL]) (\d+)\/(\d+)).*)',
                   'format'  => '%21s: %d/%d',
                   'values'  => ['$3$9 $4$14', '($6 + $11 + $16)', '($8 + $13)'] ,
                   'clear'   => 'clear netio client statistics location $args[0]',
               },
             );

our $interface = $ARGV[0];

if ($interface =~ /(\w*)(Gig.*?E.*?)(\d+)_(\d+)_(\d+)_(\d+)/) {
    our $int_type = $1 . $2;
    our $int_display = $1 . "GigE";
    our $int_location = "$3/$4/$5/$6";
} else {
    die "Interface $interface not valid format - internal CLI problem\n";
}

our $loc = get_dataplane_object_instance($interface, "", "LOC");  # Location string
our $LC  = get_dataplane_object_instance($interface, "", "LC");   # LC string
our $np  = get_dataplane_object_instance($interface, "", "NP");   # NP number
our $NP  = 'NP' . $np;                                            # NP string
our $fia = get_dataplane_object_instance($interface, "", "FIA");  # FIA number
our $FIA = 'FIA' . $fia;
our $fia_for_np0 = get_dataplane_object_instance($loc, "NP0", "FIA");   # the FIA that NP0 connects to
our @np_fia_ports = get_dataplane_object_instance($loc, $NP, "PORT_IN");  # the FIA ports to/from the NP
our @np0_fia_ports = get_dataplane_object_instance($loc, "NP0", "PORT_IN"); 
our @np_punt_port_array = get_dataplane_object_instance($loc, $NP, "PUNT_PORT"); # the punt port for the np
our $np_punt_port = $np_punt_port_array[0];

our $fields_ref = \%my_fields;

$DEBUG = 0;
$DEBUG = 'all' if ( grep (/-debug$/, @ARGV));
my $last= '';
foreach (@ARGV){
    $DEBUG = $_ if ($last =~ /^-debug$/);
    $last = $_;
}

$ANNOTATE = 0;
$ANNOTATE = 1 if ( grep (/-annotate$/, @ARGV));
my %cleared;
$CLEAR = 1 if ( grep (/-clear$/, @ARGV));

init_global_fields($fields_ref);
set_sysmgr_pid();
display();

sub display {
    print"-------------------------------------------------------------------------------\n";
    printf("$FIELD_____________________FIELD       $FIELD_____________________FIELD\n",
           sprintf("%18s: Protocols","RSP0"),
           sprintf("%18s: Protocols","RSP1"));
    print"              ----------------                       ---------------\n";
    my $rsp0_output = &field('RSP_Netio_Protocols', '0/RSP0/CPU0');
    my $rsp1_output = &field('RSP_Netio_Protocols', '0/RSP1/CPU0');
    my $rsp0_protocol_name = "";
    my $rsp1_protocol_name = "";
    while($rsp0_output || $rsp1_output) {
        #
        # If debug set and not this entry, SKIP
        #
        if (($rsp0_output =~ /SKIP/) || ($rsp1_output =~ /SKIP/)) {
            printf("$FIELD_____________________FIELD      $FIELD_____________________FIELD\n",
                   $rsp0_output, $rsp1_output);
            last;
        }

        #
        # If cleared, print the cleared message and move on
        #
        if (($rsp0_output =~ /Clear/) || ($rsp1_output =~ /Clear/)) {
            printf("$FIELD_____________________FIELD      $FIELD_____________________FIELD\n",
                   $rsp0_output, $rsp1_output);
            last;
        }
        
        #
        # If either RSP has a non zero good to or from count, print the line
        # If a high priority count is non zero, print it with the protocol named stored
        my $rsp0_to = 0;
        my $rsp0_from = 0;
        my $rsp1_to = 0;
        my $rsp1_from = 0;
        
        if ($rsp0_output =~ /(\d+)\/(\d+)/) {
            $rsp0_to = $1;
            $rsp0_from = $2;
        }
        
        if ($rsp1_output =~ /(\d+)\/(\d+)/) {
            $rsp1_to = $1;
            $rsp1_from = $2;
        }

        # if low count, save protocol name
        if ($rsp0_output =~ /(\w+)\s+L\s/) {
            $rsp0_protocol_name = $1;
        }
        if ($rsp1_output =~ /(\w+)\s+L\s/) {
            $rsp1_protocol_name = $1;
        }
        
        if ($rsp0_to || $rsp0_from || $rsp1_to || $rsp1_from) {
            if ($rsp0_output =~ /(\w+)\s+H\s/) {
                $rsp0_output = $rsp0_protocol_name . $rsp0_output;
            }
            if ($rsp1_output =~ /(\w+)\s+H\s/) {
                $rsp1_output = $rsp1_protocol_name . $rsp1_output;
            }
            printf("   $FIELD_____________________FIELD      $FIELD_____________________FIELD\n",
               $rsp0_output, $rsp1_output);
        }
        $rsp0_output = &field('RSP_Netio_Protocols', '0/RSP0/CPU0');
        $rsp1_output = &field('RSP_Netio_Protocols', '0/RSP1/CPU0');
    }

    my $rsp0_spp_protocols = &get_spp_protocols('RSP_SPP_Protocols', '0/RSP0/CPU0');
    my $rsp1_spp_protocols = &get_spp_protocols('RSP_SPP_Protocols', '0/RSP1/CPU0');
    my @rsp0_spp_lines = split(/\n/, $rsp0_spp_protocols);
    my @rsp1_spp_lines = split(/\n/, $rsp1_spp_protocols);
    my $max_protocols = (@rsp0_spp_lines >= @rsp1_spp_lines) ? @rsp0_spp_lines : @rsp1_spp_lines;

    for ($i = 0; $i < $max_protocols; $i++) {
        # Add blank array elements if one is shorter than the other

        if (@rsp0_spp_lines < $i) {
            $rsp0_spp_lines[$i] = "";
        }
        if (@rsp1_spp_lines < $i) {
            $rsp1_spp_lines[$i] = "";
        }
        printf("$FIELD_____________________FIELD            $FIELD_____________________FIELD\n",
               $rsp0_spp_lines[$i], $rsp1_spp_lines[$i]);
    }
    
    print"\n";
    printf("$FIELD_____________________FIELD       $FIELD_____________________FIELD\n",
           sprintf("%18s: inj/punt","RSP0"),
           sprintf("%18s: inj/punt","RSP1"));
    print"              --------------                         --------------\n";
    printf("     $FIELD_____________________FIELD       $FIELD_____________________FIELD\n",
           &field('SPP_port','0/RSP0/CPU0'),
           &field('SPP_port','0/RSP1/CPU0'));
    printf("     $FIELD_____________________FIELD       $FIELD_____________________FIELD\n",
           &field('RSP_Punt_FPGA','0/RSP0/CPU0'),
           &field('RSP_Punt_FPGA','0/RSP1/CPU0'));
    printf("     $FIELD_____________________FIELD       $FIELD_____________________FIELD\n",
           &field('RSP_Fabric_Fia','0/RSP0/CPU0'),
           &field('RSP_Fabric_Fia','0/RSP1/CPU0'));
    print "\n";
    printf("$FIELD_______FIELD $FIELD_____________________FIELD\n",
           "", "Dataplane for $LC");


    if ($np == 0) {
        printf("$FIELD_______FIELD --------------------------\n", "");
        if ($np_fia_ports == 1) {
            printf("             $FIELD_____________________FIELD %s            \n",
                   &field('LC_Fabric_Fia_1port', $fia, $np_fia_ports[0]));
        } else {
            printf("             $FIELD_____________________FIELD %s            \n",
                   &field('LC_Fabric_Fia_2port', $fia));
        }
        printf("             $FIELD_____________________FIELD\n",
               &field('NP_Fabric',$NP));
        printf("             $FIELD_____________________FIELD\n",
               &field('NP_Counter_Fab', $NP));
        print  " Interface                         |\n";
        printf(" $FIELD_______FIELD ing/egr        |\n",
               $int_display . $int_location);
        printf(" --------------------------------[$NP]\n");
        printf(" $FIELD_________________FIELD      |\n",
               &field("NP_Counter_Wire"));
        printf(" $FIELD_________________FIELD      |\n",
               &field('MAC_Counter', $int_type, $int_location));
        printf("$FIELD______________________FIELD $FIELD_________________FIELD\n",
               "", "punt/inj");
        printf("$FIELD_______FIELD --------------------------\n", "");
        printf("             $FIELD_____________________FIELD\n",
               &field('NP_Counter_LCPunt', $NP));
        printf("             $FIELD_____________________FIELD\n",
               &field('LC_NP_Punt',$NP));
        printf("             $FIELD_____________________FIELD\n",
               &field('Punt_Switch_NP', $np_punt_port));
    } else {
        printf("$FIELD_______FIELD --------------------------------------------------------\n", "");

        if ($np_fia_ports == 1) {
            printf("             $FIELD_____________________FIELD %s            \n",
                   &field('LC_Fabric_Fia_1port', $fia, $np_fia_ports[0]),
                   &strip_punt_counters(&field('LC_Fabric_Fia_1port', $fia_for_np0, $np0_fia_ports[0])));
        } else {
            printf("             $FIELD_____________________FIELD %s            \n",
                   &field('LC_Fabric_Fia_2port', $fia),
                   &strip_punt_counters(&field('LC_Fabric_Fia_2port', $fia_for_np0)));
        }
        
        printf("             $FIELD_____________________FIELD %s         \n",
               &field('NP_Fabric',$NP),
               &strip_punt_counters(&field('NP_Fabric','NP0')));
        printf("             $FIELD_____________________FIELD %s        \n",
               &field('NP_Counter_Fab', $NP),
               &strip_punt_counters(&field('NP_Counter_Fab', 'NP0')));
        print  " Interface                         |                           ^ \n";
        printf(" $FIELD_______FIELD ing/egr        |                           |  \n",
               $int_display . $int_location);
        printf(" --------------------------------[$NP]                       [NP0]\n");
        printf(" $FIELD_________________FIELD      |                           |\n",
               &field("NP_Counter_Wire"));
        printf(" $FIELD_________________FIELD      |                           ^  \n",
               &field('MAC_Counter', $int_type, $int_location));
        printf("$FIELD____________________FIELD $FIELD___________________FIELD $FIELD_______________FIELD\n",
               "", "punt/inj","|   inj");
        printf("$FIELD_______FIELD --------------------------------------------------------\n", "");
        printf("          $FIELD_____________________FIELD   %s        \n",
               &field('NP_Counter_LCPunt', $NP), &strip_punt_counters(&field('NP_Counter_LCPunt', 'NP0')));
        printf("          $FIELD_____________________FIELD   %s        \n",
               &field('LC_NP_Punt',$NP), &strip_punt_counters(&field('LC_NP_Punt','NP0')));
        printf("          $FIELD_____________________FIELD   %s        \n",
               &field('Punt_Switch_NP', $np_punt_port), &strip_punt_counters(&field('Punt_Switch_NP',0)));
        printf("%70s\n", "---> Optional inject path");
    }

    print "\n";
    printf("$FIELD_____________________FIELD\n",
           sprintf("%18s: punt/inj","$LC CPU"));
    print"           -----------------\n";
    printf("             $FIELD_____________________FIELD             \n",
           &field('Punt_Switch_CPU'));
    printf("             $FIELD_____________________FIELD             \n",
           &field('SPP_port', $loc));
    print "\n";
    printf("$FIELD_____________________FIELD\n",
           sprintf("%18s: Protocols","$LC CPU"));
    print"           -----------------\n";
    my $lc_output = &field('LC_Netio_Protocols', $loc);
    while($lc_output) {
        #
        # If debug set and not this entry, SKIP
        #
        if ($lc_output =~ /SKIP/) {
            printf("$FIELD_____________________FIELD\n", $lc_output);
            last;
        }

        #
        # If cleared, print the cleared message and move on
        #
        if ($lc_output =~ /Clear/) {
            printf("$FIELD_____________________FIELD\n", $lc_output);
            last;
        }
        
        #
        # If there is a non zero good to or from count, print the line
        #
        my $to = 0;
        my $from = 0;

        $lc_output =~ /(\d+)\/(\d+)/;
        $to = $1;
        $from = $2;
        
        if ($to || $from) {
            printf("$FIELD_____________________FIELD\n", $lc_output);
        }

        $lc_output = &field('LC_Netio_Protocols', $loc);
    }

    my $lc_spp_protocols = get_spp_protocols('LC_SPP_Protocols', $loc);
    print $lc_spp_protocols;
    
    print "\n";
    print"-------------------------------------------------------------------------------\n";
}

sub strip_punt_counters {
    my $string = shift;
    $string =~ s/: \d+\//: /;
    return $string;
}

sub get_spp_protocols {
    my $entry = shift;
    return "SKIP $entry" if (($DEBUG) && $DEBUG ne $entry);
    my @args = @_;

    if ($CLEAR) {
        return sprintf("%18s: Not Clearable", $entry);
    }

    my $cli = "show spp sid stats location $args[0]";
    my $display_cli = $cli;
    $cli =~ s/ /%20/g;   # Add the percent twenty '%20' for showtech_helper
    my $cli_output = `showtech_helper $cli`;

    my $counter_type_regex = "(\\w+) per-SID stats";
    my $values_regex       = "(\\d+).*?(\\w+)\\s+(\\d+)";

    if (($DEBUG eq 'all') || ($DEBUG eq $entry)){
        if ($cli_output =~ /^\s*$/){
            print "DEBUG: -------------------------------------\n";
            print "DEBUG:  ERR: Null CLI output '', from '$cli'\n";
            print "DEBUG:      field_cli=$field_cli\n";
            print "DEBUG:      final_cli=$field_cli\n";
            print "DEBUG:-------------------------------------\n";
        }else{
            my $debug_cli_output = $cli_output;
            $debug_cli_output =~ s/^/CLI:/mg;
            print  $debug_cli_output;
        }
        print  "\n";
        printf  "DEBUG: ======================================================\n";
        printf("DEBUG: %25s = {\n", $entry);
        print  "DEBUG:         'cli'    => '" . $cli .    "',\n";
        print  "DEBUG:         'counter_type_regex'  => '" . $counter_type_regex .  "',\n";
        print  "DEBUG:         'values_regex'  => '" . $values_regex .  "',\n"; 
        print  "DEBUG:        };\n";
        print  "DEBUG: ======================================================\n";
    }
    
    my @cliLines = split(/\n/, $cli_output);
    my %punt_count = ();
    my %inject_count = ();
    my %protocols = ();
    my $counter_type = "NONE";
    
    foreach my $line (@cliLines) {
        if ($line =~ /$counter_type_regex/) {
            $counter_type = $1;
            if ($DEBUG) {
                print "DEBUG: Counter Type: $counter_type\n";
            }
        }

        if ($line =~ /$values_regex/) {
            my $sid = $1;
            my $protocol = $2;
            my $count = $3;
            $protocols{$protocol} = $sid;

            if ($DEBUG) {
                print "DEBUG: SID ($sid)  Protocol ($protocol)  Count ($count)\n";
            }
            
            if ($counter_type eq "Punted") {
                $punt_count{$protocol} = $count;
            } elsif ($counter_type eq "Inject") {
                $inject_count{$protocol} = $count;
            } else {
                print "Internal CLI error :: Unknown SPP counter type ($counter_type)\n";
            }
        }
    }

    my $return_string = "";
    
    foreach $key (keys %protocols) {
        my $line = "";
        my $punt = 0;
        my $inject = 0;

        if (exists $punt_count{$key}) {
            $punt = $punt_count{$key}
        }

        if (exists $inject_count{$key}) {
            $inject = $inject_count{$key}
        }
        
        $line = sprintf("%21s: %d/%d\n", "$key (SID $protocols{$key})", $punt, $inject);
        $return_string = $return_string . $line;
    }

    #
    # ANNOTATE support simply prints a few lines of info before returning
    #  
    if ($ANNOTATE){
        printf("%80s| $display_cli\n", "", $display_cli);
    }

    return $return_string;
}
