# $Id: $
#* $Source: $
#*------------------------------------------------------------------
#* aaa_user_sync_from_xr_to_lxc.sh - Responsible for sycing user
#*
#* Oct 2015, Monal Sengar
#*
#* Copyright (c) 2003-2016 by Cisco Systems, Inc.
#* All rights reserved.
#*------------------------------------------------------------------
#* $Log: $
#*------------------------------------------------------------------
#* $Endlog$
#*/

#!/bin/bash


if [ $# -gt 0 ]; then
   echo "'$(date)' $# arguemnts are passed to script" >> '/disk0:/status_file'
else 
   echo "'$(date)' No arugments passed" >> '/disk0:/status_file'
fi

username=$1
configtype=$2
action=$3
password="${4}"
group=$5
declare -a predef_group=("cisco-support" "netadmin" "sysadmin" "serviceadmin" "operator")
echo "'$(date)' Username is $username" >> '/disk0:/status_file'
echo "'$(date)' Group is $group" >> '/disk0:/status_file'
echo "'$(date)' configtype is $configtype" >> '/disk0:/status_file'
echo "'$(date)' action is $action" >> '/disk0:/status_file'

is_predef=0

# Check if user exists then modify the user
if [ "$2" == "USERNAME" ] 
then
    if [ "$3" == "CREATE" ] 
    then
       if id -g $username >/dev/null 2>&1
       then
           echo "'$(date)' User $1 exists" >> '/disk0:/status_file'
           retval="$?"
           if [ $retval == 0 ]
           then
              echo "'$(date)' useradd $username $retval" >> '/disk0:/status_file'
           else 
              echo "'$(date)' useradd $username $retval" >> '/disk0:/status_file'
           fi
       else
           useradd -m $1
           retval="$?"
           [ $retval -eq 0 ] && echo "User has been added"  >> '/disk0:/status_file' || echo "Failed to add a user" >> '/disk0:/status_file'
           if [ $retval == 0 ]
           then
              echo "'$(date)' User added successfully" >> '/disk0:/status_file'
              echo "'$(date)' useradd $username $retval" >> '/disk0:/status_file'
           else 
              echo "'$(date)' useradd $username $retval" >> '/disk0:/status_file'
           fi
       fi
    else
       userdel -f -r $1
       retval="$?"
       echo "'$(date)' userdel $username $retval" >> '/disk0:/status_file'
    fi

elif [ "$2" == "GROUP" ] 
then
     if [ "$3" == "CREATE" ] 
     then
        if id -g $username >/dev/null 2>&1
        then
            echo "'$(date)' User $username exists" >> '/disk0:/status_file'
            if [ "$group" != "sudo" ] && [[ "$group" != *['!'@#\$%^\&*()+]* ]]
            then
                usermod -a -G $group $username  
                retval="$?"
                echo "'$(date)' usermod group $group $username $retval" >> '/disk0:/status_file'
                if [ "$group" == "root-lr" ]
                then
                    # This script can get run multiple times per user so avoid
                    # adding sudo if it already exists.
                    grep -q '^\s*%sudo' /etc/sudoers
                    if [[ $? -ne 0 ]]; then
                        echo "'$(date)' adding sudo group" >> '/disk0:/status_file'
                        echo "%sudo ALL=(ALL) ALL" >> '/etc/sudoers'
                    fi
                    usermod -a -G sudo $1
                    retval="$?"
                    echo "'$(date)' usermod group sudo $username $retval" >> '/disk0:/status_file'
                 fi
            fi
        fi
     else
        echo "'$(date)' Delete user group $group" >> '/disk0:/status_file'
        gpasswd -d $username $group
        retval="$?"
        echo "'$(date)' deluser group $group $username $retval" >> '/disk0:/status_file'
     fi

elif [ "$2" == "PASSWORD" ]
then
     if [ "$3" == "CREATE" ]
     then
        if id -g $username >/dev/null 2>&1
        then
           echo "'$(date)' User $username exists" >> '/disk0:/status_file'
           echo $username:$password | chpasswd 
           retval="$?"
           echo "'$(date)' usermod passwd $username $retval" >> '/disk0:/status_file'
        fi
     else
        echo "'$(date)' Delete password" >> '/disk0:/status_file'
        passwd -l $username
        retval="$?"
        echo "'$(date)' delete passwd $username $retval" >> '/disk0:/status_file'
     fi 

elif [ "$2" == "SECRET" ]
then
     if [ "$3" == "CREATE" ]
     then
        if id -g $username >/dev/null 2>&1
        then
           echo "'$(date)' User $username exists" >> '/disk0:/status_file'
           echo $username:$password | chpasswd -e 
           retval="$?"
           echo "'$(date)' usermod secret $username $retval" >> '/disk0:/status_file'
        fi
     else
        echo "'$(date)' Delete secret" >> '/disk0:/status_file'
        passwd -l $username
        retval="$?"
        echo "'$(date)' delete secret $username $retval" >> '/disk0:/status_file'
     fi

fi

linecount=$(wc -l < /disk0:/status_file)

if [ $linecount -gt 50 ]
then
   rm '/disk0:/status_file'
   touch '/disk0:/status_file'
fi


