#!/bin/bash
#
# Copyright (c) 2016 by Cisco Systems, Inc.
#
# LXC hooks event handling
#
# Neil McGill
#

#
# lxc_app_hosting_hook
#
# Called on start/stop/... lxc events
#

# Please DO NOT add any command that blocks for too long

function lxc_app_hosting_hook()
{
    local vm_name=$1
    local vm_op=$2
    local vm_subop=$3
    local vm_initpid=$4
    local ret_code=0

    declare -F app_host_is_enabled &>/dev/null && app_host_is_enabled
    if [[ $? -ne 0 ]]; then
        return
    fi

    declare -F platform_log &>/dev/null &&
    platform_log "Handle app hosting LXC event for vm:$vm_name op:$vm_op board:$BOARDTYPE vm:$VMTYPE"

    case "$vm_op" in
    stopped)
        stop_services=false

        case "$vm_name" in
        sysadmin)
            stop_services=true
            ;;
            
        default-sdr--*) 
            declare -F app_host_is_enabled &>/dev/null && app_host_is_enabled "$vm_name"
            if [[ $? -eq 0 ]]; then
                stop_services=true
            else
                stop_services=false
            fi
            ;;
        *)
            # Nothing to do
            ;;
        esac

        if [[ $stop_services == true ]]; then
            #
            # Check if docker daemon holds any mounts corresponding to the 
            # lxc being shutdown
            #
            declare -F app_hosting_docker_daemon_cleanup_bind_mounts &>/dev/null &&
            app_hosting_docker_daemon_cleanup_bind_mounts "$vm_name" 
            if [[ $? -ne 0 ]]; then
                #
                # If the docker daemon's mount namespace has any of the mounts
                # corresponding to the lxc being shutdown, stop the docker 
                # daemon
                #
                declare -F platform_log &>/dev/null &&
                platform_log "App hosting LXC event: stop docker"
                
                #
                # initctl stop docker blocks for upto 10 secs
                # Starting initctl stop docker in the background
                #
                killall -qe docker &>/dev/null
                (initctl stop docker &>/dev/null) &
                disown $!
            fi
       fi
        ;;

    *)
        #Nothing to do
        ;;
    esac

    return $ret_code
}
