source /etc/init.d/spirit_pd.sh

BOARD_TYPE_BP_4_SLOT=0xef02f6
BOARD_TYPE_BP_6_SLOT=0xef02ff
BOARD_TYPE_BP_ENG_6_SLOT=0xef02fb
BOARD_TYPE_BP_29_SLOT=0xef02f8
BOARD_TYPE_BP_19_SLOT=0xef02f7
BOARD_TYPE_BP_10_SLOT=0xef02fe
BOARD_TYPE_BP_15_SLOT=0xef02f5
BOARD_TYPE_BP_11_SLOT=0xef02f4

function rsp_logical_to_physical
{
     local chassis_type=$1
     local lslot=$2
     local pslot

     case  ${chassis_type} in

     ${BOARD_TYPE_BP_4_SLOT})
     pslot=`expr $(($lslot)) + 1`
     ;;

     ${BOARD_TYPE_BP_6_SLOT})
     pslot=${lslot}
     ;;

     ${BOARD_TYPE_BP_ENG_6_SLOT})
     pslot=${lslot}
     ;;

     ${BOARD_TYPE_BP_29_SLOT})
     pslot=${lslot}
     ;;

     ${BOARD_TYPE_BP_19_SLOT})
     pslot=${lslot}
     ;;

     ${BOARD_TYPE_BP_10_SLOT})
     pslot=`expr $(($lslot)) + 4`
     ;;

     ${BOARD_TYPE_BP_15_SLOT})
     pslot=${lslot}
     ;;

     ${BOARD_TYPE_BP_11_SLOT})
     pslot=${lslot}
     ;;

     *)
     pslot=`expr $(($lslot)) + 4`
     ;;

     esac

     echo  ${pslot}
}

function lc_logical_to_physical
{
     local chassis_type=$1
     local lslot=$2
     local pslot

     case  ${chassis_type} in

     ${BOARD_TYPE_BP_4_SLOT})
     if [ ${lslot} -gt 1 ]; then
        return
     fi
     if [ ${lslot} -gt 0 ]; then
        pslot=`expr $(($lslot)) + 2`
     else
        pslot=${lslot}
     fi
     ;;

     ${BOARD_TYPE_BP_6_SLOT})
     if [ ${lslot} -gt 3 ]; then
        return
     fi
     pslot=`expr $(($lslot)) + 2`
     ;;

     ${BOARD_TYPE_BP_ENG_6_SLOT})
     if [ ${lslot} -gt 3 ]; then
        return
     fi
     pslot=`expr $(($lslot)) + 2`
     ;;

     ${BOARD_TYPE_BP_29_SLOT})
     if [ ${lslot} -gt 19 ]; then
        return
     fi
     pslot=`expr $(($lslot)) + 2`
     ;;

     ${BOARD_TYPE_BP_19_SLOT})
     if [ ${lslot} -gt 9 ]; then
        return
     fi
     pslot=`expr $(($lslot)) + 2`
     ;;

     ${BOARD_TYPE_BP_15_SLOT})
     if [ ${lslot} -gt 7 ]; then
        return
     fi
     pslot=`expr $(($lslot)) + 2`
     ;;

     ${BOARD_TYPE_BP_11_SLOT})
     if [ ${lslot} -gt 7 ]; then
        return
     fi
     pslot=`expr $(($lslot)) + 2`
     ;;

     ${BOARD_TYPE_BP_10_SLOT})
     if [ ${lslot} -gt 7 ]; then
        return
     fi
     if [ ${lslot} -gt 3 ]; then
        pslot=`expr $(($lslot)) + 2`
     else
        pslot=${lslot}
     fi
     ;;

     *)
     if [ ${lslot} -gt 7 ]; then
        return
     fi
     if [ ${lslot} -gt 3 ]; then
        pslot=`expr $(($lslot)) + 2`
     else
        pslot=${lslot}
     fi
     ;;

     esac

     echo  ${pslot}
}

HOST_FILE=
FSTAB_FILE=
LXC_ROOTDIR=
function remove_entries
{
    sed -i -e "/^192.0/,\$d" ${HOST_FILE}
}

function update_locals
{
    if [[ $VIRT_METHOD == "lxc" ]]; then
        echo 10.0.2.16 my_host >> ${HOST_FILE}
        echo 10.11.12.14 my_xr >> ${HOST_FILE}
        echo 10.11.12.15 my_admin >> ${HOST_FILE}
    else
        echo 10.0.2.2 my_host >> ${HOST_FILE}
        echo 10.0.2.15 my_admin >> ${HOST_FILE}
    fi
}

function update_entry
{
    local ipc
    local lname=$1
    local pslot=$2
    local ipd1=$3
    local ipd2=$4
    let "ipc = ${pslot} * 4"

    echo 192.0.${ipc}.1 ${lname}_admin >> ${HOST_FILE}
    echo 192.0.${ipc}.${ipd1} ${lname}_xr >> ${HOST_FILE}
    echo 192.0.${ipc}.${ipd2} ${lname}_xr2 >> ${HOST_FILE}
    echo 192.0.${ipc}.100 ${lname}_ipu >> ${HOST_FILE}
    echo 192.0.${ipc}.110 ${lname}_host >> ${HOST_FILE}
}

function update_fstab
{
    local dir=$1
    local lslot=$2
    local lxc_name=$3

    local host_name=lc${lslot}_${lxc_name}
    local mnt_path=${dir}lc/${host_name}
    local rem_path=${host_name}:${dir}

    mkdir -p ${LXC_ROOTDIR}/${mnt_path}
    sed -i "/${host_name}/d" ${FSTAB_FILE}
    echo "sshfs#root@${rem_path} ${mnt_path}   fuse comment=sshfs,noauto,reconnect,transform_symlinks,BatchMode=yes 0 0" >> ${FSTAB_FILE}
}

function update_rsp_entry
{
    local chassis_type=$1
    local lslot=$2
    local pslot=$( rsp_logical_to_physical ${chassis_type} ${lslot} )

    update_entry "rsp${lslot}" ${pslot} "4" "6"
    update_entry "rp${lslot}" ${pslot} "4" "6"
}

function update_lc_entry
{
    local chassis_type=$1
    local lslot=$2
    local lxc_name=$3
    local pslot=$( lc_logical_to_physical ${chassis_type} ${lslot} )

    if [ -z "${pslot}" ]; then
         return 1
    fi

    update_entry "lc${lslot}" ${pslot} "3" "4"
    # RP's remote access to LC f/s
    if [[ "${BOARDTYPE}" == "RP" ]]; then
        update_fstab /misc/scratch ${lslot} ${lxc_name}
        # if xr, provide xr2 fstab as well
        if [[ "${lxc_name}" == "xr" ]]; then
            update_fstab /misc/scratch ${lslot} ${lxc_name}2
        fi
    fi
    return 0
}

function update_hosts
{
    remove_entries

    local chassis_type=$1
    local lxc_name=$2
    if [ -z ${chassis_type} ]; then
        return
    fi

    update_locals
    update_rsp_entry ${chassis_type} 0
    update_rsp_entry ${chassis_type} 1
    local lslot=0
    update_lc_entry ${chassis_type} ${lslot} ${lxc_name}
    until [ $? -ne 0 ]; do
        let "lslot = ${lslot} + 1"
        update_lc_entry ${chassis_type} ${lslot} ${lxc_name}
    done

    return 0
}

LXC_ROOTDIR=$1
HOST_FILE=${LXC_ROOTDIR}/etc/hosts
FSTAB_FILE=${LXC_ROOTDIR}/etc/fstab
LXC_NAME=$2
if [[ "${BOARDTYPE}" == "LC" ]]; then
    get_chassis_details_cmd
    update_hosts ${CMD_CHASSIS_TYPE} ${LXC_NAME}
else
    get_chassis_details_ipu
    update_hosts ${CHASSIS_TYPE} ${LXC_NAME}
fi

