#!/bin/bash
#
# This script provides IPU/EMT variables
#
# Copyright (c) 2014-2015 by Cisco Systems, Inc.
# All rights reserved.

PD_FUNCS="/etc/init.d/pd-functions"
source $PD_FUNCS

# IPU INFO_ROM offsets
INFO_ROM_CT_OFF=0xc0
INFO_ROM_NV_OFF=0xE8

# EMT Emulation structure offsets
# Refer libasr9kpd:emt.c
EMT_MODE_OFF=0x20
EMT_MAGIC_OFF=0x24
PSLOT_OFF=0x34
PD_CARDTYPE_OFF=0x3C
CHASSIS_TYPE_OFF=0x48
PI_CARDTYPE_OFF=0x6C
CHASSIS_SERIAL_OFF=0x70
CHASSIS_PID_OFF=0x90
CARD_SERIAL_OFF=0xB0
CARD_PID_OFF=0xD0
MAC_UPD_OFF=0x57C
MAC_BASE_LO_OFF=0x570
MAC_BASE_HI_OFF=0x574

IPU_BASE=$(get_ipu_base_safe)
NVRAM_4B_OFF=0x100000
INFO_ROM_NV_ADDR=$(( $IPU_BASE + $INFO_ROM_NV_OFF ))
INFO_ROM_NV_VAL=$( pcimemread `printf "%x" $INFO_ROM_NV_ADDR` 0x4 | grep -v PCI | awk '{ print $3 ; }' | sed -e 's/^0/0x0/' )
NVRAM_OFF=$(( $INFO_ROM_NV_VAL + $NVRAM_4B_OFF ))

HW_CARDTYPE_ADDR=$(($IPU_BASE + $INFO_ROM_CT_OFF))
HW_CARDTYPE=$( pcimemread `printf "%x" $HW_CARDTYPE_ADDR` 0x4 | grep -v PCI | awk '{ print $3 ; }' | sed -e 's/^/0x/' )

if (( $HW_CARDTYPE & 0x20 )) ; then EMT_OFF=0x7F000; else EMT_OFF=0x1F000; fi

EMT_MAGIC_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $EMT_MAGIC_OFF))
EMT_MAGIC=$( pcimemread `printf "%x" $EMT_MAGIC_PADDR` 0x10 | grep -v PCI | awk '{ print $3 ; }' | sed -e 's/^000000/0x/' )

if [ "$EMT_MAGIC" == "12345678" ]; then
	PSLOT_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $PSLOT_OFF))
	PSLOT=$( pcimemread `printf "%x" $PSLOT_PADDR` 0x10 | grep -v PCI | awk '{ print $3 ; }' | sed -e 's/^000000/0x/' )

	PD_CARDTYPE_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $PD_CARDTYPE_OFF))
	PD_CARDTYPE=$( pcimemread `printf "%x" $PD_CARDTYPE_PADDR` 0x10 | grep -v PCI | awk '{ print $3 ; }' | sed -e 's/^00/0x/' )

	PI_CARDTYPE_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $PI_CARDTYPE_OFF))
	PI_CARDTYPE=$( pcimemread `printf "%x" $PI_CARDTYPE_PADDR` 0x10 | grep -v PCI | awk '{ print $3 ; }' | sed -e 's/^0000000//' )

	CARD_SERIAL_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $CARD_SERIAL_OFF))
	CARD_SERIAL=$( pcimemread `printf "%x" $CARD_SERIAL_PADDR` 0x10 | grep -v PCI | awk '{ print $7 ; }' | tr -d "." )

	CARD_PID_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $CARD_PID_OFF))
	CARD_PID=$( pcimemread `printf "%x" $CARD_PID_PADDR` 0x10 | grep -v PCI | awk '{ print $7 ; }' | tr -d "." )

	CHASSIS_TYPE_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $CHASSIS_TYPE_OFF))
	CHASSIS_TYPE=$( pcimemread `printf "%x" $CHASSIS_TYPE_PADDR` 0x4 | grep -v PCI | awk '{ print $3 ; }' | sed -e 's/00ef/0xef/' )

	CHASSIS_SERIAL_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $CHASSIS_SERIAL_OFF))
	CHASSIS_SERIAL=$( pcimemread `printf "%x" $CHASSIS_SERIAL_PADDR` 0x10 | grep -v PCI | awk '{ print $7 ; }' | tr -d "." )

	CHASSIS_PID_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $CHASSIS_PID_OFF))
	CHASSIS_PID=$( pcimemread `printf "%x" $CHASSIS_PID_PADDR` 0x10 | grep -v PCI | awk '{ print $7 ; }' | tr -d "." )

	EMT_MODE_PADDR=$(($IPU_BASE + $NVRAM_OFF + $EMT_OFF + $EMT_MODE_OFF))
	EMT_MODE=$( pcimemread `printf "%x" $EMT_MODE_PADDR` 0x10 | grep -v PCI | awk '{ print $3 ; }' | sed -e 's/^000000/0x/' )
else
	echo Unexpected IPU EMT Magic $EMT_MAGIC
	echo IPU_BASE = $IPU_BASE
	echo HW_CARDTYPE = $HW_CARDTYPE
	echo EMT MAGIC PADDR = $EMT_MAGIC_PADDR
	pcimemread `printf "%x" $EMT_MAGIC_PADDR` 0x40
fi


PROC_CMDLINE=$(cat /proc/cmdline)
for x in ${PROC_CMDLINE} ; do
    case "$x" in
        boardtype=*)
        CMD_BOARDTYPE="${x#boardtype=}"
        ;;
        platform=*)
        CMD_PLATFORM="${x#platform=}"
        ;;
        chassis_serial=*)
        CMD_CHASSIS_SERIAL="${x#chassis_serial=}"
        ;;
        chassis_type=*)
        CMD_CHASSIS_TYPE="${x#chassis_type=}"
        ;;
        chassis_pid=*)
        CMD_CHASSIS_PID="${x#chassis_pid=}"
        ;;
    esac
done

if [[ "$EMT_DEBUG" == "YES" ]] ; then
    if (( $HW_CARDTYPE & 0x20 )) ; then echo boardtype=RP; else echo boardtype=LC; fi
    echo emt_magic=$EMT_MAGIC
    echo emt_mode=$EMT_MODE
    echo hw_cardtype=$HW_CARDTYPE
    echo pslot=$PSLOT
    echo pd_cardtype=$PD_CARDTYPE
    echo pi_cardtype=$PI_CARDTYPE
    echo card_serial=$CARD_SERIAL
    echo card_pid=$CARD_PID
    echo chassis_type=$CHASSIS_TYPE
    echo chassis_serial=$CHASSIS_SERIAL
    echo chassis_pid=$CHASSIS_PID
    echo cmd_platform=$CMD_PLATFORM
    echo cmd_boardtype=$CMD_BOARDTYPE
    echo cmd_chassis_serial=$CMD_CHASSIS_SERIAL
    echo cmd_chassis_type=$CMD_CHASSIS_TYPE
    echo cmd_chassis_pid=$CMD_CHASSIS_PID
fi
