#!/bin/bash
#
# calvados/asr9k_pkg/boot/scripts/rp_resync.sh
# This script allows RSP to resync it's grub and 
# command line arguments if it has been moved
# across chassis.
#
# Copyright (c) 2014-2017 by Cisco Systems, Inc.
# All rights reserved.

function rp_cmdline_resync()
{
    local VM_TYPE=$1
    
    get_chassis_details_ipu
    get_chassis_details_cmd

    umount /proc/cmdline
    local PROC_CMDLINE=/root/cmdline

    if [ $CMD_CHASSIS_SERIAL != $CHASSIS_SERIAL ]; then
        sed -i -e"s;chassis_serial=$CMD_CHASSIS_SERIAL;chassis_serial=$CHASSIS_SERIAL;" ${PROC_CMDLINE}
    fi

    if [ $CMD_CHASSIS_TYPE != $CHASSIS_TYPE ]; then
        sed -i -e"s;chassis_type=$CMD_CHASSIS_TYPE;chassis_type=$CHASSIS_TYPE;" ${PROC_CMDLINE}
        bash /etc/init.d/genhosts.sh / $VM_TYPE
    fi

    if [ $CMD_CHASSIS_PID != $CHASSIS_PID ]; then
        sed -i -e"s;chassis_pid=$CMD_CHASSIS_PID;chassis_pid=$CHASSIS_PID;" ${PROC_CMDLINE}
    fi

    mount -n -o ro --bind /root/cmdline /proc/cmdline
}


function grub_resync()
{
    get_chassis_details_ipu
    local GRUB_FILE=/misc/disk1/tftpboot/grub.cfg

    CUR_SERIAL=$(cat ${GRUB_FILE} | grep chassis_serial= | sed "s;^.*chassis_serial=;;" | sed "s; .*$;;")
    if [ $CUR_SERIAL != $CHASSIS_SERIAL ]; then
        sed -i -e"s; chassis_serial=[^ ]*; chassis_serial=${CHASSIS_SERIAL};" ${GRUB_FILE}
    fi

    CUR_CHASSIS_TYPE=$(cat ${GRUB_FILE} | grep chassis_type= | sed "s;^.*chassis_type=;;" | sed "s; .*$;;")
    if [ $CUR_CHASSIS_TYPE != $CHASSIS_TYPE ]; then
        sed -i -e"s; chassis_type=[^ ]*; chassis_type=${CHASSIS_TYPE};" ${GRUB_FILE}
    fi

    CUR_CHASSIS_PID=$(cat ${GRUB_FILE} | grep chassis_pid= | sed "s;^.*chassis_pid=;;" | sed "s; .*$;;")
    if [ $CUR_CHASSIS_PID != $CHASSIS_PID ]; then
        sed -i -e"s; chassis_pid=[^ ]*; chassis_pid=${CHASSIS_PID};" ${GRUB_FILE}
    fi

}

function grub_cmdline_resync()
{
    local VM_TYPE=$1
    local BOARDTYPE=$2

    if [ "$VM_TYPE" == "hostos" ]; then
        if [ "$BOARDTYPE" == "RP" ]; then
            initctl emit ts_agt_rp_start
        else
            initctl emit ts_agt_lc_start
        fi

        return
    fi

    # Do not run the cmdline and grub routines for LC
    # LC does not have grub. And if LC cmdline has incorrect 
    # information we reimage that LC via ts_agt.c
    if [ "$BOARDTYPE" == "LC" ]; then
        return
    fi

    if [ "$VM_TYPE" == "sysadmin-vm" ]; then
        grub_resync
    fi
    rp_cmdline_resync $VM_TYPE
}

