#!/bin/sh
#------------------------------------------------------------------
# usb_mount & passthrough to VM
#
# Jan 2015, Rajesh Negi
#
# Copyright (c) 2015-2017 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------

# This file is a copy of the usb_passthrough from thirdparty
# workspace and has been modified for asr9k platform for lxc.
# It handle front panel usb hotplug/hotunplug
#
# We have to handle two cases here.
# 1. System is booted with USB and VM/LXC has not started
# 2. USB hotplug when VM/LXC is already started.
#
# This script is called from multiple places
# 1. From the udev rules (Hotplug case)/90-persistent-disk.rules
#
# The udev rule will create well known link for
# the usb devices.
# usbsdX --> sdX is assigned by Linux kernel
#
# $1 ---> add or remove
# $2 ---> device name [usbsda, usbsdb and so on]

# The script is only valid on HostOS
#Source function library
if [ -f /etc/init.d/spirit_pd.sh ]; then
    source /etc/init.d/spirit_pd.sh
fi

if [ -f /etc/init.d/spirit_log.sh ]; then
    source /etc/init.d/spirit_log.sh
fi

function get_partnum {
  local fullname=$1
  echo ${fullname} | tr -d a-z
  return
}

cmd=$1
device=$2
SDR_VMS=$(virsh list | grep running | grep "default-sdr" | awk '{print $2}')

function mount_vm_usb {
    local devname=$1
    if [ $(grep -c ${devname%%[0-9]*} /proc/partitions) -eq 1 ] ; then
        for avm in ${SDR_VMS}; do
            platform_log_exec virsh attach-disk "${avm}" /dev/${devname} vdusb --serial=usb-${device} --cache=none
            echo "attach $device to $avm" >> /usb_passthrough.log
        done
    else
        if [ ${devname} = ${devname%%[0-9]*} ]; then
            exit 1
        fi

        devnum=$(get_partnum $devname)
        if [ ${devnum} -eq 1 ]; then
            for avm in ${SDR_VMS}; do
                platform_log_exec virsh attach-disk "${avm}" /dev/${devname} vdusb --serial=usb-${device} --cache=none
                echo "attach $device to $avm" >> /usb_passthrough.log
            done
        fi
    fi
}

function unmount_vm_usb {
    for avm in ${SDR_VMS}; do
        platform_log_exec virsh detach-disk "${avm}" vdusb
        echo "remove $device to $avm" >> /usb_passthrough.log
    done

}

function mount_lxc_usb {
    local devname=$1
    majornum=$(printf "%d" `stat -c 0x'%t' /dev/${devname}`)
    minornum=$(printf "%d" `stat -c 0x'%T' /dev/${devname}`)
    devallowfile="/dev/cgroup/devices/machine/default-sdr--1.libvirt-lxc/devices.allow"
    if [ $(grep -c ${devname%%[0-9]*} /proc/partitions) -eq 1 ] ; then
        echo "b $majornum:$minornum rwm" > $devallowfile
        virsh -c lxc:/// attach-disk default-sdr--1 /dev/${devname} \
            vdusb --serial=usb-${device} --cache=none
    else
        if [ ${devname} = ${devname%%[0-9]*} ]; then
            exit 1
        fi

        devnum=$(get_partnum $devname)
        if [ ${devnum} -eq 1 ]; then
            echo "b $majornum:$minornum rwm" > $devallowfile
            virsh -c lxc:/// attach-disk default-sdr--1 /dev/${devname} \
                        vdusb --serial=usb-${device} --cache=none
        fi
    fi
}

function unmount_lxc_usb {
    virsh -c lxc:/// detach-disk default-sdr--1 vdusb
}

VM_MODE=`grep -c virtvm /proc/cmdline`

VMTYPE=`cat /proc/cmdline | sed 's/^.*vmtype=//' | cut -d" " -f1`


if [ -n ${VMTYPE} -a ${VMTYPE} == "hostos" ]; then
    if [ "$cmd" == "add" ]; then

        # Skip processing the eusb, don't pass through.
        if [ "$device" == "eusb*" ]; then
            return
        fi
        devname=$(readlink /dev/$device)

        # Limit amount of dirty pages for device
        if [ -f /sys/block/$devname/bdi/max_ratio ]; then
            echo 10 > /sys/block/$devname/bdi/max_ratio 2> /dev/null
        fi

        /usr/bin/logger -p 0 -t udev \
            "USB device inserted ${devname}: udev assigned device name ${device} "
        # The first partition would be passed to the XR only in this, the 
        # reason is that if more than one partition is passed, while detacthing
        # the VM/LXC hangs.So essentially its a workaround that, so all data 
        # has to go in the first partition.
        if [ $(grep -c ${devname%%[0-9]*} /proc/partitions) -gt 0 ] ; then
            if [ ${VM_MODE} -eq 1 ]; then
                mount_vm_usb $devname
            else
                mount_lxc_usb $devname
            fi
        fi
    fi

    
    if [ "$1" == "remove" ]; then
        /usr/bin/logger -p 0 -t udev "USB device removed $device"
        if [ ${VM_MODE} -eq 1 ]; then
            unmount_vm_usb
        else
            unmount_lxc_usb
        fi
    fi
fi
