 #!/bin/bash
 # Copyright (c) 2013-2014, 2018 by Cisco Systems, Inc.
 # All Rights Reserved.
 #------------------------------------------------------------------
 
 # Argument expected from the program
 # username password server files_to_download dest_dir proto vm_type
 # protocol can only be either sftp or ftp

exec &> /dev/null # this line is added to supress output of this script

mk_cmd="mkdir"
echo $*

#variable initialization
username=$1
password=$2
server=$3
files_to_download=$4
dest_dir=$5
proto=$6
vm_type=$7

filesys_cli="/pkg/sbin/filesys_cli"

if [ $6 = "sftp" ]; then
    proto_cmd="sshpass -p ${password} /pkg/bin/sftp"
else
    proto_cmd="cp ftp" 
fi

#create dir if it doesnt already exist
if [ ! -d "${dest_dir}" ]; then
    ${mk_cmd} ${dest_dir}
 
   #check if everyhing is fine
   ret=$?

   if [ $ret -ne 0 ]; then
       exit 2
   fi
fi

for file_name in $files_to_download
do
    echo ${file_name}
    file=$(basename $file_name) 
    if [ ${proto} = "sftp" ]; then
        ${proto_cmd} ${username}@${server}:${file_name} ${dest_dir}/${file} &> /tmp/sftp_copy_output.txt
        ret=$?
        if [ $ret -ne 0 ]; then
            exit 3
        fi 
    # ftp case
    else 
        ${filesys_cli} copy -a /ftp: -u //${username}:${password}@${server}//${file_name} -b ${dest_dir} -v / -V default -i 1 -I &> /tmp/shellutil_copy.txt
        ret=$?
        if [ $ret -ne 0 ]; then
            exit $ret 
        fi
    fi
   
done

