#!/bin/sh

# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
# Script to be invoked by pam_manager to start pam agents
#
# Feb 2016, Jieming Wang
#
# Copyright (c) 2016-2019 by Cisco Systems, Inc.
# All rights reserved.
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx



pid_dir="/opt/cisco/pam/run/";

action=$1
if [ "${action}" != "start" ] && [ "${action}" != "stop" ]
then
    echo "Invalid option. Usage"
    echo "$0 <start|stop>"
    exit 1
fi

if [ -z "$USER" ]
then
    export USER=root
fi


# the binary pam_manager will not try to start if stop is present:
# stop can be removed by calling start_pam.sh explicitly (pam start):

is_calvados=$(cat /proc/cmdline|egrep "vmtype=sysadmin-vm")
is_xr=$(cat /proc/cmdline|egrep "vmtype=xr-vm")
platform=$(cat /proc/cmdline|sed '{s#.*platform=##; s# .*##;}')

ssh_o="-q -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no"

pam_agent="${action}_pam.sh";

#rtr_pam_root=/opt/pam
#test ! -d $rtr_pam_root && mkdir -p $rtr_pam_root
if [ -n "${is_calvados}" ]
then
    pam_manager_log="/var/log/pam_manager.log"
    if [ -f /opt/cisco/calvados/pam/pam_logrotate.sh ]
    then
        /opt/cisco/calvados/pam/pam_logrotate.sh
    fi

    /opt/cisco/calvados/pam/$pam_agent
    output=$(ps auxw|egrep perl|egrep -v grep)
    if [ -n "${output}" ]
    then
        echo "===`date`===" >> $pam_manager_log
        ps auxw|egrep perl|egrep -v grep >> $pam_manager_log
    fi

elif [ -f /opt/cisco/thinxr/am_i_thinxr ]
then
    pam_dir=/pkg/opt/cisco/pam/
    source $pam_dir/pam-functions.sh
    pam_manager_log="/var/log/pam_manager.log"
    test ! -d /opt/cisco/pam/ && mkdir -p /opt/cisco/pam/
    if [ -f /pkg/opt/cisco/pam/pam_logrotate.sh ]
    then 
       /pkg/opt/cisco/pam/pam_logrotate.sh
    fi
    /pkg/opt/cisco/pam/$pam_agent
    output=$(ps auxw|egrep perl|egrep -v grep)
    if [ -n "${output}" ]
    then
        date >> $pam_manager_log
        echo "==========================" >> $pam_manager_log
        echo "${output}"|while read proc
        do
            echo $proc|sed '{s#.*/##; s#\.pl##;}'|awk '{printf "%26s%14s\n", $1, "running"}' >> $pam_manager_log
        done
    fi

elif [ -n "${is_xr}" ]
then
    pam_manager_log="/var/log/pam_manager.log"
    test ! -d /opt/cisco/pam/ && mkdir -p /opt/cisco/pam/
    if [ -f /pkg/opt/cisco/pam/pam_logrotate.sh ]
    then 
       /pkg/opt/cisco/pam/pam_logrotate.sh
    fi
    #/pkg/bin/show_platform_sysdb -v|egrep "/R[S]*P[0-9]*"|egrep FINAL|awk '{print $1, $7}'|while read node ip
    /pkg/bin/show_platform_sysdb -v|grep FINAL|awk '{print $1, $7}'|while read node ip
    do
        #/usr/bin/ssh $ssh_o -T $ip "/opt/cisco/pam/$pam_agent" &
        /usr/bin/ssh $ssh_o -T $ip "/pkg/opt/cisco/pam/$pam_agent" &
        sleep 1
        output=$(/usr/bin/ssh $ssh_o -T $ip "ps auxw|egrep perl|egrep -v grep"&)
        if [ -n "${output}" ]
        then
            printf "%14s%12s%14s\n" "=============" $node "=============" >> $pam_manager_log
            echo "${output}"|while read proc
            do
                echo $proc|sed '{s#.*/##; s#\.pl##;}'|awk '{printf "%26s%14s\n", $1, "running"}' >> $pam_manager_log
            done
        else
            printf "%14s%12s%14s\n" "=============" $node "=============" >> $pam_manager_log
        fi
    done
fi
