#/bin/sh

if [ -f /usr/bin/xr_sysctl ]; then
    platform=$(/usr/bin/xr_sysctl -n cisco.ios.xr.platform 2>/dev/null)
    if [ -z "${platform}" ]; then
        platform=$(echo $cmdline|sed '{s#.* platform=##; s# .*##;}')
    fi
    boardtype=$(/usr/bin/xr_sysctl -n cisco.ios.xr.board_type 2>/dev/null)
    vm_type=$(/usr/bin/xr_sysctl -n cisco.ios.xr.vm_type 2>/dev/null)
    is_vxr=$(/usr/bin/xr_sysctl -n cisco.ios.xr.vxr 2>/dev/null)
    if [ -z "${is_vxr}" ]; then
        is_vxr=$(echo $cmdline|egrep "__vxr=true")
    fi
    is_dev=$(/usr/bin/xr_sysctl -n cisco.ios.xr.development 2>/dev/null)

    if [ -z $platform ]; then
        cmdline=$(cat /proc/cmdline)
        platform=$(echo $cmdline|sed '{s#.* platform=##; s# .*##;}')
        boardtype=$(echo $cmdline|sed '{s#.* boardtype=##; s# .*##;}')
        vm_type=$(echo $cmdline|sed '{s#.* vmtype=##; s# .*##;}')
        is_vxr=$(echo $cmdline|egrep "__vxr=true")
        is_dev=$(echo $cmdline|egrep "__development=true")
    fi
else
    cmdline=$(cat /proc/cmdline)
    platform=$(echo $cmdline|sed '{s#.* platform=##; s# .*##;}')
    boardtype=$(echo $cmdline|sed '{s#.* boardtype=##; s# .*##;}')
    vm_type=$(echo $cmdline|sed '{s#.* vmtype=##; s# .*##;}')

    is_vxr=$(echo $cmdline|egrep "__vxr=true")
    is_dev=$(echo $cmdline|egrep "__development=true")
fi

is_panini=$(echo $platform|egrep "panini|ncs6k|xboard")
is_scapa=$(echo $platform|egrep "scapa|ncs4k")
is_asr9k=$(echo $platform|egrep "asr9k")
is_xrv9k=$(echo $platform|egrep "xrv9k")
is_spitfire=$(echo $platform|egrep "spitfire")

is_xr=$(echo $vm_type|egrep "xr-vm")
is_calv=$(echo $vm_type|egrep "sysadmin-vm")
is_host=$(echo $vm_type|egrep "hostos")

is_rp=$(echo $boardtype|egrep "CB|CC|RP")

export platform
export boardtype
export vm_type

export is_panini
export is_scapa
export is_asr9k
export is_xrv9k
export is_spitfire

export is_xr
export is_calv
export is_host

export is_vxr
export is_dev

export is_rp
