#!/usr/bin/python

import argparse
import datetime
import json
import os
import re
import subprocess
from   subprocess import Popen, PIPE, call
import sys

os.environ['PATH'] = "/opt/cisco/calvados/confd/lib/confd/bin:"
os.environ['PATH'] += "/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/sbin:/sbin:/bin:"
os.environ['PATH'] += "/opt/cisco/calvados/confd/bin/"

#os.environ['LD_PRELOAD'] = "/opt/cisco/calvados/usr/lib64/libmemdbg.so"
os.environ['DYLD_LIBRARY_PATH'] = "/opt/cisco/calvados/confd/lib/confd/priv/confd"

#os.environ['BINDIR'] = "/opt/cisco/calvados/confd/lib/confd/bin"

os.environ['LD_LIBRARY_PATH'] = "/opt/cisco/calvados/usr/lib64/:/lib64:"
os.environ['LD_LIBRARY_PATH'] += "/opt/cisco/calvados/confd/lib/confd/priv/confd:"
os.environ['LD_LIBRARY_PATH'] +=" /opt/cisco/calvados/usr/lib64/:/usr/lib64/"
os.environ['LD_LIBRARY_PATH'] = "/opt/cisco/calvados/confd/lib/confd/priv/confd"

admin_cli =  "/opt/cisco/calvados/bin/admin-cli-proxy"

def ReadCommandLine():
    data = ''
    with open("/proc/cmdline", 'r') as f:
        data = f.read()
    data = data.split()
    out = {}
    for string in data:
        if '=' in string:
            stuff = string.split('=')
            key = stuff[0]
            value = stuff[1]
            out[key] = value
    return out

def get_platform():
    cmdline = ReadCommandLine()
    platform = ""
    if 'platform' in cmdline:
        platform = cmdline['platform'].lower()
    return platform


def confd_cli_wrapper(mode, cli, username):
    plt = get_platform()
    if not username:
        os.environ['USER'] = 'root'
    else:
        os.environ['USER'] = username
    os.environ['USER'] = 'root'
    chvrfplats = r'(asr9k|panini|scapa|ncs[46]k)'
    pltMatches = re.match(chvrfplats, plt)
    chvrf = "";
    if pltMatches != None:
        chvrf = "/sbin/chvrf 0";
    command = chvrf + admin_cli + "<<END\n"
    if mode == "config":
        command += "config\n"
        command += cli + "\n"
        command += "commit\n"
        command += "END"
    elif mode == "exec":
        command += cli + " | nomore\n"
        command += "END"
    else:
        command = cli

    if DEBUG:
          print ("command=%s" % command)
    p = subprocess.Popen(command, stdout=subprocess.PIPE, shell=True)
    output, err = p.communicate()
    if err != None:
        print ("Failed to run '%s'" % command)
        return -1

    invalidState = r'Confd is down|Aborted: |syntax error: '
    for o in output.split('\n'):
        Matches = re.match(invalidState, o)
        if Matches != None:
            if mode == "config":
                print("Failed to apply config %s" % cli)
            else:
                print("Failed to to execute '%s'" % cli)
            print("Error: %s" % output)
            return -1

    if mode == "config":
        print("config '%s' has been applied successfully" % cli)
    else:
        print(output)
    return -1

if __name__ == '__main__':
    parser  = argparse.ArgumentParser()
    parser.add_argument('-d', '--debug',
                        help    = "Enable debug",
                        action  = 'store_true')
    parser.add_argument('-m', '--mode',
                        help    = "execution mode: config, exec, or shell",
                        choices = ['config',
                                   'exec',
                                   'shell'],
                        default = '')
    parser.add_argument('-c', '--cli',
                        help    = 'CLI to be executed or configure',
                        metavar = '<cli>',
                        default = '')

    args = parser.parse_args()

    DEBUG = args.debug
    if args.mode is None:
        parser.print_help()
        sys.exit(2)
    mode = args.mode

    if args.cli == '':
        parser.print_help()
        sys.exit(2)
    cli = args.cli

    username = "root"
    rc = confd_cli_wrapper(mode, cli, username)

