#!/bin/bash

# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
# This script is used to assist debug - only run vxr and only cisco internal
#
# Dec 2017, Jieming Wang
#
# Copyright (c) 2016-2019 by Cisco Systems, Inc.
# All rights reserved.
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

pam_dir=/pkg/opt/cisco/pam/
source $pam_dir/pam-functions.sh
pam_tmp_dir=/root/pam/
vxr_log="$pam_dir/vxr_lindt_start_pam.log"

get_pam_data_from_iso() {
    local HOST_MOUNT=/mnt/pam_iso
    local PAM_DIR=/root/pam
    if [ -n "${is_xr}" -o -n "${is_vxr}" -o -n "${is_dev}" ] && \
       [ -n "${is_xrv9k}" -o -n "${is_spitfire}" -o -n "${is_xrv9k}" ] ; then
        echo "scanning all disks to find out id_rsa files at `date`" >> $vxr_log
        for device in $( ls /dev ); do
            echo $device|egrep "^(sr)" >/dev/null
            if [ $? == 0 ]; then
                test ! -d $HOST_MOUNT && mkdir -p $HOST_MOUNT
                mount /dev/$device $HOST_MOUNT -o loop >/dev/null 2>&1
                if [ $? != 0 ]; then
                    continue
                fi
                echo "Boostrap: Mounted /dev/$device to $HOST_MOUNT at `date`" >> $vxr_log
                pam_data_dir=$HOST_MOUNT
                if [ -d $HOST_MOUNT/pam ]; then
                    pam_data_dir=$HOST_MOUNT/pam/
                fi
                ls_id_rsa=$(ls $pam_data_dir/id_[rd]sa* 2>/dev/null)
                if [ -n "${ls_id_rsa}" ]; then
                    #Copy all rsa keys and mount config
                    test ! -d $PAM_DIR && mkdir -p $PAM_DIR
                    cp $pam_data_dir/* $PAM_DIR/
                    echo "Boostrap: Copied files from $pam_data_dir/* to $PAM_DIR/ at `date`" >> $vxr_log
                    umount $HOST_MOUNT -d
                    return 1
                fi
                umount $HOST_MOUNT -d
            fi
        done
    fi
    return 0
}

function get_ip() {
    virbr0_ip=""
    find /proc/sys -name \*eth[0-9]|sed '{s#.*/##;}'|sort -u|while read eth
    do
        eth_ip=$(ifconfig $eth|egrep "inet addr:"|sed '{s#.*inet addr:##; s# .*##;}')
        echo $eth_ip|egrep '192\.168\.' > /dev/null
        if [ $? = 0 ]; then
            virbr0_ip=$(echo $eth_ip|sed '{s#\.[0-9]*$#\.1#;}')
            echo $virbr0_ip
            return
        fi
    done
}

is_lindt() {
    if [ -d /opt/cisco/thinxr ]; then
        echo yes
    fi
}

#returns OK if $1 contains $2
strstr() {
    [ "${1#*$2*}" = "$1" ] && return 1
    return 0
}

sshfs_o="-o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no"
ssh_o="-q $sshfs_o"
id_rsa=$pam_tmp_dir/id_dsa-hfrtest
pam_mount="/auto/pam/"
username="hfrtest"

if [ -n "${is_vxr}" -o -n "${is_dev}" ] && \
   [ -n "$(is_lindt)" -o "${is_xrv9k}" ]; then

    test ! -d $pam_tmp_dir && mkdir -p $pam_tmp_dir
    if [ -n "$(is_lindt)" ]; then
        get_pam_data_from_iso
        if [ $? != 1 ]; then
            echo "No pam data found - exit (`date`)" >> $vxr_log
            exit
        fi
    fi

    if [ -n "$(is_lindt)" ]; then
        virbr0_ip=$(get_ip)
    else
        xr_ip=$(ifconfig eth-vf1.3073|egrep "inet addr:"|sed '{s#.*inet addr:##; s# .*##;}')
        virbr0_ip=$(echo $xr_ip|sed '{s#\.[0-9]*$#\.1#;}')
    fi

    server_str_ip=""
    username=""
    hfrtest=""
    id_rsa=""

    #default username is hfrtest
    #username=${username-"hfrtest"}
    for _id_rsa in $pam_tmp_dir/id_*
    do
       echo $_id_rsa|egrep "id_[rd]sa\-" >/dev/null 2>&1
       if [[ "$?" != "0" ]]; then
           continue
       fi
       chmod 0600 $_id_rsa
       if [ $_id_rsa == "id_dsa-hfrtest" -o \
            $_id_rsa == "id_rsa-hfrtest" ]
       then
           hfrtest="hfrtest"
           id_rsa_hfrtest=$_id_rsa
       else
           username=$(echo $_id_rsa|sed '{s#.*sa\-##;}')
           id_rsa=$_id_rsa
       fi
    done
    if [ -z "$(is_lindt)" ]; then
       username="root"
       id_rsa=$id_rsa_hfrtest
    fi

    #mount WS and related folders on host
    test ! -d ${pam_mount} && mkdir -p ${pam_mount}
    if [ -z "${username}" -a -z "${hfrtest}" ]; then
        echo "Unable to find valid rsa file `date`" >> $vxr_log
        exit
    elif [ -z "${username}" -a -n "${hfrtest}" ]; then
        username="hfrtest"
        id_rsa=$id_rsa_hfrtest
    fi
    _ssh_opt="-o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no"
    sshfs_o="$_ssh_opt -o IdentityFile=$id_rsa "
    ssh_o="-q $sshfs_o"

    show_ver=/etc/show_version.txt
    lb_server=$(egrep "^Host" $show_ver|sed '{s#.*Host *[=:] *##; s# *##g;}')
    ws_path=$(egrep "^ *Workspace" $show_ver|sed '{s#.*Workspace *[=:] *##; s# *##g;}')

    use_nat=""
    if strstr $lb_server "iox-lnx-" && strstr $ws_path "/san" ; then
        ws_path=/auto/${lb_server}-$(echo $ws_path|sed '{s#^/*##;}')
        use_nat=1
    fi
    echo $ws_path|grep -q "^/auto/"
    if [[ "$?" == "0" ]]; then
        ws_mnt_ip=$virbr0_ip
    elif [ -n "$(is_lindt)" ]; then
        ssh_cmd="ssh $ssh_o $username@$virbr0_ip nslookup $lb_server"
        out=$($ssh_cmd)
        lb_server_ip=$(echo $out|sed '{s#.*Address: *##;}')
        ws_mnt_ip=$lb_server_ip
    fi

    ################################################
    #mount workspace
    ################################################
    test ! -d /ws && mkdir /ws
    is_ws_mounted=$(grep "${ws_path}" /proc/mounts)
    if [[ -n "${is_ws_mounted}" ]]; then
        umount /ws >/dev/null 2>&1
    fi
    if [ -n "$(is_lindt)" ]; then
        sshfs $sshfs_o ${username}@${ws_mnt_ip}:${ws_path} /ws
    fi

    ################################################
    #mount $pam_mount (/auto/pam)
    ################################################
    is_pam_dir_mounted=$(grep "${pam_mount}" /proc/mounts)
    if [[ -n "${is_pam_dir_mounted}" ]]; then
        umount $pam_mount > /dev/null 2>&1
    fi
    if [ -n "$(is_lindt)" ]; then
        sshfs $sshfs_o ${username}@${virbr0_ip}:${pam_mount} $pam_mount
    fi

    #parse metadata (used to mount and scripts to be executed)
    #need JSON::PP
    #/usr/lib64/perl/5.22.1/JSON/PP.pm
    if [ -f $pam_tmp_dir/test_metadata.json ]; then
        perl $pam_dir/parse_metadata.pl \
                -i $pam_tmp_dir/test_metadata.json \
                -d $pam_tmp_dir >>$vxr_log 2>&1
    fi

    ################################################
    #extra (user defined) mounts
    ################################################
    if [[ -f $pam_tmp_dir/mounts.txt ]]; then
        cat $pam_tmp_dir/mounts.txt|while read line
        do
            mnt=$(echo $line|awk -F, '{print $1}')
            mnt=$(echo $mnt|sed '{s#//*#/#g; s#/*$##g;}')
            mnt_server=$(echo $line|awk -F, '{print $2}')
            is_mounted=$(grep "${mnt} " /proc/mounts)
            if [[ -n "${is_mounted}" ]]; then
                umount $mnt > /dev/null 2>&1
            fi
            test ! -d $mnt && mkdir -p $mnt

            #TODO - IP -> hostname
            server_ip=$virbr0_ip
            if [ -n "${mnt_server}" ]; then
                is_hostname=$(echo $mnt_server|egrep "[0-9]+\.[0-9]+\.[0-9]+\.[0-9]")
                if [ -z "${is_hostname}" ]; then
                    mnt_server=$(echo $mnt_server|sed '{s#\.cisco.*##;}')
                    mnt_server="${mnt_server}.cisco.com"
                fi
                server_ip=$mnt_server
                if [ -n "$(is_lindt)" ]; then
                    ssh_cmd="ssh $ssh_o $username@$virbr0_ip nslookup $"
                    lb_server_ip=$($ssh_cmd|egrep Address|tail -1|awk '{print $2}')
                fi
            fi
            if [ -n "$(is_lindt)" ]; then
                sshfs $sshfs_o ${username}@${server_ip}:${mnt} $mnt
            else
                sshfs ${virbr0_ip}:${mnt} $mnt
            fi
        done
    fi

    PAM_VXR=$pam_mount/install/setup/vxr/
    is_ws_mounted=$(egrep "$ws_path" /proc/mounts)
    if [ -n "${is_ws_mounted}" ]; then
        ###################
        #copy gdb/xrng_gdb
        ###################
        if [ ! -f /usr/bin/gdb ]; then
            ws_gdb=/ws/thirdparty/opensource/sdk/x86_64-rootfs/usr/bin/gdb
            if [ -f $ws_gdb ]; then
                cp -p $ws_gdb /usr/bin/gdb
            fi
        fi
        if [ ! -f /usr/bin/xrng_gdb ]; then
            #ws_xrng_gdb=/auto/thirdparty-sdk/target_bin/xrng_gdb
            ws_xrng_gdb=/auto/pam/sbt/xrng_gdb
            scp -p $ssh_o ${username}@${virbr0_ip}:$ws_xrng_gdb /usr/bin/
        fi

        ###################
        #copy mrxvt for creating vnc
        ###################
        mrxvt_dir=/misc/disk1/pam/mrxvt/
        test ! -d $mrxvt_dir && mkdir -p $mrxvt_dir
        if [ -f $PAM_VXR/mrxvt.tar ]; then
            cp $PAM_VXR/mrxvt.tar $mrxvt_dir
            cd $mrxvt_dir && tar xvf mrxvt.tar >/dev/null 2>&1
            rm -f $mrxvt_dir/mrxvt.tar 2>&1
        fi
        if [ -f  $PAM_VXR/vnc_env.sh ]; then
            cp $PAM_VXR/vnc_env.sh /root/
        fi
    fi

    #disable CVAC
    if  [ "0" = "1" ]; then
        if [ -n "$(is_xrv9k)" ]; then
            #apply config - TODO: execute via a separate script
            if [ -f $pam_tmp_dir/iosxr_config.txt ]; then
                PAM_CVAC_DIR=$pam_mount/install/setup/vxr/utils/
                if [ -f $PAM_CVAC_DIR/pam_cvac.sh ]; then
                    cp -p $PAM_CVAC_DIR/pam_cvac* /pkg/bin/
                    (setsid /pkg/bin/pam_cvac.sh) &
                fi
            fi
        fi
    fi

    #umount $pam_mount if not defined in json file
    is_mounted=$(grep ":$pam_mount" /proc/mounts)
    if [ ! -f $pam_tmp_dir/mounts.txt ]; then
        if [ -n "${is_mounted}" ]; then
            umount $pam_mount >/dev/null 2>&1
        fi
    else
        do_pam_mount=$(grep "$pam_mount" $pam_tmp_dir/mounts.txt)
        if [ -n "${is_mounted}" -a -z "${do_pam_mount}" ]; then
            umount $pam_mount >/dev/null 2>&1
        fi
    fi
fi

