#!/usr/bin/bash
#-----------------------------------
#mem_cmp.sh
#
#Nov 2011, Vishal Gupta
#Copyright (c) 2010-2011, 2015-2016 by Cisco Systems, Inc.
# All rights reserved.
#-----------------------------------

start_file="$2"
end_file="$1"

#check for command line parameters count
if [ $# -lt 2 ]; then
        printf "Incorrect Syntax.  Correct syntax is : <script> <file_1> <file_2> \n"
        exit
fi

if [ ! -e "$start_file" ]; then
    printf "%s does not exist. \nUse \"show memory compare start\"\n" $start_file
    exit
fi

if [ ! -e "$end_file" ]; then
    printf "%s does not exist. \nUse \"show memory compare end\"\n" $end_file
    exit
fi

#read line by line from start_file
while read -r file1_line
do
    pid1=`echo $file1_line | sed 's/-*//'| sed 's/^ *//' | sed -e "s/[[:space:]]\+/ /g" | cut -d ' ' -f 1`

        #look for same pid in end_file
        file2_line=`cat $end_file | grep -w $pid1`

        if [ "$file2_line" == "" ]; then
                continue;
        fi

        #extract process name from both the files
        pname1=`echo $file1_line | sed 's/-*//'| sed 's/^ *//' | sed -e "s/[[:space:]]\+/ /g" | cut -d ' ' -f 2`
        pname2=`echo $file2_line | sed 's/-*//'| sed 's/^ *//' | sed -e "s/[[:space:]]\+/ /g" | cut -d ' ' -f 2`

        #eliminates chances of pid reuse
        if [ "$pname1" != "$pname2" ]; then
                continue;
        fi

        #extract field values
        #memory from start_file
        file1_val1=`echo $file1_line | sed 's/-*//'| sed 's/^ *//' | sed -e "s/[[:space:]]\+/ /g" | cut -d ' ' -f 3`

        #Number of mallocs from start_file
        file1_val2=`echo $file1_line | sed 's/-*//'| sed 's/^ *//' | sed -e "s/[[:space:]]\+/ /g" | cut -d ' ' -f 4`

        #memory from end_file
        file2_val1=`echo $file2_line | sed 's/-*//'| sed 's/^ *//' | sed -e "s/[[:space:]]\+/ /g" | cut -d ' ' -f 3`

        #Number of mallocs from end_file
        file2_val2=`echo $file2_line | sed 's/-*//'| sed 's/^ *//' | sed -e "s/[[:space:]]\+/ /g" | cut -d ' ' -f 4`

        val_1=""
        val_2=""
        if [ "$file1_val1" != "" -a  "$file2_val1" != "" ]; then
                val_1=`expr $((0x$file2_val1 - 0x$file1_val1))`
        fi

        if [ "$file1_val2" != "" -a  "$file2_val2" != "" ]; then
                val_2=`expr $((0x$file2_val2 - 0x$file1_val2))`
        fi

        file1_val1=`echo $((0x${file1_val1}))`
        file2_val1=`echo $((0x${file2_val1}))`

        printf "\n%-7d%-25s%-12d%-12d%-12d%-12d" $pid1 $pname1 $file1_val1 $file2_val1 $val_1 $val_2
done < "$start_file"
        printf "\n" 
