#!/bin/bash 
#
# pradkum2: Create V2 iso from V1 iso
#
# Copyright (c) 2015-2016 by cisco Systems, Inc. All rights reserved.
#


ISO_V1_TFTP=/misc/disk1/tftpboot
ISO_V1_LOC=$ISO_V1_TFTP/system_image.iso
SCRATCH_LOC=/misc/disk1/mkv2.$$

function mkv2iso_xr () {
    mount -o loop $ISO_V1_LOC $SCRATCH_LOC/v1

    if [ $? != "0" ]; then
        return
    fi

    printf "Extracting V1 XR iso\n"

    zcat v1/boot/initrd.img | cpio -iv --make-directories "iso/asr9k-xr.iso" 
    umount $SCRATCH_LOC/v1

    mkdir v1xr
    mount -o loop iso/asr9k-xr.iso v1xr
    if [ $? != "0" ]; then
        return
    fi

    cp -rf v1xr v1xr_copy
    umount v1xr

    # get XR version and minor version
    V1_XR_VER=$(grep Version v1xr_copy/iso_info.txt | awk '{print $4}')
    V1_XR_VER_MIN=$(printf $V1_XR_VER | cut -d"." -f4)

    printf "XR version V1 : $V1_XR_VER minor $V1_XR_VER_MIN\n"

    printf "Creating V2 XR iso\n"

    # increment minor vesion for creating v2 
    V2_XR_VER_MIN=$(printf "%02dI" $(expr ${V1_XR_VER_MIN:0:2} + 1))

    sed -i s/$V1_XR_VER_MIN/$V2_XR_VER_MIN/g v1xr_copy/iso_info.txt

    cp v1xr_copy/boot/initrd.img initrd.img.gz
    gzip -d initrd.img.gz

    cpio -t < initrd.img > v1xr_list

    mkdir -p v1xr_initrd
    cd v1xr_initrd 
    cpio -i < ../initrd.img
    sed -i s/$V1_XR_VER_MIN/$V2_XR_VER_MIN/g etc/show_version.txt
    sed -i s/$V1_XR_VER_MIN/$V2_XR_VER_MIN/g etc/build-info.txt
    rm -f ../initrd.img 
    cpio -o < ../v1xr_list > ../initrd.img
    cd ..
    gzip initrd.img
    cp initrd.img.gz v1xr_copy/boot/initrd.img
    V2_XR_VER=$(grep Version v1xr_copy/iso_info.txt | awk '{print $4}') 
    printf "XR version V2 : $V2_XR_VER minor $V2_XR_VER_MIN\n"

    mkisofs -o asr9k-xr-$V2_XR_VER.iso v1xr_copy/
    if [ -f asr9k-xr-$V2_XR_VER.iso ]; then
        # copy v2 iso to source v1 iso folder
        mv asr9k-xr-$V2_XR_VER.iso $ISO_V1_TFTP
        printf "created $ISO_V1_TFTP/asr9k-xr-$V2_XR_VER.iso\n"
    else
        printf "v2 xr iso create failed\n"
    fi
}

function mkv2iso() {
    if [ ! -f $ISO_V1_LOC ]; then 
        printf "V1 image $ISO_V1_LOC not found\n"
        return
    fi

    mkdir -p $SCRATCH_LOC
    mkdir -p $SCRATCH_LOC/v1
    cd $SCRATCH_LOC

    mkv2iso_xr

    rm -rf $SCRATCH_LOC
}

mkv2iso $*

