#!/bin/bash
#
# Copyright (c) 2010-2018 by cisco Systems, Inc.
# All rights reserved.
#

source /etc/init.d/calvados_bootstrap.cfg

fs_sb_output=/tmp/fs_sb_output
EXT2_FS_MAGIC_NUMBER=0xEF53

function strstr ( )
{
  echo $1 | grep --quiet $2
}

function check_if_partitioned {
   local DISK=/dev/${1}
   local VG=pci_disk1
   local partition=$(parted $DISK print < /dev/null 2>/dev/null | grep "partition0" | wc -l)
   if (( $partition == 0 )); then
      echo 0
   else
      # Disk is now in partition 2
      if [ -b ${DISK}2 ]; then
         DISK=${DISK}2
      else
         false
      fi
      pv_exists=$(pvscan 2>/tmp/pvscan_err.log | grep $DISK)
      if [ ! -z "$pv_exists" ]; then
         vol_grp_size=$(vgs --nosuffix --units b --noheadings -o vg_size $VG)
         phy_vol_size=$(pvs --nosuffix --units b --noheadings -o pv_size $DISK)
         if (( $vol_grp_size != $phy_vol_size ));then
            echo 0
         else
            echo 1
         fi    
      else
         echo 0   
      fi
    fi  
}

function find_parted_total_partition {
    local dev_name=${1}
    local dev=/dev/${dev_name}
    local tpart=$(parted -l $dev < /dev/null | grep "partition0" | wc -l) >>       \
/var/log/dr_log 2>&1
    local tpart=$(parted $dev print < /dev/null | grep "partition0" | wc -l) >>    \
/var/log/dr_log 2>&1
    echo "${tpart}"
}

function find_repo_total_partition {
    local tpart=$(parted  /dev/sda print  < /dev/null | grep partition02 | tr -s " " | cut -d " " -f5) >>    \
/var/log/dr_log 2>&1
    echo "${tpart}"
}

# Source for the below function 
# thirdparty/package/sysadmin-libexec/x86_64/etc/rc.d/init.d/disk-functions 

function remove_lv_vg_disk1 {
    echo "Begin remove_lv_vg_disk1" >> /var/log/dr_log
    readonly DISK1_PV=pci_disk1

   local sdr_vm_name
   local sysadmin_vm_name
   for f in $(virsh list  --name); do
      echo $f  >> /var/log/dr_log ;
      if strstr $f sysadmin; then
      {
          echo "sysadmin name :" $f  >> /var/log/dr_log
          sysadmin_vm_name=$f
      } else {
          echo "SDR : " $f  >> /var/log/dr_log
          sdr_vm_name=$f
      }
      fi
    done

    echo "Sysadmin :"$sysadmin_vm_name  >> /var/log/dr_log
    echo "Final SDR :"$sdr_vm_name  >> /var/log/dr_log

    # remove passthrough to sysadmin VM
    virsh detach-disk ${sysadmin_vm_name} `virsh domblklist ${sysadmin_vm_name} | grep ssd_disk1_calvados_1 | cut -d " " -f1` >> /var/log/dr_log  2>&1
    virsh detach-disk ${sysadmin_vm_name} `virsh domblklist ${sysadmin_vm_name} | grep sdb1 | cut -d " " -f1` >> /var/log/dr_log 2>&1
    # remove passthrough to XR VM
    virsh detach-disk ${sdr_vm_name} `virsh domblklist $sdr_vm_name | grep ssd_disk1_xr_1 | cut -d " " -f1` >> /var/log/dr_log 2>&1 
    # umount host partition
    /bin/umount /misc/disk1 >> /var/log/dr_log 2>&1 
    #rmdir /misc/disk1

    # deactive the vg when disk removed
    vlist=`/sbin/dmsetup ls | grep pci_disk1- | cut -d "(" -f1`
    for i in $vlist; do
       echo "Doing dmsetup remove $i" >>/var/log/dr_log 2>&1;
       /sbin/dmsetup remove /dev/mapper/$i >>/var/log/dr_log 2>&1;
    done

    vgremove -f ${DISK1_PV} >> /var/log/dr_log 2>&1
    pvremove -ff -y /dev/sdb  >> /var/log/dr_log 2>&1
    pvremove -ff -y /dev/sdb2  >> /var/log/dr_log 2>&1
    rm -rf /dev/pci_disk1/ 2>&1 
    pvscan >> /var/log/dr_log 2>&1
    vgscan >> /var/log/dr_log 2>&1
    dmsetup ls >> /var/log/dr_log 2>&1
    virsh list --all >> /var/log/dr_log 2>&1
    echo "End remove_lv_vg_disk1" >> /var/log/dr_log
}

function check_fs_sb {
    local return_code=0
    local fs_mn=0
    local part=${1}

    dumpe2fs -h ${part}  > $fs_sb_output 2>&1
    if (( $? == 1 )); then
        return_code=1
    else
        fs_mn=$(grep "magic number" $fs_sb_output | awk '{print $4}')
        if (( $fs_mn != $EXT2_FS_MAGIC_NUMBER )); then
            return_code=2
        fi
    fi

    return $return_code
}
readonly -f check_fs_sb

function format_partition {
    local dev_name=${1} label=${2}

    # Reformat partition with an ext4 file system
    /sbin/mkfs.ext4 -L ${label} -b 4096 -vv ${dev_name} >> /dev/null 2>&1
    /sbin/tune2fs -c 0 -i 0 ${dev_name} >> /dev/null 2>&1
    sync
}
readonly -f format_partition

function check_fs_partition {
    local dev_name=${1} label=${2}

    check_fs_sb ${dev_name}
    # Even though super block is EXT4, redo mkfs.
    # The Partition label may have changed
    format_partition ${dev_name} ${label}
}

function create_parted_partition {
    echo "Begin create_parted_partition" >> /var/log/dr_log
    local dev_name=${1}
    local dev=/dev/${dev_name}
    local which_disk

    readonly DISK1_PV=pci_disk1
    readonly DISK1_LV=ssd_disk1_
    readonly DISK1_LABEL=DISK_ONE

    # 5 sub-partitions: 1 for hostOS, 2 for Calvados VMs, 2 for XR VMs
    readonly D1_HOST_LV=hostos
    readonly D1_CVDS_LV1=calvados_1
    readonly D1_CVDS_LV2=calvados_2
    readonly D1_XR_LV1=xr_1
    readonly D1_XR_LV2=xr_2
    readonly D1_NUM_LV=5

    local sdr_vm_name
    local sysadmin_vm_name
    for f in $(virsh list  --name); do
       echo $f ;
       if strstr $f sysadmin; then
       {
           echo "sysadmin name :" $f
           sysadmin_vm_name=$f
       } else {
           echo "SDR : " $f
           sdr_vm_name=$f
       }
       fi
     done

     echo "Sysadmin :"$sysadmin_vm_name
     echo "Final SDR :"$sdr_vm_name

    umount /dev/sdb1 >> /var/log/dr_log 2>&1

    echo "Create parted partition ${dev}" >>/var/log/dr_log 2>&1

    # zero the first 10000 1024 blocks
    /bin/dd if=/dev/zero of=${dev} bs=1024 count=10000 >> /var/log/dr_log 2>&1

    parted -s ${dev} mklabel gpt  >> /var/log/dr_log 2>&1
    
    local max=$(parted /dev/sda print | grep "Disk /dev"  | cut -d ' ' -f3)
    local max=$(parted $dev print | grep "Disk /dev"  | cut -d ' ' -f3)
    max=${max%GB}
    max=${max%.[0-9]}
    local max_size=$(expr ${max} \* 1000)
        
    if [ -z ${max} ]; then
        echo "ERROR! No install boot device found, exiting..."
        exit 0
    fi
    if strstr "${2}" fdisk1; then
       # For RP with second disk, partition it and place recovery partition (2G)    on its 1st partition.
       parted -s --align=min ${dev} mkpart partition01 0 2000 >> /var/log/dr_log 2>&1
       parted -s --align=min ${dev} mkpart partition02 2000 ${max_size} >> /var/log/dr_log 2>&1
       parted -s ${dev} set 1 boot on >> /var/log/dr_log 2>&1
       sync
       sleep 2

       # Format /dev/sdb1 with FAT FS and set the label as RecoveryOs 
       /sbin/mkfs.vfat -F16 -n "RecoveryOs" /dev/sdb1  >> /var/log/dr_log 2>&1 
       parted -l  >> /var/log/dr_log 2>&1

       local DISK_SIZE=$(blockdev --getsize64 /dev/sdb2)

        # Divide the partition equally! 
        local LV_SIZE=$(expr ${DISK_SIZE} / 1024 / 1024 / ${D1_NUM_LV})
        local XR_LV_SIZE=${LV_SIZE}M
        local CALVADOS_LV_SIZE=${LV_SIZE}M
        local HOST_LV_SIZE=$(expr ${LV_SIZE} \* 8 / 10)M

       pvscan >> /var/log/dr_log 2>&1
       vgscan >> /var/log/dr_log 2>&1
       # Create physical volume and volue group
       #/bin/dd if=/dev/zero of=${dev}2 bs=1024 count=10000 >> /var/log/dr_log 2>&1
       #check_fs_partition "/dev/sdb2" "${DISK1_LABEL}"
       #sleep 4
       dmsetup remove pci_disk1-ssd_disk1_calvados_3 >>/var/log/dr_log 2>&1
       rm -rf /dev/pci_disk1/
       pvcreate -ff -y ${dev}2 >> /var/log/dr_log 2>&1
       sleep 2
       vgcreate -f -y ${DISK1_PV} ${dev}2 >> /var/log/dr_log 2>&1

       #Logical volume for Host
       lvcreate -L ${HOST_LV_SIZE} -n ${DISK1_LV}${D1_HOST_LV} ${DISK1_PV} >> /var/log/dr_log  2>&1
       check_fs_partition "/dev/mapper/${DISK1_PV}-${DISK1_LV}${D1_HOST_LV}" \
       "${D1_HOST_LV}_${DISK1_LABEL}"

       #Logical volume for Calvados VM1/2
       lvcreate -L ${CALVADOS_LV_SIZE} -n ${DISK1_LV}${D1_CVDS_LV1} ${DISK1_PV} >> /var/log/dr_log  2>&1
       check_fs_partition "/dev/mapper/${DISK1_PV}-${DISK1_LV}${D1_CVDS_LV1}" \
       "${DISK1_LABEL}"

       lvcreate -L ${CALVADOS_LV_SIZE} -n ${DISK1_LV}${D1_CVDS_LV2} ${DISK1_PV} >> /var/log/dr_log 2>&1
       check_fs_partition "/dev/mapper/${DISK1_PV}-${DISK1_LV}${D1_CVDS_LV2}" \
       "${DISK1_LABEL}"

       #Logical volume for XR VM1/2
       lvcreate -L ${XR_LV_SIZE} -n ${DISK1_LV}${D1_XR_LV1} ${DISK1_PV} >> /var/log/dr_log 2>&1
       check_fs_partition "/dev/mapper/${DISK1_PV}-${DISK1_LV}${D1_XR_LV1}" \
       "${DISK1_LABEL}"

       lvcreate -L ${XR_LV_SIZE} -n ${DISK1_LV}${D1_XR_LV2} ${DISK1_PV} >> /var/log/dr_log 2>&1
       check_fs_partition "/dev/mapper/${DISK1_PV}-${DISK1_LV}${D1_XR_LV2}" \
       "${DISK1_LABEL}"

        # sleep 1 to make sure vg actived before mount and passthrough
        /sbin/lvm vgchange -ay pci_disk1 >> /var/log/dr_log 2>&1
        sleep 1

        # mount host partition
        if [ ! -d /misc/disk1 ]; then 
        mkdir -p /misc/disk1 >> /var/log/dr_log 2>&1
        fi 

        set -e
        /bin/mount /dev/pci_disk1/ssd_disk1_hostos /misc/disk1 >> /var/log/dr_log

        # On Successful partition creation, attach DR partition to sysadmin 
        virsh attach-disk $sysadmin_vm_name /dev/sdb1 vdboot --cache=none >> /var/log/dr_log
        sleep 2

        # passthrough to sysadmin VM
        virsh attach-disk $sysadmin_vm_name /dev/pci_disk1/ssd_disk1_calvados_1 vdecu --serial=ecu-ecusdb --cache=none >> /var/log/dr_log

        # passthrough to XR VM
        virsh attach-disk $sdr_vm_name /dev/pci_disk1/ssd_disk1_xr_1 vdecu --serial=ecu-ecusdb --cache=none >> /var/log/dr_log

        set +e
       echo "End create_parted_partition" >> /var/log/dr_log
       echo "[Success]"
       #exit 0
    else 
       echo "End create_parted_partition" >> /var/log/dr_log
       echo "[Failed]"
    fi
}

function create_parted_repo_sc {

    exec 3>&2
    exec 2>/var/log/dr_log_detail
    set -x 
    echo "Create parted repo partition " >/var/log/dr_log 2>&1

    # In SC card there is no harddsik , so split the install repo in two
    
    #detach the install_repo partition 
    virsh detach-disk sysadmin /dev/sda2 >> /var/log/dr_log 2>&1
    # Delete the repo partition i.e sda2 , which is 4GB
    parted /dev/sda rm 2 >> /var/log/dr_log 2>&1
    #Create 2GB repo partition
    let repo_end=${DISK_HOST_BOOT_PART_SIZE}+${SC_NEW_REPO_SIZE_POST_DR}
    let dr_end=${repo_end}+${DR_PARTITION_SIZE}
    parted -s  /dev/sda mkpart partition02 ${DISK_HOST_BOOT_PART_SIZE} ${repo_end} >> /var/log/dr_log 2>&1 
    #Create 2GB DR partition
    parted -s  /dev/sda mkpart partition05 ${repo_end} ${dr_end} >> /var/log/dr_log 2>&1
    sync
    partprobe
    sleep 3
    # make  DR partition bootable
    parted -s /dev/sda set 5 boot on >> /var/log/dr_log 2>&1
    #format install repo  
    /sbin/mke2fs -t ext4 -L "Repository"  -b 4096 -vv  /dev/sda2  
    #format with fat16 
    /sbin/mkfs.vfat -F16 -n "RecoveryOs" /dev/sda5 >> /var/log/dr_log 2>&1
    sync

    # Attach install repo 
    #virsh attach-disk sysadmin /dev/sda2 vdn1 --cache=none
    # Attach DR partition
    #virsh attach-disk sysadmin /dev/sda5 vdm1 --cache=none

    set +x
    exec 2>&3
    exec 3>&-
    echo "[Success]"

}

function mount_debug_parition() {
    . /etc/init.d/mount_debug.sh
    set -e
    # The above script always mounts DP(debug partition) at /tmp/DEBUG
    # /tmp/DEBUG is link to the actual mount point which will
    # be like /tmp/bakelog.n29446
    echo "MNT_POINT=/tmp/DEBUG"
    set +e
}

function unmount_debug_partition() {
    set -e
    debugmnt=$(mount | grep "/tmp/bakelog" | grep "/dev/loop"|cut -d" " -f3)
    debugloop=$(mount | grep "/tmp/bakelog" | grep "/dev/loop"|cut -d" " -f1)
    if [ -n "${debugloop}" ]; then
       umount ${debugmnt}
       losetup -d ${debugloop}
       rm -rf ${debugmnt}
       rm /tmp/DEBUG
    fi
    set +e 
}

