#!/bin/bash
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
#
# Provides VRF app hosting functions
#
# Neil McGill
#

#
# Create a VRF. Currently only namespace style.
#
function app_hosting_vrf_create()
{
    local VRF=$1
    local STYLE=$2

    case $STYLE in
    *namespace*)
        app_hosting_vrf_create_namespace $*
        ;;
    *)
        false
        return
        ;;
    esac
}

#
# Ok to remove a VRF. Currently only namespace style.
#
function app_hosting_vrf_ok_to_remove()
{
    local VRF=$1
    local STYLE=$2

    case $STYLE in
    *namespace*)
        app_hosting_vrf_ok_to_remove_namespace $*
        ;;
    *)
        false
        return
        ;;
    esac
}

#
# Delete a VRF. Currently only namespace style.
#
function app_hosting_vrf_destroy()
{
    local VRF=$1
    local STYLE=$2

    case $STYLE in
    *namespace*)
        app_hosting_vrf_destroy_namespace $*
        ;;
    *)
        false
        return
        ;;
    esac
}

#
# Show processes using a VRF.
#
function app_hosting_vrf_show()
{
    local VRF=$1
    local STYLE=$2

    case $STYLE in
    *namespace*)
        app_hosting_vrf_show_namespace $*
        ;;
    *)
        false
        return
        ;;
    esac
}
