#!/bin/bash
#Debug_disk_mux.sh
#In case of continous restarts of a container
#this script is used to mount the data partition
#of the container and examine the logs to determine
#the reason for failure
#
# Caution: Use this script only when the container
# is not running.
# Copyright (c) 2015 by Cisco Systems, Inc.
#
#
# HELP
#
# Mount data partitions of the containers
#
# Usage: debug_disk_mount.sh -c <xr/cal/uvf> -v <0,1,2..>
#
#
# -c <xr/cal/uvf> : Container whose data-partition is to be mounted
#
# -v <volume>     : 0 - for calvados_data_lv0, 1 for calvados_data_lv1
#
#
# END_OF_HELP

help()
{
    cat $0 | sed '/^# HELP/,/^# END_OF_HELP/!d' | grep -v HELP | sed -e 's/^..//g' | sed 's/^#/ /g'
}




source /etc/rc.d/init.d/pd-functions


#function to do unmount and remvoe the directory
function debug_mnt_cleanup
{
    #unmount
    local DATA_DIR=''
    local DATA_LVM=''
    DATA_LVM=`lvdisplay | grep panini_vol_grp | grep data_lv | awk '{print $3}'`
    for i in `echo $DATA_LVM`
    do
        DATA_DIR=`echo $i| cut -f 4 -d "/"`
        type="log config scratch"
        array=($type)
        for (( j=0; j<3; j=j+1 ))
        do
            dir_log=`echo $1/$DATA_DIR/${array[j]}`
            echo "unmount $dir_log"
            umount -d  $dir_log
        done
     done

     #remove the directory
     rm -rf $1
}

case "$1" in
 status)
    pid=(`pidof -x $0`)
    if [ ${#pid[@]}  -gt 1 ]; then
        echo "$0 (pid $pid) is running ..."
    else
        echo "$0 is not running"
    fi
    exit 0
    ;;
esac


#In case PD override function exists
#execute that and bail

declare -F pd_mount_function >& /dev/null
if [ $? -eq 0 ]; then
   echo "Executing PD override"
   pd_mount_function
   exit
fi

CONTAINER="panini_vol_grp"
VOLUME="0"

while [ "$#" -ne 0 ];
do
    case $1 in
        -c )
            shift
            CONTAINER=$1
            ;;
        -v )
           shift
           VOLUME=$1
           ;;
        -h )
           help
           exit
      esac
      shift
done


DATA_LVM=`lvdisplay | grep panini_vol_grp | grep data_lv | awk '{print $3}'`
MNT_DIR=/tmp/tmp_mnt

#if directory exists due to previous run perform cleanup
if [ -d "$MNT_DIR" ]; then
    echo "$MNT_DIR exists. Cleaning it.."
    debug_mnt_cleanup $MNT_DIR
fi

#Mount the directory
for i in `echo $DATA_LVM`
do
    echo $i | grep "$CONTAINER"| grep lv$VOLUME -q
    if [ $? -eq 0 ]; then
        DATA_DIR=`echo $i| cut -f 4 -d "/"`
        mkdir -p $MNT_DIR/$DATA_DIR
        PARTITION=(`fdisk -ul  $i | sed -n '/lv[0-9]p[1-3]/ p' | awk '{print $2}'`)
        type="log config scratch"
        array=($type)

        #Mount log, config and scratch partitions
        for (( j=0; j<3; j=j+1 ))
        do
            dir_log=`echo $MNT_DIR/$DATA_DIR/${array[j]}`
            mkdir $dir_log
            OFFSET=${PARTITION[j]}
            OFFSET_BYTE=$((512 * OFFSET))
            mount -o loop,offset=$OFFSET_BYTE $i $dir_log
            if [ $? -ne 0 ]; then
              echo "Unable to mount dir_log: $i, $OFFSET_BYTE"
            fi
        done
    fi
done

echo "All data partitions are mounted under $MNT_DIR"


