#!/bin/bash
usage ()
{
  printf "\n\nUsage : Script <device e.g /dev/sda>\n" 
  printf "        If 'device' not given, will try to mount /dev/sda and /dev/sdb
 in sequence.\n\n"
  exit
}

if [ "$#" -gt 1 ]
then
  usage
fi

dev_name=${1}
exec 3>&1
exec 4>&2
exec 107>/tmp/`basename $0`.log
. /etc/init.d/disk-functions
function on_sim {
   local cmdline=`cat /proc/cmdline`
   local CMD_SIM=`echo $cmdline | sed 's/^.*simulator=//' | cut -d" " -f1`
   if [ "$CMD_SIM" == "true" ]; then
       return 1
   fi

   local qemu_440chk=`lspci |grep -i 440FX |wc -l`
   local qemu_cpuchk=`cat /proc/cpuinfo |grep QEMU | wc -l`
   if [ "$qemu_440chk" != "0" -a "$qemu_cpuchk" != "0" ]; then
        return 1
    else
        return 0
    fi
}

# Check if this is simulation environment
on_sim
if (( $? != 0 )); then
    SIM=1
else
    SIM=0

fi
rc=0
debugmnt=$(mount | grep "/tmp/bakelog" | grep "/dev/loop"|cut -d" " -f3)
if [ $SIM -eq 0 -a -z "${debugmnt}" ]; then
   LOGFLOWDIR=$(mktemp -d /tmp/bakelog.XXXXXX)
   if [ -n "${dev_name}" ]; then
      # Mount debug partition on given device
      get_dp_offset ${dev_name}
      prepare_dploop ${dev_name} user
      rc=$?
   else
      # Try mount on both sda and sdb
      get_dp_offset /dev/sda
      prepare_dploop /dev/sda user
      rc=$?
      if [ $? -ne 0 ]; then
         get_dp_offset /dev/sdb
         prepare_dploop /dev/sdb user
         rc=$?
      fi
   fi
fi
exec 1>&3-
exec 2>&4-
if (( $SIM )); then
   printf "\n\nRunning on SIMULATION PLATFORM\n\n"
   exit
fi
debugmnt=$(mount | grep "/tmp/bakelog" | grep "/dev/loop"|cut -d" " -f3)
debugloop=$(mount | grep "/tmp/bakelog" | grep "/dev/loop"|cut -d" " -f1)
if [ $rc -ne 0 -o -z "${debugmnt}" ]; then
   if [ -n "${debugloop}" ]; then
      losetup -d ${debugloop}
   fi
   printf "\n\nNo debug log partition found.\n\n"
   exit
fi
rm -rf /tmp/DEBUG
ln -sf ${debugmnt} /tmp/DEBUG
printf "\n\nDebug log partition mounted at /tmp/DEBUG\n\n"

