#!/bin/bash

# Copyright (c) 2012, 2014-2016 by cisco Systems, Inc.
# All rights reserved.

# do not exit on failed commands
set +e

XROOT="$1"

if [ -z "$XROOT" ]; then
    echo "Error! $XROOT not found"
    exit 1
fi

if [ ! -d "$XROOT" ]; then
    echo "Error! $XROOT not a directory"
    exit 2
fi

PLATFORM=`sed 's/^.*platform=//' /proc/cmdline | cut -d" " -f1`
echo $(date) "Starting Calvados patch for XR on $PLATFORM"

source ${XROOT}/etc/rc.d/init.d/spirit-functions
on_sim

# Perform any plaform specific patching on XR boot partition
#TBD ROSCO: what should happen here?
if [ "$VIRT_METHOD" = "vm" ] || [ $PLATFORM = "asr9k" ]; then
    declare -F xrnginstall_platform_patch_xr &>/dev/null &&
        xrnginstall_platform_patch_xr $XROOT $PLATFORM $SIMULATION      \
                                  $VIRT_METHOD

    fixup_alias "/sbin/service"
fi

echo $(date) "Finished Calvados patch for XR" 
exit 0


