#! /bin/bash


#------------------------------------------------------------------
# Sync docker config from host linux to XR
#
# April, 2016 Budhaditya Banerjee
#
# Copyright (c) 2016-2017 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------

# This script will sync /misc/app_host/etc/sysconfig/docker to 
# /etc/sysconfig/docker only if the two files are different 

# Source spirit_log.sh for syslog
source /etc/init.d/spirit_log.sh

MISC_SYSCONFIG=/misc/app_host/etc/sysconfig
DOCKER_FAILED=${MISC_SYSCONFIG}/docker.failed
ERROR_LINE=${MISC_SYSCONFIG}/error_line

if ! [ -f /etc/sysconfig/docker ]; then
    touch /etc/sysconfig/docker
fi 

cmp -s /etc/sysconfig/docker /misc/app_host/etc/sysconfig/docker > /dev/null
if [ $? -eq 1 ]; then
    cp /misc/app_host/etc/sysconfig/docker /etc/sysconfig/docker 
    platform_log_syslog_error "$( cat ${ERROR_LINE}).Incorrect config file has been saved as ${DOCKER_FAILED}"
    if [ -f $ERROR_LINE ]; then
        rm "$ERROR_LINE"
    fi
fi

