# -----------------------------------------------------------------------------
# otu_ma.bag/otu_per_port_info -- otu_ma/otu_per_port_info bag mapping for 
# openconfig-terminal-device
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------


octerminal_device__otu_ma___state_pre_fec_ber_overlay_node = { 
    "name" : "pre-fec-ber",
    "field-id": 1,
    "bag-mapping-nodes" : [
     {
         "bag-field" : "OtuFecSatistics",
         "bag-type"  : "subtype",
         "bag-mapping-nodes" : [
            {
              "bag-field" : "PreFecBer",
              "bag-type"  : "string",
              "overlay-nodes" : [
                  {
                     "name" : "instant",
                     "field-id" : 1,
                     "type" : "string"
                  }
              ]
            }
         ]
     }
    ]
}

octerminal_device__otu_ma___state_post_fec_ber_overlay_node = { 
    "name" : "post-fec-ber",
    "field-id": 2,
    "bag-mapping-nodes" : [
     {
         "bag-field" : "OtuFecSatistics",
         "bag-type"  : "subtype",
         "bag-mapping-nodes" : [
            {
              "bag-field" : "PostFecBer",
              "bag-type"  : "string",
              "overlay-nodes" : [
               {
                     "name" : "instant",
                     "field-id" : 1,
                     "type" : "string"
                }
              ]
            }
         ]
     }
    ]
}


octerminal_device__otu_ma__state_overlay_node = { 
    "name" : "state",
    "field-id": 1,
    "bag-mapping-nodes" : [
     {
       "bag-field" : "State",
       "bag-type" : "enum",
       "overlay-nodes" :
       [{"name" : "link-state",
         "field-id" : 1,
         "type" : "enum",
         "enum-map" : {
           0  : "DOWN", #NotReady
           1  : "DOWN", #AdminDown
           2  : "DOWN", #Down
           3  : "UP", #Up
           4  : "DOWN", #Shutdown
           5  : "DOWN", #ErrorDisable
           6  : "DOWN", #DownImmediate
           7  : "DOWN", #DownImmediateAdmin
           8  : "DOWN", #DownGraceful
           9  : "DOWN", #BeginShutdown
           10 : "DOWN", #EndShutdown
           11 : "DOWN", #BeginErrorDisable
           12 : "DOWN", #EndErrorDisable
           13 : "DOWN", #BeginDownGraceful
           14 : "DOWN", #Reset
           15 : "UP", #Operational
           16 : "DOWN", #Not Operational
           17 : "DOWN", #Unknown
           18 : "DOWN", #Last

         }
       }
       ]

     }
   ],
}

octerminal_device__otu_ma__otn_overlay_node = {
    "name" : "otn",
    "field-id" : 2,
    "overlay-nodes" :
    [
        {
          "name" : "state",
          "field-id" : 1,
           "overlay-nodes" :
             [ octerminal_device__otu_ma___state_pre_fec_ber_overlay_node,
                 octerminal_device__otu_ma___state_post_fec_ber_overlay_node,
             ],
           "bag-mapping-nodes" : [
                {
                    "bag-field" : "TTIMode",
                    "bag-type"  : "subtype",
                    "bag-mapping-nodes" : [
                          {
                              "bag-field" : "Rec",
                              "bag-type"  : "subtype",
                              "bag-mapping-nodes" : [
                                  {
                                      "bag-field" : "FullTtiAsciiString",
                                      "bag-type"  : "string",
                                      "overlay-nodes" : [
                                          {
                                              "name" : "tti-msg-rcv",
                                              "field-id" : 3,
                                              "type" : "string",
                                          }
                                       ]
                                  }
                               ] 
                          }
                     ]
                }
           ]
        }
        
    ]
}


mappings = {
    "overlay-model" : "openconfig-terminal-device",
    "bag-name" : "otu_per_port_info",
    "bag-file" : "otu_ma.bag",
    "xr-path" : "/oper/otu/if/<>/otu_port_info",
    "mpg-path": "RootOper.Otu.Interface.*",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0
      }
    ],
     
    "overlay-nodes" :
    [   {
        "name" : "openconfig-terminal-device:terminal-device",
        "namespace" : "http://openconfig.net/yang/terminal-device",
        "field-id" : 1,
        "overlay-nodes" :
        [ {
            "name" : "logical-channels",
            "field-id" : 1,
            "overlay-nodes" :
            [   {
                "name" : "channel",
                "field-id" : 1,
                "naming-element-nodes" :
                [
                    {
                    "index" : 0,
                    "name": "index",
                    "type": "string" ,
                    "field-id": 1,
                    "key": True,
                    "optical-logical-id" : True

                    }
                ],

                "overlay-nodes" :
                [ octerminal_device__otu_ma__state_overlay_node,
                  octerminal_device__otu_ma__otn_overlay_node
                ]

                }

            ]   

        }

        ] 
        }
    ]

}

# END BAG otu_ma
#################################################################

overlay_mappings = [mappings]

