# -----------------------------------------------------------------------------
# pmengine_ui.bag/pm_otn_paras -- pmengine_ui/pm_otn_paras bag mapping for openconfig-terminal-device
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

state_bag_mapping_nodes = [
    {
    "bag-field" : "ES_NE",
    "bag-type"  : "subtype",
    "bag-mapping-nodes" : [
        {
            "bag-field" : "Data",
            "bag-type" : "uint32",
            "overlay-nodes" : [
                                {"name" : "errored-seconds",
                                 "type" : "uint32",
                                 "field-id" : 3
                                }
                            ]
        }

    ]

    },
    
    {
            "bag-field" : "SES_NE",
            "bag-type" : "subtype",
            "bag-mapping-nodes" : [
                {
                    "bag-field" : "Data",
                    "bag-type"  : "uint32",
                    "overlay-nodes" : [
                                        {"name" : "severely-errored-seconds",
                                         "type" : "uint32",
                                         "field-id" : 4
                                        }
                                    ]
                }
            ]
                                
    },
                              
    {
            "bag-field" : "UAS_NE",
            "bag-type" : "subtype",
            "bag-mapping-nodes" : [
                {
                    "bag-field" : "Data",
                    "bag-type"  : "uint32",
                    "overlay-nodes" : [
                                        {"name" : "unavailable-seconds",
                                         "type" : "uint32",
                                         "field-id" : 5
                                        }
                                    ]

                }
            ]
    },
    {
            "bag-field" : "BBE_NE",
            "bag-type" : "subtype",
            "bag-mapping-nodes" : [
                {
                    "bag-field" : "Data",
                    "bag-type"  : "uint32",
                    "overlay-nodes" : [
                                        {"name" : "background-block-errors",
                                         "type" : "uint32",
                                         "field-id" : 6
                                        }
                                    ]

                }
            ]
    },


]


mappings = {
    "overlay-model" : "openconfig-terminal-device",
    "bag-name" : "pm_otn_paras",
    "bag-file" : "pmengine_ui.bag",
    # Cisco-IOS-XR-pmengine-oper:performance-management-history/global/periodic/otu-history/otu-port-histories/otu-port-history[name]/otu-second30-history/otu-second30otn-histories/otu-second30otn-history[n1]/otu-second30otn-time-line-instances/otu-second30otn-time-line-instance[n2]:
    # name-> logical-channels/channel/index, n1=0 and n2=1
    "sensor-path" : "Cisco-IOS-XR-pmengine-oper:performance-management-history/global/periodic/otu-history/otu-port-histories/otu-port-history/otu-second30-history/otu-second30otn-histories/otu-second30otn-history/otu-second30otn-time-line-instances/otu-second30otn-time-line-instance",
    "native-path" : "Cisco-IOS-XR-pmengine-oper:performance-management-history/global/periodic/otu-history/otu-port-histories/otu-port-history[name (xr:Interface-name)]/otu-second30-history/otu-second30otn-histories/otu-second30otn-history[number (int32)]/otu-second30otn-time-line-instances/otu-second30otn-time-line-instance[number]",
    "xr-path" : "/oper/perfmgmt/gl/periodic/otu/interface/<>/30sec/otn/0/timeline_rev/0x1",
    "mpg-path": "RootOper.PerfMgmt.Periodic.Otu.Interface(*).30sec.Otn(*).TimelineRev(*)",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0, 
      },
      {
       "type" : "string",
       "index" : 1,
      },
      {
        "type" : "string",
        "index" : 2
      }
    ],
     
    "overlay-nodes" :
    [   {
        "name" : "openconfig-terminal-device:terminal-device",
        "namespace" : "http://openconfig.net/yang/terminal-device",
        "field-id" : 1,
        "overlay-nodes" :
        [ {
            "name" : "logical-channels",
            "field-id" : 1,
            "overlay-nodes" :
            [   {
                "name" : "channel",
                "field-id" : 1,
                "naming-element-nodes" :
                [
                    {
                    "index" : 0,
                    "name": "index",
                    "type": "string" ,
                    "field-id": 1,
                    "key": True,
                    "optical-logical-id" : True

                    }
                ],

                "overlay-nodes" :
                [ {
                    "name" : "otn",
                    "field-id" : 2,
                    "overlay-nodes" : [
                        {
                            "name" : "state",
                            "field-id" : 1,
                            "bag-mapping-nodes" : 
                                state_bag_mapping_nodes
                           
                        }

                    ]

                  }
                ]

                }

            ]   

        }

        ] 
        }
    ]

}

# END BAG pm_otn_paras
#################################################################

overlay_mappings = [mappings]

