#!/bin/bash

# Copyright (c) 2012-2015 by cisco Systems, Inc.
# All rights reserved.

{
ROOT=$1
TIMESTAMP="$(LC_TIME=C date -u +%F_%R)"
TMPDIR="/var/tmp"
BACKUP="${BACKUP:-$TMPDIR/rpmdb-$TIMESTAMP}"
NEWDB="${NEWDB:-`mktemp -d -t newdb-XXXXXXXXXX`}"
DBHOME="${DBHOME:-$ROOT/rpmdb/lib/rpm}"
DBVERBOSE=1

DBERROR=0
DBREBUILD=0

echo "Root Dir is $ROOT"
echo "Backup for RPMDB restore is $BACKUP"
echo "New Dir for RPMDB creation is $NEWDB"
echo "RPMDB Home is $DBHOME"

tool_version=$(chroot ${ROOT} rpm --version | sed 's/^RPM version \([0-9]\+\.[0-9]\+\).*/\1/')
echo "Found RPM version $tool_version"

if [ $tool_version == "4.8" ]; then
    echo "Going ahead to convert RPMDB"
else
    PATH="/usr/lib/rpm-5.1.9:$PATH"
    echo "RPMDB needs no conversion"
    #exit 0
fi

for db_tool in db_stat db_dump db_load db_recover; do
    tool=$(which $db_tool 2> /dev/null)
    if [ -z "$tool" -o ! -x "$tool" ]; then
        echo "Unable to locate $db_tool"
        DBERROR=1
    else 
        tool_version="$($tool -V |sed 's/^Berkeley DB \([0-9]\+\.[0-9]\+\).*/\1/')"
        [ $DBVERBOSE -ne 0 ] && echo "Found $db_tool: $tool version: $tool_version"
        export $db_tool=$tool
    fi
done

if [ $DBERROR -ne 0 ]; then
    exit $DBERROR
fi

echo "Converting system database."
rm -rf "$NEWDB"
mkdir -p {"$DBHOME","$NEWDB"}/{log,tmp}

rm -f $DBHOME/__db*
for db_file in \
        Arch Filepaths Name Os Providename Release Seqno Sourcepkgid \
        Basenames Dirnames Group Nvra Provideversion Requirename Sha1header \
        Triggername Conflictname Filedigests Installtid Obsoletename Packages Pubkeys \
        Requireversion Sigmd5 Version
do
    test -f "$DBHOME/$db_file" && \
        $db_dump "$DBHOME/$db_file" \
             | $db_load $NEWDB/$db_file
done

echo "--> move old rpmdb files to $BACKUP"
mkdir -p "$BACKUP"
for db_file in \
        Arch Filepaths Name Os Providename Release Seqno Sourcepkgid \
        Basenames Dirnames Group Nvra Provideversion Requirename Sha1header \
        Triggername Conflictname Filedigests Installtid Obsoletename Packages Pubkeys \
        Requireversion Sigmd5 Version; do
test -f "$DBHOME/$db_file" && mv "$DBHOME/$db_file" "$BACKUP/$db_file"
done
echo "--> move new rpmdb files to $DBHOME"
for db_file in \
        Arch Filepaths Name Os Providename Release Seqno Sourcepkgid \
        Basenames Dirnames Group Nvra Provideversion Requirename Sha1header \
        Triggername Conflictname Filedigests Installtid Obsoletename Packages Pubkeys \
        Requireversion Sigmd5 Version; do
test -f "$NEWDB/$db_file" && mv "$NEWDB/$db_file" "$DBHOME"
done
rm -rf $NEWDB
exit 0
} > /tmp/logFile_DB
