#!/bin/bash

# Copyright (c) 2012, 2014-2017 by cisco Systems, Inc.
# All rights reserved.

# do not exit on failed commands
set +e

if [[ -z "${XR_SYSCTL_RC}" ]]; then
    source /etc/cisco/xr_sysctl.rc
fi
    
XROOT="$1"

if [ -z "$XROOT" ]; then
    echo "Error! $XROOT not found"
    exit 1
fi

if [ ! -d "$XROOT" ]; then
    echo "Error! $XROOT not a directory"
    exit 2
fi

PLATFORM=${IOS_XR_PLATFORM}
echo $(date) "Starting Calvados patch for XR on $PLATFORM"

source ${XROOT}/etc/rc.d/init.d/spirit_pd.sh
on_sim

SYS_INIT=${XROOT}/etc/rc.d/panini.sysinit
RC_SYSINIT=${XROOT}/etc/rc.d/rc.sysinit

# Perform any plaform specific patching on XR boot partition
#TBD ROSCO: what should happen here?
declare -F xrnginstall_platform_patch_xr &>/dev/null &&
     xrnginstall_platform_patch_xr $XROOT $PLATFORM $SIMULATION      \
                                  $VIRT_METHOD

if [ ${VIRT_METHOD} == "lxc" ];then

    #
    # It is very important that we create our /dev/shmem link before
    # any XR processes get to start. This includes early processes
    # like the oom killer that may run in panini.sysinit
    #
    sed -i '/mount.*remount.*shm/a	ln -sf \/dev\/shm \/dev\/shmem' ${RC_SYSINIT}

    cat >>${SYS_INIT} <<%%
if [ -f /dev/sde/vmm_default-sdr--1.cfg ]; then
    cp /dev/sde/vmm_default-sdr--1.cfg /dev/xr_bootstrap
fi

#
# Sanity check that /dev/shmem is indeed a symlink to /dev/shm
# If this is not the case then we are likely to get crashes as
# /dev/shmem will inherit the disk quota of /dev which is small!
#
if [ ! -L /dev/shmem ]; then
    echo
    echo "*** CRITCIAL ERROR: /dev/shmem is not a symlink. XR will crash. ***"
    echo
fi

cp /dev/sde/vmm_guest_bootstrap.cfg /dev/xr_bootstrap

#
# Souce platform functons to modify the bootstrap if needed
#
if [ -f /etc/init.d/spirit_pd.sh ]
then
    . /etc/init.d/spirit_pd.sh
fi

#
# Create a link for the default namespace outside global-vrf as this is easier
# for app hosting scripts to execute commands into.
#
ln -sf /proc/1/ns/net /var/run/netns/xrnns

#Create a link to global-vrf for back ward compatability with existing scripts
#that may still use tpnns for 3rd party applications
ln -sf /var/run/netns/global-vrf /var/run/netns/tpnns

declare -F platform_patch_xr_bootstrap &>/dev/null && platform_patch_xr_bootstrap /dev/xr_bootstrap
%%
    devc_con=`ls -l ${XROOT}/pkg/init.d/devc_conaux_con.init | awk '{print $11}'`
    devc_aux=`ls -l ${XROOT}/pkg/init.d/devc_conaux_aux.init | awk '{print $11}'`
 
    ACTIVE_SERIAL_XR_CON="pts/0"
    ACTIVE_SERIAL_XR_AUX="pts/1"

    #
    # Allow platform to override ACTIVE_SERIAL_XR_CON/AUX
    #
    declare -F platform_enable_xr_con &>/dev/null && platform_enable_xr_con
    sed -i "s;hvc0;$ACTIVE_SERIAL_XR_CON;g" ${XROOT}/${devc_con} 

    declare -F platform_enable_xr_aux &>/dev/null && platform_enable_xr_aux
    if [ -n "$ACTIVE_SERIAL_XR_AUX" ]; then
        sed -i "s;hvc1;$ACTIVE_SERIAL_XR_AUX;g" ${XROOT}/${devc_aux} 
    else
        rm -rf  ${XROOT}/${devc_aux}
    fi
fi

echo $(date) "Finished Calvados patch for XR" 
exit 0


