#! /usr/bin/env python
# Copyright (c) 2015-2016 by cisco Systems, Inc.
# All rights reserved.
#

import re	
import sys
import os
import optparse
import time
import glob
import pprint 
this_path = os.path.dirname(__file__)

all_arch_list = []

def read_text(arg_this_path):
    platform = 'platform'
    vm_list       = ['host','xr','admin']
    sdk_archs     = []
    rpm_mdata = {}

    rpm_list_files = glob.glob(os.path.join(arg_this_path,"release-rpms-*.txt"))
    if not rpm_list_files: 
        return {}
    for rpmf in rpm_list_files :
        m = re.search(r'(.*/)release-rpms-(.*)-(.*)(\.txt)', rpmf)
        if m :
            thisvm = m.groups()[1]
            sarch = m.groups()[2]
            sdk_archs.append(sarch)
     
    for sdk_arch in sdk_archs :
        for rpm_list_file in rpm_list_files :
            for vm in vm_list :
                vmstr = "-%s-"%(vm)
                if sdk_arch not in rpm_list_file :
                    continue
                if not vmstr in rpm_list_file :
                    continue
    
                if platform not in rpm_mdata.keys() :
                    rpm_mdata[platform] = {}
                if vm not in rpm_mdata[platform].keys() :
                    rpm_mdata[platform][vm] = {}
                if sdk_arch not in rpm_mdata[platform][vm].keys() :
                    rpm_mdata[platform][vm][sdk_arch] = {}
               
                fdin = open(os.path.join(this_path,rpm_list_file))
                for rpmfile in fdin.readlines() :
                    rpmfile = rpmfile.strip()
                    if rpmfile.endswith('.rpm'):
                        m = re.search(r'(.*/)*(.*)-(.*)-(.*)\.(.*)(\.rpm)', rpmfile)
                        if m:
                            name = m.groups()[1]
                            ver = m.groups()[2]
                            rel = m.groups()[3]
                            arch = m.groups()[4]
                            if arch not in all_arch_list :
                                all_arch_list.append(arch)
                            if name not in rpm_mdata[platform][vm][sdk_arch].keys():
                                rpm_mdata[platform][vm][sdk_arch][name] = {}
                            if arch not in rpm_mdata[platform][vm][sdk_arch][name].keys():
                                rpm_mdata[platform][vm][sdk_arch][name][arch] = [ver,rel]
                fdin.close() 
    if rpm_mdata[platform].has_key('admin'):
        rpm_mdata[platform]['host'] = rpm_mdata[platform]['admin']
    #pprint.pprint('--------------')
    #pprint.pprint(rpm_mdata)
    #pprint.pprint('--------------')
    return rpm_mdata

def main(options,args):
    input_rpms = args
    vm       = options.vmtype
    sdk_arch = options.sdk_arch
    file_path = options.flpath
    platform = 'platform'
    rpm_mdata = read_text(file_path)
    name = None
    ver  = None
    rel  = None

    output_rpm = []
    different_version = []
    # In case of given sdk ARCH all RPM applicable for given arch is returned
    if sdk_arch and not options.basepackage and sdk_arch in rpm_mdata[platform][vm].keys():
        # Called from self test
        for pkg_name in rpm_mdata[platform][vm][sdk_arch].keys() :
            for rpm_name in input_rpms :
                arch = None
                ignore, extension = os.path.splitext(rpm_name)
                if rpm_name.endswith('.rpm'):
                    m = re.search(r'(.*/)*(.*)-(.*)-(.*)\.(.*)(\.rpm)',rpm_name)
                    arch = m.groups()[4]
                elif extension[1:] in all_arch_list  :
                    m = re.search(r'(.*/)*(.*)-(.*)-(.*)\.(.*)', rpm_name)
                    arch = m.groups()[4]
                else :
                    m = re.search(r'(.*/)*(.*)-(.*)-(.*)', rpm_name)
                if m:
                    name = m.groups()[1]
                    ver = m.groups()[2]
                    rel = m.groups()[3]
                if name == pkg_name :  
                    if arch and rpm_mdata[platform][vm][sdk_arch][pkg_name].keys()[0] == arch :
                        ret_val = "%s-%s-%s.%s"%(name,ver,rel,rpm_mdata[platform][vm][sdk_arch][pkg_name].keys()[0])
                        if rpm_name.endswith(".rpm") :
                            ret_val = ret_val + ".rpm"
                        output_rpm.append(ret_val)
                    elif not arch :
                        ret_val = "%s-%s-%s.%s"%(name,ver,rel,rpm_mdata[platform][vm][sdk_arch][pkg_name].keys()[0])
                        if rpm_name.endswith(".rpm") :
                            ret_val = ret_val + ".rpm"
                        output_rpm.append(ret_val)

    elif options.basepackage :
        if not sdk_arch :
            s_arch = rpm_mdata[platform][vm].keys()
        else :
            s_arch = [sdk_arch]
        for sdk_arch in s_arch :
            if sdk_arch not in rpm_mdata[platform][vm].keys():
                continue
            for pkg_name in rpm_mdata[platform][vm][sdk_arch].keys() :
                for rpm_name in input_rpms :
                    arch = None
                    ignore, extension = os.path.splitext(rpm_name)
                    if rpm_name.endswith('.rpm'):
                        m = re.search(r'(.*/)*(.*)-(.*)-(.*)\.(.*)(\.rpm)',rpm_name)
                        arch = m.groups()[4]
                    elif extension[1:] in all_arch_list  :
                        m = re.search(r'(.*/)*(.*)-(.*)-(.*)\.(.*)', rpm_name)
                        arch = m.groups()[4]
                    else :
                        m = re.search(r'(.*/)*(.*)-(.*)-(.*)', rpm_name)
                    if m:
                        name = m.groups()[1]
                        ver = m.groups()[2]
                        rel = m.groups()[3]
                    if name == pkg_name :  
                        base_arch = rpm_mdata[platform][vm][sdk_arch][pkg_name].keys()[0]
                        base_ver = rpm_mdata[platform][vm][sdk_arch][pkg_name][base_arch][0]
                        base_rel = rpm_mdata[platform][vm][sdk_arch][pkg_name][base_arch][1]
                  
                        if arch and rpm_mdata[platform][vm][sdk_arch][pkg_name].keys()[0] == arch :
                            output_rpm.append("%s-%s-%s.%s"%(name,base_ver,base_rel,base_arch))
                        elif not arch :
                            output_rpm.append("%s-%s-%s.%s"%(name,base_ver,base_rel,base_arch))

    # in case of system level operation platform is considered 
    # e.g. usefull in add,activate,deactivate and remove cases
    else : 
        for rpm_name in input_rpms :
            arch = None
            ignore, extension = os.path.splitext(rpm_name)
            if rpm_name.endswith('.rpm'):
                m = re.search(r'(.*/)*(.*)-(.*)-(.*)\.(.*)(\.rpm)',rpm_name)
                arch = m.groups()[4]
            elif extension[1:] in all_arch_list  :
                m = re.search(r'(.*/)*(.*)-(.*)-(.*)\.(.*)', rpm_name)
                arch = m.groups()[4]
            else :
                m = re.search(r'(.*/)*(.*)-(.*)-(.*)', rpm_name)
            if m:
                name = m.groups()[1]
                ver = m.groups()[2]
                rel = m.groups()[3]
            else :
                continue
            if not rpm_mdata.has_key(platform):
                # In case of TP package , platform is not there , don't care
                continue
            for each_vm in rpm_mdata[platform].keys():
                v1 = None
                if not each_vm == vm :
                    continue
                for each_sarch in rpm_mdata[platform][each_vm].keys():
                    for pkg_name in rpm_mdata[platform][each_vm][each_sarch].keys() :
                        if name == pkg_name :
                            arch = rpm_mdata[platform][each_vm][each_sarch][pkg_name].keys()[0]
                            if v1 :
                                v2 = rpm_mdata[platform][each_vm][each_sarch][pkg_name][arch][0]
                                if not v1 == v2 : 
                                    different_version.append(rpm_name)
                            else :
                                v1 = rpm_mdata[platform][each_vm][each_sarch][pkg_name][arch][0]
                            output_rpm.append("%s-%s-%s.%s"%(name,ver,rel,arch))
    if options.different_version : 
        return different_version
    else :
        return set(output_rpm)

def get_platform():
    return 'platform'
    cal_cmd = 'rpm -qg \"sysadmin\" | cut -d"-" -f1 | sort | uniq'
    xr_cmd = 'rpm -qg \"IOS-XR\" | cut -d"-" -f1 | sort | uniq'
    try :
        platform = commands.getoutput(cal_cmd).strip()
        if platform :
            return platform
        else :
            platform = commands.getoutput(cal_cmd).strip()
            if platform :
                return platform
            sys.exit("Error: Failed to get platform")
    except:
        sys.exit("Error: hit an exception while getting platform")

def parsecli():
    oparser = optparse.OptionParser()
    oparser.add_option(
        "-a",
        "--arch",
        dest="sdk_arch",
        default=None,
        help="Architecture (e.g. arm | x86_64)")

    oparser.add_option(
        "-v",
        "--vmtype",
        dest="vmtype",
        default=None,
        help='VM tye (e.g. host | admin | XR )')

    oparser.add_option(
        "-p",
        "--path",
        dest="flpath",
        default=this_path,
        help='Path to release-rpms file  (e.g. /opt/cisco/calvados/bin )')

    oparser.add_option(
        "-d",
        "--different_version",
        dest="different_version",
        action='store_true',
        default=False,
        help='Get packages from given list, which are present as different version on differens architectures')

    oparser.add_option(
        "-t",
        "--time_taken",
        dest="time",
        action='store_true',
        default=False,
        help='Print time spent in executing it')

    oparser.add_option(
        "-b",
        "--basepackage",
        dest="basepackage",
        action='store_true',
        default=False,
        help='Get base package of given SMU package')

    options, args = oparser.parse_args()
    return options, args

if __name__ == '__main__' :
    t1 = time.time()
    options, args = parsecli()

    if not options.vmtype:
        sys.exit("Error: vmtype is needed")
    print ' '.join(list(main(options,args)))
    t2 = time.time()
    if options.time :
        print t2-t1

