#show_processes_mem - Script to show process memory info
#
# CLI file for show processes memory location <loc>
#
# Feb 2012, Kiran Mukkamala
#
# Copyright (c) 2010-2013, 2016 by Cisco Systems, Inc.
# All rights reserved.
#
#!/bin/bash

# Parsing arguments. 
while [ -n "$1" ]
do
    case "$1" in
        "-p")
            if [ -z "$2" ]; then
                echo "Invalid PID argument" >&2; exit 1;
            else
                PID=$2; shift 2;
            fi;;

        *) echo "Invalid arguments" >&2; exit 1;;
    esac
done

#echo "PID passed is $PID";

echo "PID         Text       Data      Stack    Dynamic Process"
echo "========================================================="

# Getting list of proc directories to be processed
if [ -z $PID ]
then
    files=/proc/[[:digit:]]*/status
else
    files=( /proc/${PID}/status )
fi

timestamp=`date +%s`
temp_result=/tmp/process_mem_$timestamp.log
if [ -f $temp_result ]
then
    rm $temp_result
fi

for file in $files
do
    if [ -f "$file" ]
    then
        read name vmsize data stack txt <<< `awk 'BEGIN { }
            /Name/ { print $2 }
            /VmSize/ { print $2 }
            /VmData/ { print $2 }
            /VmStk/ { print $2 }
            /VmExe/ { print $2 }
            END { }' ${file} `
        #skip kernel threads by checking vmsize
        if [ ! -z "$vmsize" ]
        then
            pid=`awk -v 'RS=\n' -F: '$1=="Pid" {gsub(/^[ \t]+/,"",$2); print $2}' "$file"`
            cmd="/opt/cisco/calvados/bin/proc_mem_helper ""$pid"
            heap="$(exec $cmd)"

            printf "%-7s %7s KB %7s KB %7s KB %10s KB %s\n" $pid $txt $data $stack $heap $name 1>>$temp_result 2>/dev/null
        fi
    fi
done

if [ -f "$temp_result" ]
then
    sort -gr -k 8 $temp_result
    rm $temp_result
fi

